/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.decentred.util;

import com.koloboke.function.IntObjConsumer;
import net.openhft.chronicle.core.io.IORuntimeException;
import net.openhft.chronicle.decentred.util.KolobokeIntObjMap;
import net.openhft.chronicle.decentred.util.SmallIntObjMap;
import net.openhft.chronicle.wire.AbstractMarshallable;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireOut;
import org.jetbrains.annotations.NotNull;

public abstract class IntObjMap<V>
extends AbstractMarshallable {
    Class<V> vClass;

    public static <V> IntObjMap<V> withExpectedSize(Class<V> vClass, int expectedSize) {
        if (expectedSize < 8) {
            return new SmallIntObjMap(expectedSize + 1);
        }
        KolobokeIntObjMap map = new KolobokeIntObjMap(expectedSize);
        map.vClass = vClass;
        return map;
    }

    public abstract void justPut(int var1, V var2);

    public abstract V get(int var1);

    public abstract int size();

    public abstract boolean containsKey(int var1);

    public abstract void clear();

    public abstract void forEach(IntObjConsumer<? super V> var1);

    public void readMarshallable(@NotNull WireIn wire) throws IORuntimeException {
        this.clear();
        while (wire.isNotEmptyAfterPadding()) {
            int k = (int)wire.readEventNumber();
            Object v = wire.getValueIn().object(this.vClass);
            this.justPut(k, v);
        }
    }

    public void writeMarshallable(@NotNull WireOut wire) {
        this.forEach((k, v) -> wire.writeEventId(k).object(this.vClass, v));
    }

    public abstract String toString();
}

