/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.decentred.util;

import java.lang.reflect.Method;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesIn;
import net.openhft.chronicle.core.util.ObjectUtils;
import net.openhft.chronicle.decentred.dto.VanillaSignedMessage;
import org.jetbrains.annotations.NotNull;

class DtoParselet<T> {
    private final Method method;
    private final int protocol;
    private final int midValue;
    private final VanillaSignedMessage vsm;

    public DtoParselet(Method method, int protocol, int midValue) {
        this.method = method;
        this.protocol = protocol;
        this.midValue = midValue;
        this.vsm = DtoParselet.createVSM(method, protocol, midValue);
    }

    public DtoParselet(DtoParselet parselet) {
        this.method = parselet.method;
        this.protocol = parselet.protocol;
        this.midValue = parselet.midValue;
        try {
            this.vsm = DtoParselet.createVSM(this.method, this.protocol, this.midValue);
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
    }

    @NotNull
    private static VanillaSignedMessage createVSM(Method method, int protocol, int messageType) {
        Class<?> type = method.getParameterTypes()[0];
        VanillaSignedMessage vsm = (VanillaSignedMessage)ObjectUtils.newInstance(type);
        return ((VanillaSignedMessage)vsm.protocol(protocol)).messageType(messageType);
    }

    public void parse(Bytes bytes, T listener) {
        this.vsm.readMarshallable((BytesIn)bytes);
        try {
            this.method.invoke(listener, this.vsm);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public String toString() {
        return "DtoParselet{method=" + this.method + ", protocol=" + this.protocol + ", midValue=" + this.midValue + ", vsm=" + this.vsm + '}';
    }
}

