/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.decentred.server;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.decentred.dto.EndOfRoundBlockEvent;
import net.openhft.chronicle.decentred.dto.SignedMessage;
import net.openhft.chronicle.decentred.dto.TransactionBlockEvent;
import net.openhft.chronicle.decentred.server.BlockReplayer;
import net.openhft.chronicle.decentred.util.DtoParser;
import net.openhft.chronicle.decentred.util.DtoRegistry;
import net.openhft.chronicle.decentred.util.LongLongMap;

public class VanillaBlockReplayer<T>
implements BlockReplayer {
    private final long address;
    private final T postBlockChainProcessor;
    private Map<Long, TransactionLog> transactionLogMap = new ConcurrentHashMap<Long, TransactionLog>();
    private EndOfRoundBlockEvent lastEndOfRoundBlockEvent = null;
    private LongLongMap replayedMap = LongLongMap.withExpectedSize(16);
    private DtoParser dtoParser;

    public VanillaBlockReplayer(long address, DtoRegistry<T> dtoRegistry, T postBlockChainProcessor) {
        this.address = address;
        this.dtoParser = dtoRegistry.get();
        this.postBlockChainProcessor = postBlockChainProcessor;
    }

    @Override
    public synchronized void transactionBlockEvent(TransactionBlockEvent transactionBlockEvent) {
        this.transactionLogMap.computeIfAbsent(transactionBlockEvent.address(), k -> new TransactionLog()).add(transactionBlockEvent);
        this.notifyAll();
    }

    @Override
    public synchronized void endOfRoundBlockEvent(EndOfRoundBlockEvent endOfRoundBlockEvent) {
        this.transactionLogMap.computeIfAbsent(endOfRoundBlockEvent.address(), k -> new TransactionLog()).add(endOfRoundBlockEvent);
        this.lastEndOfRoundBlockEvent = endOfRoundBlockEvent;
        this.notifyAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void replayBlocks() {
        ArrayList<Runnable> replayActions = new ArrayList<Runnable>();
        VanillaBlockReplayer vanillaBlockReplayer = this;
        synchronized (vanillaBlockReplayer) {
            if (this.lastEndOfRoundBlockEvent == null) {
                return;
            }
            try {
                for (Map.Entry<Long, TransactionLog> entry : this.transactionLogMap.entrySet()) {
                    int size;
                    long upto = this.lastEndOfRoundBlockEvent.addressToBlockNumberMap().getOrDefault(entry.getKey(), -1L);
                    if (upto == -1L) continue;
                    long last = this.replayedMap.getOrDefault(entry.getKey(), -1L);
                    while ((long)(size = entry.getValue().messages.size()) < upto) {
                        System.out.println(this.address + " Waiting ... " + size + " < " + upto);
                        this.wait(100L);
                    }
                    if (last >= (long)size) continue;
                    replayActions.add(() -> this.replay((TransactionLog)entry.getValue(), last + 1L, upto));
                    this.replayedMap.justPut(entry.getKey(), upto);
                }
            }
            catch (InterruptedException ie) {
                Jvm.warn().on(this.getClass(), "Giving up waiting - interrupted");
                Thread.currentThread().interrupt();
            }
            this.lastEndOfRoundBlockEvent = null;
        }
        for (Runnable replayAction : replayActions) {
            replayAction.run();
        }
    }

    private void replay(TransactionLog messages, long fromIndex, long toIndex) {
        for (long i = fromIndex; i <= toIndex; ++i) {
            SignedMessage message = messages.get((int)i);
            if (!(message instanceof TransactionBlockEvent)) continue;
            TransactionBlockEvent tbe = (TransactionBlockEvent)message;
            tbe.dtoParser(this.dtoParser);
            tbe.replay(this.postBlockChainProcessor);
        }
    }

    static class TransactionLog {
        private final List<SignedMessage> messages = new ArrayList<SignedMessage>();

        TransactionLog() {
        }

        public void add(TransactionBlockEvent transactionBlockEvent) {
            this.add(transactionBlockEvent, (int)transactionBlockEvent.blockNumber());
        }

        public void add(EndOfRoundBlockEvent endOfRoundBlockEvent) {
            this.add(endOfRoundBlockEvent, (int)endOfRoundBlockEvent.blockNumber());
        }

        synchronized void add(SignedMessage msg, int blockNumber) {
            if (blockNumber < this.messages.size()) {
                System.out.println("Duplicate message id: " + blockNumber + " size: " + this.messages.size() + " was " + msg.getClass());
            } else if (blockNumber > this.messages.size()) {
                System.out.println("Missing message id: " + blockNumber);
            } else if (msg instanceof TransactionBlockEvent) {
                this.messages.add((SignedMessage)((TransactionBlockEvent)msg).deepCopy());
            } else if (msg instanceof EndOfRoundBlockEvent) {
                this.messages.add((SignedMessage)((EndOfRoundBlockEvent)msg).deepCopy());
            } else {
                Jvm.warn().on(this.getClass(), "Unknown " + msg.getClass());
            }
        }

        synchronized SignedMessage get(int index) {
            return this.messages.get(index);
        }
    }
}

