/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.decentred.server;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.stream.LongStream;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.core.time.SystemTimeProvider;
import net.openhft.chronicle.decentred.api.MessageToListener;
import net.openhft.chronicle.decentred.dto.CreateAddressRequest;
import net.openhft.chronicle.decentred.dto.CreateChainRequest;
import net.openhft.chronicle.decentred.dto.CreateTokenRequest;
import net.openhft.chronicle.decentred.dto.EndOfRoundBlockEvent;
import net.openhft.chronicle.decentred.dto.InvalidationEvent;
import net.openhft.chronicle.decentred.dto.SignedMessage;
import net.openhft.chronicle.decentred.dto.TransactionBlockEvent;
import net.openhft.chronicle.decentred.dto.TransactionBlockGossipEvent;
import net.openhft.chronicle.decentred.dto.TransactionBlockVoteEvent;
import net.openhft.chronicle.decentred.dto.VerificationEvent;
import net.openhft.chronicle.decentred.server.BlockEngine;
import net.openhft.chronicle.decentred.server.BlockReplayer;
import net.openhft.chronicle.decentred.server.QueuingChainer;
import net.openhft.chronicle.decentred.server.VanillaBlockReplayer;
import net.openhft.chronicle.decentred.server.VanillaGossiper;
import net.openhft.chronicle.decentred.server.VanillaVoteTaker;
import net.openhft.chronicle.decentred.server.VanillaVoter;
import net.openhft.chronicle.decentred.util.DecentredUtil;
import net.openhft.chronicle.decentred.util.DtoRegistry;
import net.openhft.chronicle.threads.NamedThreadFactory;

public class VanillaBlockEngine<T>
implements BlockEngine,
Closeable {
    private final long address;
    private final long chainAddress;
    private final int periodUS;
    private final QueuingChainer chainer;
    private final VanillaGossiper gossiper;
    private final VanillaVoter voter;
    private final VanillaVoteTaker voteTaker;
    private final BlockReplayer blockReplayer;
    private final ExecutorService votingSes;
    private final ExecutorService processingSes;
    private final long[] clusterAddresses;
    private long blockNumber = 0L;
    private long nextSendUS;
    private MessageToListener tcpMessageListener;

    public VanillaBlockEngine(DtoRegistry<T> dtoRegistry, long address, long chainAddress, int periodMS, T postBlockChainProcessor, long[] clusterAddresses) {
        this.address = address;
        this.chainAddress = chainAddress;
        this.periodUS = periodMS * 1000;
        this.nextSendUS = (SystemTimeProvider.INSTANCE.currentTimeMicros() / (long)this.periodUS + 1L) * (long)this.periodUS;
        this.clusterAddresses = clusterAddresses;
        assert (LongStream.of(clusterAddresses).anyMatch(a -> a == address));
        this.chainer = new QueuingChainer(chainAddress, dtoRegistry);
        this.blockReplayer = new VanillaBlockReplayer<T>(address, dtoRegistry, postBlockChainProcessor);
        this.voteTaker = new VanillaVoteTaker(address, chainAddress, clusterAddresses, this.blockReplayer);
        this.voter = new VanillaVoter(address, clusterAddresses, this.voteTaker);
        this.gossiper = new VanillaGossiper(address, chainAddress, clusterAddresses, this.voter);
        String regionStr = DecentredUtil.toAddressString(chainAddress);
        this.votingSes = Executors.newSingleThreadExecutor((ThreadFactory)new NamedThreadFactory(regionStr + "-voter", Boolean.valueOf(true), Integer.valueOf(10)));
        this.processingSes = Executors.newSingleThreadExecutor((ThreadFactory)new NamedThreadFactory(regionStr + "-processor", Boolean.valueOf(true), Integer.valueOf(10)));
    }

    public static <T> VanillaBlockEngine<T> newMain(DtoRegistry<T> dtoRegistry, long address, int periodMS, long[] clusterAddresses, T postBlockChainProcessor) {
        assert (LongStream.of(clusterAddresses).distinct().count() == (long)clusterAddresses.length);
        long main = DecentredUtil.parseAddress("main");
        return new VanillaBlockEngine<T>(dtoRegistry, address, main, periodMS, postBlockChainProcessor, clusterAddresses);
    }

    public static <T> VanillaBlockEngine<T> newLocal(DtoRegistry<T> dtoRegistry, long address, long chainAddress, int periodMS, long[] clusterAddresses, T postBlockChainProcessor) {
        assert (LongStream.of(clusterAddresses).distinct().count() == (long)clusterAddresses.length);
        return new VanillaBlockEngine<T>(dtoRegistry, address, chainAddress, periodMS, postBlockChainProcessor, clusterAddresses);
    }

    @Override
    public void start(MessageToListener tcpMessageListener) {
        this.tcpMessageListener(tcpMessageListener);
        this.votingSes.submit(this::runVoter);
    }

    @Override
    public void tcpMessageListener(MessageToListener tcpMessageListener) {
        this.tcpMessageListener = tcpMessageListener;
        this.voter.tcpMessageListener(tcpMessageListener);
        this.voteTaker.tcpMessageListener(tcpMessageListener);
        this.gossiper.tcpMessageToListener(tcpMessageListener);
    }

    @Override
    public void transactionBlockEvent(TransactionBlockEvent transactionBlockEvent) {
        this.blockReplayer.transactionBlockEvent(transactionBlockEvent);
        this.gossiper.transactionBlockEvent(transactionBlockEvent);
    }

    @Override
    public void transactionBlockGossipEvent(TransactionBlockGossipEvent transactionBlockGossipEvent) {
        this.voter.transactionBlockGossipEvent(transactionBlockGossipEvent);
    }

    @Override
    public void transactionBlockVoteEvent(TransactionBlockVoteEvent transactionBlockVoteEvent) {
        this.voteTaker.transactionBlockVoteEvent(transactionBlockVoteEvent);
    }

    @Override
    public void endOfRoundBlockEvent(EndOfRoundBlockEvent endOfRoundBlockEvent) {
        this.blockReplayer.endOfRoundBlockEvent(endOfRoundBlockEvent);
    }

    @Override
    public void createChainRequest(CreateChainRequest createChainRequest) {
        this.chainer.onMessage(createChainRequest);
    }

    @Override
    public void createTokenRequest(CreateTokenRequest createTokenRequest) {
        this.chainer.onMessage(createTokenRequest);
    }

    @Override
    public void createAddressRequest(CreateAddressRequest createAddressRequest) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void verificationEvent(VerificationEvent verificationEvent) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void invalidationEvent(InvalidationEvent invalidationEvent) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void processOneBlock() {
        try {
            this.doProcessOneBlock();
            this.blockReplayer.replayBlocks();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new AssertionError((Object)e);
        }
    }

    void runVoter() {
        try {
            while (!Thread.currentThread().isInterrupted()) {
                this.doProcessOneBlock();
                this.processingSes.submit(this.blockReplayer::replayBlocks);
                this.nextSendUS += (long)this.periodUS;
                long delay = this.nextSendUS - SystemTimeProvider.INSTANCE.currentTimeMicros();
                if (delay <= 999L) continue;
                Thread.sleep(delay / 1000L);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private void doProcessOneBlock() throws InterruptedException {
        TransactionBlockEvent tbe = this.chainer.nextTransactionBlockEvent();
        if (tbe != null) {
            tbe.address(this.address);
            tbe.blockNumber(this.blockNumber);
            for (long clusterAddress : this.clusterAddresses) {
                if (clusterAddress == this.address) {
                    this.transactionBlockEvent(tbe);
                    continue;
                }
                this.tcpMessageListener.onMessageTo(clusterAddress, tbe);
            }
            ++this.blockNumber;
        }
        Thread.sleep(1L);
        this.gossiper.sendGossip(this.blockNumber);
        Thread.sleep(1L);
        this.voter.sendVote(this.blockNumber);
        Thread.sleep(1L);
        if (this.voteTaker.hasMajority() && this.voteTaker.sendEndOfRoundBlock(this.blockNumber)) {
            ++this.blockNumber;
        }
    }

    public void close() {
        this.votingSes.shutdownNow();
    }

    @Override
    public void onMessage(SignedMessage message) {
        this.chainer.onMessage(message);
    }
}

