/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.decentred.server;

import java.io.IOException;
import java.util.LinkedHashSet;
import java.util.Set;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.decentred.api.TransactionProcessor;
import net.openhft.chronicle.decentred.dto.CreateAddressEvent;
import net.openhft.chronicle.decentred.dto.CreateAddressRequest;
import net.openhft.chronicle.decentred.remote.rpc.RPCServer;
import net.openhft.chronicle.decentred.server.VanillaGateway;
import net.openhft.chronicle.decentred.util.DecentredUtil;
import net.openhft.chronicle.decentred.util.DtoRegistry;
import net.openhft.chronicle.salt.Ed25519;

public class RPCBuilder<T> {
    private final Class<T> tClass;
    private final DtoRegistry<T> dtoRegistry;
    private Bytes privateKey = Bytes.allocateDirect((long)32L);
    private Bytes publicKey = Bytes.allocateDirect((long)32L);
    private Bytes secretKey = Bytes.allocateDirect((long)64L);
    private Set<Long> clusterAddresses = new LinkedHashSet<Long>();
    private int mainBlockPeriodMS = 1000;
    private int localBlockPeriodMS = 100;
    private String region = "test";
    private boolean internal = false;

    private RPCBuilder(Class<T> tClass) {
        this.tClass = tClass;
        this.dtoRegistry = DtoRegistry.newRegistry(tClass);
    }

    public static <T> RPCBuilder<T> of(Class<T> tClass) {
        return new RPCBuilder<T>(tClass);
    }

    public RPCServer<T> createServer(int port, T mainTransactionProcessor, T localTransactionProcessor) throws IOException {
        return this.createServer("server:" + port, port, mainTransactionProcessor, localTransactionProcessor);
    }

    public RPCServer<T> createServer(String name, int port, T mainTransactionProcessor, T localTransactionProcessor) throws IOException {
        assert (mainTransactionProcessor instanceof TransactionProcessor);
        assert (localTransactionProcessor instanceof TransactionProcessor);
        if (this.publicKey.isEmpty() || this.secretKey.isEmpty()) {
            if (this.privateKey.isEmpty()) {
                Ed25519.generatePublicAndSecretKey((Bytes)this.publicKey, (Bytes)this.secretKey);
            } else {
                Ed25519.privateToPublicAndSecret((Bytes)this.publicKey, (Bytes)this.secretKey, (BytesStore)this.privateKey);
            }
        }
        long serverAddress = DecentredUtil.toAddress((BytesStore)this.publicKey);
        this.addClusterAddress(serverAddress);
        boolean addressAdded = this.clusterAddresses.add(serverAddress);
        long[] clusterAddressArray = this.clusterAddresses.stream().mapToLong(i -> i).toArray();
        VanillaGateway gateway = VanillaGateway.newGateway(this.dtoRegistry, serverAddress, this.region, clusterAddressArray, this.mainBlockPeriodMS, this.localBlockPeriodMS, mainTransactionProcessor, localTransactionProcessor);
        RPCServer server = new RPCServer<Object>(name, port, serverAddress, (BytesStore)this.publicKey, (BytesStore)this.secretKey, this.tClass, this.dtoRegistry, t -> gateway).internal(this.internal);
        ((TransactionProcessor)mainTransactionProcessor).messageRouter(server);
        ((TransactionProcessor)localTransactionProcessor).messageRouter(server);
        gateway.start(server);
        gateway.createAddressEvent(new CreateAddressEvent().createAddressRequest((CreateAddressRequest)new CreateAddressRequest().publicKey((BytesStore)this.publicKey)));
        if (addressAdded) {
            this.clusterAddresses.remove(serverAddress);
        }
        return server;
    }

    public RPCBuilder<T> addClusterAddress(long serverAddress) {
        this.clusterAddresses.add(serverAddress);
        return this;
    }

    public Bytes publicKey() {
        return this.publicKey;
    }

    public RPCBuilder<T> publicKey(Bytes publicKey) {
        this.publicKey = publicKey;
        return this;
    }

    public Bytes secretKey() {
        return this.secretKey;
    }

    public RPCBuilder<T> secretKey(Bytes secretKey) {
        this.secretKey = secretKey;
        return this;
    }

    public Set<Long> clusterAddresses() {
        return this.clusterAddresses;
    }

    public RPCBuilder<T> clusterAddresses(Set<Long> clusterAddresses) {
        this.clusterAddresses = clusterAddresses;
        return this;
    }

    public int mainBlockPeriodMS() {
        return this.mainBlockPeriodMS;
    }

    public RPCBuilder<T> mainBlockPeriodMS(int mainBlockPeriodMS) {
        this.mainBlockPeriodMS = mainBlockPeriodMS;
        return this;
    }

    public int localBlockPeriodMS() {
        return this.localBlockPeriodMS;
    }

    public RPCBuilder localBlockPeriodMS(int localBlockPeriodMS) {
        this.localBlockPeriodMS = localBlockPeriodMS;
        return this;
    }

    public String region() {
        return this.region;
    }

    public RPCBuilder<T> region(String region) {
        this.region = region;
        return this;
    }

    public boolean internal() {
        return this.internal;
    }

    public RPCBuilder<T> internal(boolean internal) {
        this.internal = internal;
        return this;
    }
}

