/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.decentred.remote.net;

import java.io.EOFException;
import java.io.IOException;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.SocketChannel;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.decentred.remote.net.AbstractTCPConnection;
import net.openhft.chronicle.decentred.remote.net.TCPServer;

public class VanillaTCPServerConnection
extends AbstractTCPConnection
implements Runnable {
    private final TCPServer tcpServer;

    public VanillaTCPServerConnection(TCPServer tcpServer, SocketChannel channel) throws SocketException {
        super(channel);
        this.tcpServer = tcpServer;
        channel.socket().setSendBufferSize(0x100000);
        channel.socket().setReceiveBufferSize(0x200000);
    }

    private static ByteBuffer[] createHeaderArray() {
        ByteBuffer header = ByteBuffer.allocateDirect(4).order(ByteOrder.LITTLE_ENDIAN);
        ByteBuffer[] ret = new ByteBuffer[]{header, null};
        return ret;
    }

    @Override
    public void run() {
        try {
            this.tcpServer.connectionListener().onNewConnection(this.tcpServer, this);
            Bytes readBytes = Bytes.elasticByteBuffer((int)0x100000);
            while (this.running) {
                this.readChannel((Bytes<ByteBuffer>)readBytes);
            }
        }
        catch (EOFException readBytes) {
        }
        catch (Throwable t) {
            Jvm.pause((long)1L);
            if (this.running) {
                t.printStackTrace();
            }
        }
        finally {
            this.tcpServer.connectionListener().onClosedConnection(this.tcpServer, this);
        }
    }

    @Override
    protected void waitForReconnect() {
    }

    @Override
    protected void onMessage(Bytes<ByteBuffer> bytes) throws IOException {
        this.tcpServer.connectionListener().onMessage(this.tcpServer, this, bytes);
    }

    @Override
    protected void close2() {
    }
}

