/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.decentred.dto;

import net.openhft.chronicle.bytes.BytesIn;
import net.openhft.chronicle.bytes.BytesOut;
import net.openhft.chronicle.core.io.IORuntimeException;
import net.openhft.chronicle.decentred.dto.VanillaSignedMessage;
import net.openhft.chronicle.decentred.util.AddressLongConverter;
import net.openhft.chronicle.decentred.util.DecentredUtil;
import net.openhft.chronicle.decentred.util.LongLongMap;
import net.openhft.chronicle.decentred.util.LongU32Writer;
import net.openhft.chronicle.wire.LongConversion;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireOut;
import org.jetbrains.annotations.NotNull;

public class TransactionBlockGossipEvent
extends VanillaSignedMessage<TransactionBlockGossipEvent> {
    @LongConversion(value=AddressLongConverter.class)
    private long chainAddress;
    private short weekNumber;
    private int blockNumber;
    private transient LongLongMap addressToBlockNumberMap;
    private transient LongU32Writer longU32Writer;

    public TransactionBlockGossipEvent blockNumber(long blockNumber) {
        this.blockNumber = (int)blockNumber;
        return this;
    }

    @Override
    public void readMarshallable(@NotNull WireIn wire) throws IORuntimeException {
        super.readMarshallable(wire);
        wire.read("addressToBlockNumberMap").marshallable(in -> {
            while (in.hasMore()) {
                String key = (String)in.readEvent(String.class);
                long addr = DecentredUtil.parseAddress(key);
                long value = in.getValueIn().int64();
                this.addressToBlockNumberMap().justPut(addr, value);
            }
        });
    }

    public void writeMarshallable(@NotNull WireOut wire) {
        super.writeMarshallable(wire);
        if (this.addressToBlockNumberMap != null && this.addressToBlockNumberMap.size() > 0) {
            wire.write((CharSequence)"addressToBlockNumberMap").marshallable(out -> this.addressToBlockNumberMap.forEach((k, v) -> out.write((CharSequence)DecentredUtil.toAddressString(k)).int64(v)));
        }
    }

    @Override
    public void readMarshallable(BytesIn bytes) throws IORuntimeException {
        this.chainAddress = bytes.readLong();
        this.weekNumber = bytes.readShort();
        this.blockNumber = bytes.readInt();
        int entries = (int)bytes.readStopBit();
        if (this.addressToBlockNumberMap == null) {
            this.addressToBlockNumberMap = LongLongMap.withExpectedSize(entries);
        }
        for (int i = 0; i < entries; ++i) {
            this.addressToBlockNumberMap.justPut(bytes.readLong(), bytes.readUnsignedInt());
        }
        assert (!this.addressToBlockNumberMap.containsKey(0L));
    }

    @Override
    public void writeMarshallable(BytesOut bytes) {
        bytes.writeLong(this.chainAddress);
        bytes.writeShort(this.weekNumber);
        bytes.writeInt(this.blockNumber);
        bytes.writeStopBit((long)this.addressToBlockNumberMap.size());
        if (this.longU32Writer == null) {
            this.longU32Writer = new LongU32Writer();
        }
        this.longU32Writer.bytes(bytes);
        this.addressToBlockNumberMap.forEach(this.longU32Writer);
    }

    public long chainAddress() {
        return this.chainAddress;
    }

    public TransactionBlockGossipEvent chainAddress(long chainAddress) {
        this.chainAddress = chainAddress;
        return this;
    }

    public LongLongMap addressToBlockNumberMap() {
        if (this.addressToBlockNumberMap == null) {
            this.addressToBlockNumberMap = LongLongMap.withExpectedSize(16);
        }
        return this.addressToBlockNumberMap;
    }
}

