/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.decentred.dto;

import net.openhft.chronicle.bytes.BytesIn;
import net.openhft.chronicle.bytes.BytesOut;
import net.openhft.chronicle.core.io.IORuntimeException;
import net.openhft.chronicle.decentred.dto.VanillaSignedMessage;
import net.openhft.chronicle.decentred.util.AddressLongConverter;
import net.openhft.chronicle.decentred.util.DecentredUtil;
import net.openhft.chronicle.decentred.util.LongLongMap;
import net.openhft.chronicle.decentred.util.LongU32Writer;
import net.openhft.chronicle.wire.IntConversion;
import net.openhft.chronicle.wire.LongConversion;
import net.openhft.chronicle.wire.UnsignedIntConverter;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireOut;
import org.jetbrains.annotations.NotNull;

public class EndOfRoundBlockEvent
extends VanillaSignedMessage<EndOfRoundBlockEvent> {
    @LongConversion(value=AddressLongConverter.class)
    private long chainAddress;
    @IntConversion(value=UnsignedIntConverter.class)
    private short weekNumber;
    @IntConversion(value=UnsignedIntConverter.class)
    private int blockNumber;
    private transient LongLongMap addressToBlockNumberMap;
    private transient LongU32Writer longU32Writer;

    public long chainAddress() {
        return this.chainAddress;
    }

    public EndOfRoundBlockEvent chainAddress(long chainAddress) {
        this.chainAddress = chainAddress;
        return this;
    }

    public int weekNumber() {
        return this.weekNumber & 0xFFFF;
    }

    public EndOfRoundBlockEvent weekNumber(int weekNumber) {
        this.weekNumber = (short)weekNumber;
        return this;
    }

    public long blockNumber() {
        return (long)this.blockNumber & 0xFFFFFFFFL;
    }

    public EndOfRoundBlockEvent blockNumber(long blockNumber) {
        this.blockNumber = (int)blockNumber;
        return this;
    }

    public LongLongMap addressToBlockNumberMap() {
        if (this.addressToBlockNumberMap == null) {
            this.addressToBlockNumberMap = LongLongMap.withExpectedSize(16);
        }
        return this.addressToBlockNumberMap;
    }

    @Override
    public void readMarshallable(BytesIn bytes) throws IORuntimeException {
        super.readMarshallable(bytes);
        this.addressToBlockNumberMap.justPut(bytes.readLong(), bytes.readUnsignedInt());
    }

    @Override
    protected void writeMarshallable0(BytesOut bytes) {
        super.writeMarshallable0(bytes);
        bytes.writeStopBit((long)this.addressToBlockNumberMap.size());
        if (this.longU32Writer == null) {
            this.longU32Writer = new LongU32Writer();
        }
        this.longU32Writer.bytes(bytes);
        this.addressToBlockNumberMap.forEach(this.longU32Writer);
    }

    @Override
    public void readMarshallable(@NotNull WireIn wire) throws IORuntimeException {
        super.readMarshallable(wire);
        wire.read("addressToBlockNumberMap").marshallable(in -> {
            while (in.hasMore()) {
                String key = (String)in.readEvent(String.class);
                long addr = DecentredUtil.parseAddress(key);
                long value = in.getValueIn().int64();
                this.addressToBlockNumberMap().justPut(addr, value);
            }
        });
    }

    public void writeMarshallable(@NotNull WireOut wire) {
        super.writeMarshallable(wire);
        wire.write((CharSequence)"addressToBlockNumberMap").marshallable(out -> this.addressToBlockNumberMap.forEach((k, v) -> out.write((CharSequence)DecentredUtil.toAddressString(k)).int64(v)));
    }

    @NotNull
    public <T> T deepCopy() {
        EndOfRoundBlockEvent eorbe = new EndOfRoundBlockEvent();
        eorbe.addressToBlockNumberMap = LongLongMap.withExpectedSize(this.addressToBlockNumberMap.size());
        eorbe.addressToBlockNumberMap.putAll(this.addressToBlockNumberMap);
        return (T)eorbe;
    }
}

