/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.scoped;

import java.io.Closeable;
import java.lang.reflect.Array;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.StackTrace;
import net.openhft.chronicle.core.scoped.AbstractScopedResource;
import net.openhft.chronicle.core.scoped.ScopedResource;
import net.openhft.chronicle.core.scoped.ScopedResourcePool;
import net.openhft.chronicle.core.scoped.StrongReferenceScopedResource;
import net.openhft.chronicle.core.scoped.WeakReferenceScopedResource;
import net.openhft.chronicle.core.threads.CleaningThreadLocal;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScopedThreadLocal<T>
implements ScopedResourcePool<T> {
    private final Supplier<T> supplier;
    private final Consumer<T> onAcquire;
    private final CleaningThreadLocal<SimpleStack> instancesTL;
    private final boolean useWeakReferences;

    public ScopedThreadLocal(Supplier<T> supplier, int maxInstances) {
        this(supplier, ScopedThreadLocal::noOp, maxInstances);
    }

    public ScopedThreadLocal(@NotNull Supplier<T> supplier, @NotNull Consumer<T> onAcquire, int maxInstances) {
        this(supplier, onAcquire, maxInstances, false);
    }

    public ScopedThreadLocal(@NotNull Supplier<T> supplier, @NotNull Consumer<T> onAcquire, int maxInstances, boolean useWeakReferences) {
        if (maxInstances <= 0) {
            throw new IllegalArgumentException("maxInstances must be > 0");
        }
        this.supplier = supplier;
        this.onAcquire = onAcquire;
        this.instancesTL = CleaningThreadLocal.withCloseQuietly(() -> new SimpleStack(maxInstances));
        this.useWeakReferences = useWeakReferences;
    }

    @Override
    public ScopedResource<T> get() {
        SimpleStack scopedThreadLocalResources = this.instancesTL.get();
        AbstractScopedResource<T> instance = scopedThreadLocalResources.isEmpty() ? this.createNewResource() : scopedThreadLocalResources.pop();
        instance.preAcquire();
        this.onAcquire.accept(instance.get());
        return instance;
    }

    private AbstractScopedResource<T> createNewResource() {
        if (this.useWeakReferences) {
            return new WeakReferenceScopedResource<T>(this, this.supplier);
        }
        return new StrongReferenceScopedResource<T>(this, this.supplier.get());
    }

    void returnResource(AbstractScopedResource<T> scopedResource) {
        SimpleStack scopedThreadLocalResources = this.instancesTL.get();
        scopedThreadLocalResources.push(scopedResource);
    }

    private static <T> void noOp(T instance) {
    }

    class SimpleStack
    implements Closeable {
        private final AbstractScopedResource<T>[] instances;
        private boolean warnedAboutCapacity = false;
        private int headIndex = -1;

        SimpleStack(int maxInstances) {
            this.instances = (AbstractScopedResource[])Jvm.uncheckedCast(Array.newInstance(AbstractScopedResource.class, maxInstances));
        }

        AbstractScopedResource<T> pop() {
            if (this.headIndex == -1) {
                throw new IllegalStateException("Can't pop an empty stack");
            }
            AbstractScopedResource instance = this.instances[this.headIndex];
            this.instances[this.headIndex] = null;
            --this.headIndex;
            return instance;
        }

        void push(AbstractScopedResource<T> instance) {
            if (this.headIndex < this.instances.length - 1) {
                this.instances[++this.headIndex] = instance;
            } else {
                if (!this.warnedAboutCapacity) {
                    @Nullable Class<?> containedType = this.instances[this.instances.length - 1].getType();
                    String message = "Pool capacity exceeded, consider increasing maxInstances, maxInstances=" + this.instances.length + (containedType != null ? ", resourceType=" + containedType.getSimpleName() : "");
                    Jvm.warn().on(ScopedThreadLocal.class, message, (Throwable)(Jvm.isResourceTracing() ? new StackTrace() : null));
                    this.warnedAboutCapacity = true;
                }
                this.replaceNewestInstance(instance).closeResource();
            }
        }

        private AbstractScopedResource<T> replaceNewestInstance(AbstractScopedResource<T> returningInstance) {
            long latestCreationTime = returningInstance.getCreatedTimeNanos();
            int latestCreationIndex = -1;
            for (int i = 0; i < this.instances.length; ++i) {
                if (this.instances[i].getCreatedTimeNanos() <= latestCreationTime) continue;
                latestCreationTime = this.instances[i].getCreatedTimeNanos();
                latestCreationIndex = i;
            }
            AbstractScopedResource instanceBeingDiscarded = returningInstance;
            if (latestCreationIndex >= 0) {
                instanceBeingDiscarded = this.instances[latestCreationIndex];
                this.instances[latestCreationIndex] = returningInstance;
            }
            return instanceBeingDiscarded;
        }

        boolean isEmpty() {
            return this.headIndex == -1;
        }

        @Override
        public void close() throws IllegalStateException {
            for (int i = 0; i < this.instances.length; ++i) {
                if (this.instances[i] == null) continue;
                this.instances[i].closeResource();
                this.instances[i] = null;
            }
        }
    }
}

