/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.internal.analytics;

import java.util.AbstractMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class StandardMaps {
    private static final long GIB = 0x40000000L;
    private static final Set<String> WHITE_LIST_CONTAINS = Stream.of(".demo", "run.chronicle").collect(Collectors.toSet());
    private static final Set<String> BLACK_LIST_EXACT = Stream.of("java.lang", "sun.reflect", "java.lang.reflect", "org.apache.maven").collect(Collectors.toSet());
    private static final Set<String> BLACK_LIST_STARTS_WITH = Stream.concat(BLACK_LIST_EXACT.stream(), Stream.of("software.chronicle", "org.junit", "net.openhft", "java", "jdk", "sun")).collect(Collectors.toSet());

    private StandardMaps() {
    }

    public static Map<String, String> standardEventParameters(@NotNull String appVersion) {
        ObjectUtils.requireNonNull(appVersion);
        return Stream.of(StandardMaps.entry("app_version", appVersion)).filter(e -> e.getValue() != null).collect(StandardMaps.toOrderedMap());
    }

    public static Map<String, String> standardAdditionalEventParameters() {
        return StandardMaps.standardAdditionalEventParameters(Thread.currentThread().getStackTrace());
    }

    public static Map<String, String> standardUserProperties() {
        return Stream.of(StandardMaps.entryFor("java.runtime.name"), StandardMaps.entryFor("java.runtime.version"), StandardMaps.entryFor("os.name"), StandardMaps.entryFor("os.arch"), StandardMaps.entryFor("os.version"), StandardMaps.entry(StandardMaps.replaceDotsWithUnderscore("timezone.default"), TimeZone.getDefault().getID()), StandardMaps.entry(StandardMaps.replaceDotsWithUnderscore("available.processors"), Integer.toString(Runtime.getRuntime().availableProcessors())), StandardMaps.entry(StandardMaps.replaceDotsWithUnderscore("max.memory.gib"), Long.toString(Runtime.getRuntime().maxMemory() / 0x40000000L)), StandardMaps.entry(StandardMaps.replaceDotsWithUnderscore("java.major.version"), Long.toString(Jvm.majorVersion())), StandardMaps.entry(StandardMaps.replaceDotsWithUnderscore("max.direct.memory.gib"), Long.toString(Jvm.maxDirectMemory() / 0x40000000L))).filter(e -> e.getValue() != null).collect(StandardMaps.toOrderedMap());
    }

    static Map<String, String> standardAdditionalEventParameters(@NotNull StackTraceElement[] stackTraceElements) {
        ObjectUtils.requireNonNull(stackTraceElements);
        AtomicInteger cnt = new AtomicInteger();
        HashSet distinctKeys = new HashSet();
        return Stream.of(stackTraceElements).map(StackTraceElement::getClassName).map(StandardMaps::packageName).filter(StandardMaps::shouldBeSent).filter(pn -> StandardMaps.distinctUpToMaxLevel3(pn, distinctKeys)).limit(3L).collect(StandardMaps.toOrderedMap(s -> "package_name_" + cnt.getAndIncrement(), Function.identity()));
    }

    static boolean distinctUpToMaxLevel3(String name, Set<String> set) {
        String packageNameUpToMaxLevel3 = StandardMaps.packageNameUpToMaxLevel3(name);
        return set.add(packageNameUpToMaxLevel3);
    }

    static String packageName(String className) {
        int lastDotIndex = className.lastIndexOf(46);
        if (lastDotIndex > 0) {
            return className.substring(0, lastDotIndex);
        }
        return className;
    }

    static String packageNameUpToMaxLevel3(String className) {
        if (className.isEmpty()) {
            return className;
        }
        int noDots = 0;
        int lastDotIndex = 0;
        for (int i = 0; i < className.length(); ++i) {
            char c = className.charAt(i);
            if ('.' != c) continue;
            lastDotIndex = i;
            if (++noDots >= 3) break;
        }
        if (lastDotIndex == 0) {
            return className;
        }
        return className.substring(0, lastDotIndex);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static boolean shouldBeSent(String packageName) {
        if (WHITE_LIST_CONTAINS.stream().anyMatch(packageName::contains)) return true;
        if (BLACK_LIST_EXACT.contains(packageName)) return false;
        if (!BLACK_LIST_STARTS_WITH.stream().noneMatch(packageName::startsWith)) return false;
        return true;
    }

    @NotNull
    private static <K, V> Collector<Map.Entry<K, V>, ?, LinkedHashMap<K, V>> toOrderedMap() {
        return StandardMaps.toOrderedMap(Map.Entry::getKey, Map.Entry::getValue);
    }

    @NotNull
    private static <T, K, V> Collector<T, ?, LinkedHashMap<K, V>> toOrderedMap(@NotNull Function<? super T, ? extends K> keyMapper, @NotNull Function<? super T, ? extends V> valueMapper) {
        return Collectors.toMap(keyMapper, valueMapper, (a, b) -> b, LinkedHashMap::new);
    }

    private static Map.Entry<String, String> entryFor(@NotNull String systemProperty) {
        return new AbstractMap.SimpleImmutableEntry<String, String>(StandardMaps.replaceDotsWithUnderscore(systemProperty), Jvm.getProperty(systemProperty));
    }

    private static Map.Entry<String, String> entry(@NotNull String key, @Nullable String value) {
        return new AbstractMap.SimpleImmutableEntry<String, String>(key, value);
    }

    private static String replaceDotsWithUnderscore(@NotNull String s) {
        return s.replace('.', '_');
    }
}

