/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.threads;

import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.BitSet;
import net.openhft.affinity.Affinity;
import net.openhft.affinity.AffinityLock;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.StackTrace;
import net.openhft.chronicle.core.threads.CleaningThreadLocal;
import org.jetbrains.annotations.Nullable;

public class CleaningThread
extends Thread {
    private static final Field THREAD_LOCALS = Jvm.getField(Thread.class, "threadLocals");
    private static final Field TABLE = Jvm.getField(THREAD_LOCALS.getType(), "table");
    private static final Field VALUE = Jvm.getField(TABLE.getType().getComponentType(), "value");
    private final boolean inEventLoop;
    private final StackTrace createdHere = Jvm.isResourceTracing() ? new StackTrace("Created here") : null;

    public CleaningThread(Runnable target) {
        super(target);
        this.inEventLoop = false;
    }

    public CleaningThread(Runnable target, String name) {
        this(target, name, false);
    }

    public CleaningThread(Runnable target, String name, boolean inEventLoop) {
        super(target, name);
        this.inEventLoop = inEventLoop;
    }

    public static void performCleanup(Thread thread) {
        CleaningThread.performCleanup(thread, null);
    }

    @Nullable
    private static Method getRemoveMethod(Object o) {
        Method remove;
        try {
            remove = o.getClass().getDeclaredMethod("remove", ThreadLocal.class);
            remove.setAccessible(true);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
        return remove;
    }

    public static void performCleanup(Thread thread, CleaningThreadLocal<?> ctl) {
        WeakReference[] table;
        Object o;
        try {
            o = THREAD_LOCALS.get(thread);
            if (o == null) {
                return;
            }
            table = (WeakReference[])TABLE.get(o);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            Jvm.debug().on(CleaningThreadLocal.class, e.toString());
            return;
        }
        if (table == null) {
            return;
        }
        Method remove = CleaningThread.getRemoveMethod(o);
        if (remove == null) {
            return;
        }
        CleaningThread.scanReferences(ctl, table, o, remove);
    }

    private static void scanReferences(CleaningThreadLocal<?> ctl, WeakReference<?>[] table, Object o, Method remove) {
        for (WeakReference reference : (WeakReference[])table.clone()) {
            try {
                Object value;
                Object key;
                Object v0 = key = reference != null ? reference.get() : null;
                if (!(key instanceof CleaningThreadLocal) || ctl != null && key != ctl || (value = VALUE.get(reference)) == null) continue;
                CleaningThreadLocal ctlKey = (CleaningThreadLocal)Jvm.uncheckedCast(key);
                ctlKey.cleanup(value);
                remove.invoke(o, key);
                if (ctl == null) continue;
                break;
            }
            catch (IllegalAccessException e) {
                Jvm.debug().on(CleaningThreadLocal.class, e.toString());
            }
            catch (Throwable e) {
                Jvm.debug().on(CleaningThreadLocal.class, e);
            }
        }
    }

    public static boolean inEventLoop(Thread t) {
        return t instanceof CleaningThread && ((CleaningThread)t).inEventLoop();
    }

    @Override
    public void run() {
        Jvm.debug().isEnabled(this.getClass());
        if (Affinity.getAffinity().cardinality() == 1) {
            Jvm.debug().on(this.getClass(), "Resetting affinity from " + Affinity.getAffinity() + " to " + AffinityLock.BASE_AFFINITY);
            Affinity.setAffinity((BitSet)AffinityLock.BASE_AFFINITY);
        }
        try {
            super.run();
        }
        finally {
            CleaningThread.performCleanup(this);
        }
    }

    public boolean inEventLoop() {
        return this.inEventLoop;
    }
}

