/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.threads;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.core.threads.CleaningThread;
import net.openhft.chronicle.core.util.ThrowingConsumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CleaningThreadLocal<T>
extends ThreadLocal<T> {
    private static final boolean DISABLE_CTL_ORPHAN_TRACKING = Jvm.getBoolean("disable.ctl.orphan.tracking");
    private static final Set<CleaningThreadLocal<?>> cleaningThreadLocals = Collections.synchronizedSet(new LinkedHashSet());
    @NotNull
    private final Supplier<T> supplier;
    @NotNull
    private final Function<T, T> getWrapper;
    @NotNull
    private final ThrowingConsumer<T, Exception> cleanup;
    private final boolean trackNonCleaningThreads;
    private Map<Thread, Object> nonCleaningThreadValues;

    private CleaningThreadLocal(Supplier<T> supplier, ThrowingConsumer<T, Exception> cleanup) {
        this(supplier, cleanup, UnaryOperator.identity());
    }

    private CleaningThreadLocal(Supplier<T> supplier, ThrowingConsumer<T, Exception> cleanup, UnaryOperator<T> getWrapper) {
        this(supplier, cleanup, getWrapper, null);
    }

    CleaningThreadLocal(Supplier<T> supplier, ThrowingConsumer<T, Exception> cleanup, UnaryOperator<T> getWrapper, Boolean overrideTrackNonCleaningThreads) {
        this.supplier = Objects.requireNonNull(supplier, "supplier");
        this.cleanup = Objects.requireNonNull(cleanup, "cleanup");
        this.getWrapper = Objects.requireNonNull(getWrapper, "getWrapper");
        boolean track = false;
        assert (track = this.enableOrphanTracking());
        this.trackNonCleaningThreads = !DISABLE_CTL_ORPHAN_TRACKING && (overrideTrackNonCleaningThreads != null ? overrideTrackNonCleaningThreads != false : track);
    }

    public static <T> CleaningThreadLocal<T> withCloseQuietly(Supplier<T> supplier) {
        return new CleaningThreadLocal<Object>(supplier, Closeable::closeQuietly);
    }

    public static <T> CleaningThreadLocal<T> withCleanup(ThrowingConsumer<T, Exception> cleanup) {
        return new CleaningThreadLocal<Object>(() -> null, cleanup);
    }

    public static <T> CleaningThreadLocal<T> withCleanup(Supplier<T> supplier, ThrowingConsumer<T, Exception> cleanup) {
        return new CleaningThreadLocal<T>(supplier, cleanup);
    }

    public static <T> CleaningThreadLocal<T> withCleanup(Supplier<T> supplier, ThrowingConsumer<T, Exception> cleanup, Function<T, T> getWrapper) {
        return new CleaningThreadLocal<T>(supplier, cleanup, getWrapper::apply);
    }

    public static void cleanupNonCleaningThreads() {
        if (cleaningThreadLocals.isEmpty()) {
            return;
        }
        cleaningThreadLocals.removeIf(CleaningThreadLocal::doCleanupNonCleaningThreads);
    }

    private boolean doCleanupNonCleaningThreads() {
        if (!this.trackNonCleaningThreads) {
            return true;
        }
        Iterator<Map.Entry<Thread, Object>> mapIt = this.nonCleaningThreadValues.entrySet().iterator();
        while (mapIt.hasNext()) {
            Map.Entry<Thread, Object> e = mapIt.next();
            if (e.getKey().isAlive()) continue;
            this.cleanup(Jvm.uncheckedCast(e.getValue()));
            mapIt.remove();
        }
        return this.nonCleaningThreadValues.isEmpty();
    }

    @Override
    protected T initialValue() {
        T value = this.supplier.get();
        if (this.trackNonCleaningThreads && !(Thread.currentThread() instanceof CleaningThread)) {
            this.nonCleaningThreadValues.put(Thread.currentThread(), value);
        }
        return value;
    }

    @Override
    public T get() {
        return this.getWrapper.apply(super.get());
    }

    @Override
    public void set(T value) {
        Thread thread = Thread.currentThread();
        if (thread instanceof CleaningThread) {
            CleaningThread.performCleanup(thread, this);
        } else if (this.trackNonCleaningThreads) {
            Object previous = this.nonCleaningThreadValues.put(thread, value);
            this.cleanup(previous);
        }
        super.set(value);
    }

    @Override
    public void remove() {
        Thread thread = Thread.currentThread();
        if (thread instanceof CleaningThread) {
            CleaningThread.performCleanup(thread, this);
        } else if (this.trackNonCleaningThreads) {
            Object previous = this.nonCleaningThreadValues.remove(thread);
            this.cleanup(previous);
        }
        super.remove();
    }

    private boolean enableOrphanTracking() {
        CleaningThreadLocal.cleanupNonCleaningThreads();
        cleaningThreadLocals.add(this);
        this.nonCleaningThreadValues = Collections.synchronizedMap(new LinkedHashMap());
        return true;
    }

    public synchronized void cleanup(@Nullable T value) {
        if (value == null) {
            return;
        }
        try {
            this.cleanup.accept(value);
        }
        catch (Exception ex) {
            Jvm.warn().on(this.getClass(), "Exception during cleanup of " + value.getClass(), (Throwable)ex);
        }
    }

    public String toString() {
        return "CleaningThreadLocal{trackedNonCleaningThreads=" + (this.nonCleaningThreadValues == null ? 0 : this.nonCleaningThreadValues.size()) + ", tracking=" + this.trackNonCleaningThreads + '}';
    }
}

