/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.onoes;

import net.openhft.chronicle.core.onoes.ExceptionHandler;
import net.openhft.chronicle.core.onoes.LogLevel;
import net.openhft.chronicle.core.util.ClassLocal;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum Slf4jExceptionHandler implements ExceptionHandler
{
    ERROR(Logger::error),
    WARN(Logger::warn),
    PERF(Logger::info),
    DEBUG(Logger::debug){

        @Override
        public boolean isEnabled(@NotNull Class<?> clazz) {
            return 1.getLogger(clazz).isDebugEnabled();
        }
    };

    private final LogMethod logMethod;
    static final ClassLocal<Logger> CLASS_LOGGER;

    private Slf4jExceptionHandler(LogMethod logMethod) {
        this.logMethod = logMethod;
    }

    @Override
    public void on(@NotNull Logger logger, @Nullable String message, @Nullable Throwable thrown) {
        try {
            this.logMethod.log(logger, message, thrown);
        }
        catch (Throwable t) {
            System.err.println("Failed to write to logger: " + logger.getName() + ", message: " + message);
            if (thrown != null) {
                System.err.println("Original exception: " + thrown.getMessage());
            }
            t.printStackTrace();
        }
    }

    @Override
    public void on(@NotNull Class<?> clazz, @Nullable String message, @Nullable Throwable thrown) {
        try {
            this.on(Slf4jExceptionHandler.getLogger(clazz), message, thrown);
        }
        catch (Throwable t) {
            System.err.println("Failed to write to logger: " + clazz + ", message: " + message);
            if (thrown != null) {
                System.err.println("Original exception: " + thrown.getMessage());
            }
            t.printStackTrace();
        }
    }

    static Logger getLogger(Class<?> clazz) {
        return (Logger)CLASS_LOGGER.get(clazz);
    }

    public static Slf4jExceptionHandler valueOf(LogLevel logLevel) {
        if (logLevel == LogLevel.ERROR) {
            return ERROR;
        }
        if (logLevel == LogLevel.WARN) {
            return WARN;
        }
        if (logLevel == LogLevel.PERF) {
            return PERF;
        }
        return DEBUG;
    }

    static {
        CLASS_LOGGER = ClassLocal.withInitial(LoggerFactory::getLogger);
    }

    @FunctionalInterface
    static interface LogMethod {
        public void log(Logger var1, String var2, Throwable var3);
    }
}

