/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.internal;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.internal.Bootstrap;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ClassUtil {
    private ClassUtil() {
    }

    public static Field getField0(@NotNull Class<?> clazz, @NotNull String name, boolean error, boolean setAccessible) {
        try {
            Field field = clazz.getDeclaredField(name);
            if (setAccessible) {
                ClassUtil.setAccessible(field);
            }
            return field;
        }
        catch (IllegalAccessError e) {
            if (error) {
                Jvm.warn().on(clazz, "Unable to access " + name + " " + e.getMessage());
            }
            return null;
        }
        catch (NoSuchFieldException e) {
            Field field;
            Class<?> superclass = clazz.getSuperclass();
            if (superclass != null && (field = ClassUtil.getField0(superclass, name, false, setAccessible)) != null) {
                return field;
            }
            if (error) {
                throw new AssertionError((Object)e);
            }
            return null;
        }
    }

    public static void setAccessible(@NotNull AccessibleObject accessibleObject) {
        block5: {
            if (Bootstrap.isJava9Plus()) {
                try {
                    if (SetAccessibleHolder.setAccessible0_Method == null) {
                        return;
                    }
                    boolean newFlag = SetAccessibleHolder.setAccessible0_Method.invokeExact(accessibleObject, true);
                    assert (newFlag);
                    break block5;
                }
                catch (Throwable throwable) {
                    throw new AssertionError((Object)throwable);
                }
            }
            accessibleObject.setAccessible(true);
        }
    }

    public static Method getMethod0(@NotNull Class<?> clazz, @NotNull String name, Class<?>[] args, boolean first) {
        try {
            Method method = clazz.getDeclaredMethod(name, args);
            if (!Modifier.isPublic(method.getModifiers()) || !Modifier.isPublic(method.getDeclaringClass().getModifiers())) {
                ClassUtil.setAccessible(method);
            }
            return method;
        }
        catch (NoSuchMethodException e) {
            Class<?> superclass = clazz.getSuperclass();
            if (superclass != null) {
                try {
                    Method m = ClassUtil.getMethod0(superclass, name, args, false);
                    if (m != null) {
                        return m;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (first) {
                throw new AssertionError((Object)e);
            }
            return null;
        }
    }

    static class SetAccessibleHolder {
        static final MethodHandle setAccessible0_Method = SetAccessibleHolder.getSetAccessible0Method();

        SetAccessibleHolder() {
        }

        private static MethodHandle getSetAccessible0Method() {
            if (!Bootstrap.isJava9Plus()) {
                return null;
            }
            MethodType signature = MethodType.methodType(Boolean.TYPE, Boolean.TYPE);
            try {
                Method privateLookupIn = MethodHandles.class.getDeclaredMethod("privateLookupIn", Class.class, MethodHandles.Lookup.class);
                MethodHandles.Lookup lookup = (MethodHandles.Lookup)privateLookupIn.invoke(null, AccessibleObject.class, MethodHandles.lookup());
                return lookup.findVirtual(AccessibleObject.class, "setAccessible0", signature);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | InvocationTargetException e) {
                Logger logger = LoggerFactory.getLogger(ClassUtil.class);
                logger.error("Chronicle products may require command line arguments to be provided for Java 11 and above. See https://chronicle.software/chronicle-support-java-17");
                return null;
            }
        }
    }
}

