/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.pool;

import java.lang.reflect.Array;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.util.BitSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.core.pool.ClassLookup;
import net.openhft.chronicle.core.util.ClassNotFoundRuntimeException;
import org.jetbrains.annotations.NotNull;

public class ClassAliasPool
implements ClassLookup {
    public static final ClassAliasPool CLASS_ALIASES = new ClassAliasPool(null).defaultAliases();
    static final ThreadLocal<CAPKey> CAP_KEY_TL = ThreadLocal.withInitial(() -> new CAPKey(null));
    private final ClassLookup parent;
    private final ClassLoader classLoader;
    private final Map<CAPKey, Class<?>> aliasClassMap = new ConcurrentHashMap();
    private final Map<CAPKey, Class<?>> nameClassMap = new ConcurrentHashMap();
    private final Map<CAPKey, ClassNotFoundRuntimeException> nameExceptionMap = new ConcurrentHashMap<CAPKey, ClassNotFoundRuntimeException>();
    private final Map<Class<?>, String> classStringMap = new ConcurrentHashMap();

    ClassAliasPool(ClassLookup parent, ClassLoader classLoader) {
        this.parent = parent;
        this.classLoader = classLoader;
    }

    ClassAliasPool(ClassLookup parent) {
        this.parent = parent;
        this.classLoader = (parent == null ? this : parent).getClass().getClassLoader();
    }

    public static void a(Class<?> clazz) {
        throw Jvm.rethrow((Throwable)((Object)new AssertionError(clazz)));
    }

    protected static boolean testPackage(String pkgName, Class<?> clazz) {
        return Jvm.getPackageName(clazz).startsWith(pkgName);
    }

    @NotNull
    private ClassAliasPool defaultAliases() {
        Class[] classes;
        this.addAlias(Set.class, "!set, Set");
        this.addAlias(BitSet.class, "!bitset, BitSet");
        this.addAlias(SortedSet.class, "!oset, SortedSet");
        this.addAlias(List.class, "!seq, List");
        this.addAlias(Map.class, "!map, Map");
        this.addAlias(SortedMap.class, "!omap, SortedMap");
        this.addAlias(String.class, "String, !str");
        this.addAlias(CharSequence.class);
        this.addAlias(Byte.class, "byte, int8, Byte");
        this.addAlias(Short.class, "short, int16, Short");
        this.addAlias(Character.class, "Char, Character");
        this.addAlias(Integer.class, "int, int32, Integer");
        this.addAlias(Long.class, "long, int64, Long");
        this.addAlias(Float.class, "Float32, Float");
        this.addAlias(Double.class, "Float64, Double");
        this.addAlias(LocalDate.class, "Date, LocalDate");
        this.addAlias(LocalDateTime.class, "DateTime, LocalDateTime");
        this.addAlias(LocalTime.class, "Time, LocalTime");
        this.addAlias(ZonedDateTime.class, "ZonedDateTime");
        this.addAlias(TimeUnit.class, "TimeUnit");
        this.addAlias(String[].class, "String[]");
        for (Class prim : classes = new Class[]{Boolean.TYPE, Byte.TYPE, Short.TYPE, Character.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE}) {
            this.addAlias(Array.newInstance(prim, 0).getClass(), prim.getName() + "[]");
        }
        this.addAlias(Byte[].class, "Byte[]");
        this.addAlias(Class.class, "type, class, Class");
        this.addAlias(Void.TYPE, "!null");
        return this;
    }

    public void clean() {
        this.clean(this.aliasClassMap.values());
        this.clean(this.nameClassMap.values());
        this.clean(this.classStringMap.keySet());
        this.resetResolutionFailures();
    }

    private void clean(@NotNull Iterable<Class<?>> coll) {
        ClassLoader classLoader2 = ClassAliasPool.class.getClassLoader();
        Iterator<Class<?>> iter = coll.iterator();
        while (iter.hasNext()) {
            Class<?> clazz = iter.next();
            ClassLoader cl = clazz.getClassLoader();
            if (cl == null || cl == classLoader2) continue;
            iter.remove();
        }
    }

    @Override
    @NotNull
    public Class<?> forName(@NotNull CharSequence name) throws ClassNotFoundRuntimeException {
        Objects.requireNonNull(name);
        CAPKey key = CAP_KEY_TL.get();
        key.value = name;
        Class<?> clazz = this.aliasClassMap.get(key);
        if (clazz != null) {
            return clazz;
        }
        return this.forName0(key);
    }

    @NotNull
    private synchronized Class<?> forName0(@NotNull CAPKey key) throws ClassNotFoundRuntimeException {
        ClassNotFoundRuntimeException resolutionFailure = this.nameExceptionMap.get(key);
        if (resolutionFailure != null) {
            throw resolutionFailure;
        }
        Class<?> clazz = this.nameClassMap.get(key);
        if (clazz != null) {
            return clazz;
        }
        String name0 = key.toString();
        CAPKey key2 = new CAPKey(name0);
        try {
            clazz = OS.isWindows() || OS.isMacOSX() ? this.doLookupWindowsOSX(name0) : this.doLookup(name0);
            this.nameClassMap.put(key2, clazz);
            return clazz;
        }
        catch (ClassNotFoundRuntimeException ex) {
            this.nameExceptionMap.put(key2, ex);
            throw ex;
        }
    }

    public void resetResolutionFailures() {
        this.nameExceptionMap.clear();
    }

    private Class<?> doLookupWindowsOSX(String name) {
        try {
            return this.doLookup(name);
        }
        catch (NoClassDefFoundError e) {
            throw new ClassNotFoundRuntimeException(new ClassNotFoundException(e.getMessage(), e));
        }
    }

    private Class<?> doLookup(String name) {
        if (this.banned(name)) {
            throw new ClassNotFoundRuntimeException(new ClassNotFoundException(name + " not available"));
        }
        try {
            return Class.forName(name, true, this.classLoader);
        }
        catch (ClassNotFoundException e) {
            if (this.parent != null) {
                return this.parent.forName(name);
            }
            throw new ClassNotFoundRuntimeException(e);
        }
    }

    private boolean banned(String name) {
        if (name.isEmpty()) {
            return true;
        }
        switch (name.charAt(0)) {
            case 'c': {
                return name.startsWith("com.sun.") || name.startsWith("com.oracle");
            }
            case 'j': {
                return name.startsWith("jdk.");
            }
            case 's': {
                return name.startsWith("sun.");
            }
        }
        return false;
    }

    @Override
    public String nameFor(Class<?> clazz) throws IllegalArgumentException {
        if (Jvm.isLambdaClass(clazz)) {
            throw new IllegalArgumentException("Class name for " + clazz + " isn't meaningful.");
        }
        String name = this.classStringMap.get(clazz);
        if (name != null) {
            return name;
        }
        if (this.parent != null) {
            return this.parent.nameFor(clazz);
        }
        return this.nameFor0(clazz);
    }

    private String nameFor0(Class<?> clazz) {
        Class<?> clazz2;
        if (Enum.class.isAssignableFrom(clazz) && (clazz2 = clazz.getSuperclass()) != null && clazz2 != Enum.class && Enum.class.isAssignableFrom(clazz2)) {
            String alias = this.classStringMap.get(clazz2);
            if (alias != null) {
                this.classStringMap.putIfAbsent(clazz, alias);
                return alias;
            }
            return clazz2.getName();
        }
        return clazz.getName();
    }

    public void removePackage(String pkgName) {
        this.aliasClassMap.entrySet().removeIf(e -> ClassAliasPool.testPackage(pkgName, (Class)e.getValue()));
        this.nameClassMap.entrySet().removeIf(e -> ClassAliasPool.testPackage(pkgName, (Class)e.getValue()));
        this.classStringMap.entrySet().removeIf(e -> ClassAliasPool.testPackage(pkgName, (Class)e.getKey()));
        this.resetResolutionFailures();
    }

    @Override
    public void addAlias(Class<?> ... classes) {
        for (Class<?> clazz : classes) {
            Class<?> prev = this.aliasClassMap.putIfAbsent(new CAPKey(clazz.getName()), clazz);
            this.warnIfChanged(prev, clazz, "Did not replace by name");
            prev = this.nameClassMap.putIfAbsent(new CAPKey(clazz.getSimpleName()), clazz);
            this.warnIfChanged(prev, clazz, "Did not replace by simpleName");
            this.nameClassMap.putIfAbsent(new CAPKey(this.toCamelCase(clazz.getSimpleName())), clazz);
            this.classStringMap.computeIfAbsent(clazz, Class::getSimpleName);
        }
        this.resetResolutionFailures();
    }

    @NotNull
    private String toCamelCase(@NotNull String name) {
        return Character.toLowerCase(name.charAt(0)) + name.substring(1);
    }

    @Override
    public void addAlias(Class<?> clazz, @NotNull String names) {
        for (String name : names.split(", ?")) {
            Class<?> prev = this.aliasClassMap.put(new CAPKey(name), clazz);
            this.warnIfChanged(prev, clazz, "Replaced");
            this.nameClassMap.putIfAbsent(new CAPKey(this.toCamelCase(name)), clazz);
            this.classStringMap.putIfAbsent(clazz, name);
            Class<?> prev1 = this.aliasClassMap.putIfAbsent(new CAPKey(clazz.getName()), clazz);
            this.warnIfChanged(prev1, clazz, "Did not replace by name");
        }
        this.resetResolutionFailures();
    }

    @Override
    public CharSequence applyAlias(CharSequence name) {
        Objects.requireNonNull(name);
        CAPKey key = CAP_KEY_TL.get();
        key.value = name;
        Class<?> clazz = this.aliasClassMap.get(key);
        if (clazz != null) {
            return this.nameFor(clazz);
        }
        clazz = this.nameClassMap.get(key);
        if (clazz != null) {
            return this.nameFor(clazz);
        }
        return name;
    }

    private void warnIfChanged(Class<?> prev, Class<?> clazz, String msg) {
        if (prev != null && prev != clazz) {
            Jvm.warn().on(this.getClass(), msg + " " + prev + " with " + clazz);
        }
    }

    public static void a(Class<?> ... classes) {
        CLASS_ALIASES.addAlias(classes);
    }

    static final class CAPKey
    implements CharSequence {
        CharSequence value;

        CAPKey(String name) {
            this.value = name;
        }

        @Override
        public int length() {
            return this.value.length();
        }

        @Override
        public char charAt(int index) throws IndexOutOfBoundsException {
            return this.value.charAt(index);
        }

        @Override
        @NotNull
        public CharSequence subSequence(int start, int end) {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public String toString() {
            return this.value.toString();
        }

        public int hashCode() {
            if (this.value instanceof String) {
                return this.value.hashCode();
            }
            int h = 0;
            for (int i = 0; i < this.value.length(); ++i) {
                h = 31 * h + this.charAt(i);
            }
            return h;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof CharSequence)) {
                return false;
            }
            CharSequence cs = (CharSequence)obj;
            if (cs instanceof CAPKey) {
                cs = ((CAPKey)cs).value;
            }
            if (this.length() != cs.length()) {
                return false;
            }
            if (this.value instanceof String && cs instanceof String) {
                return this.value.equals(cs);
            }
            for (int i = 0; i < this.length(); ++i) {
                if (this.charAt(i) == cs.charAt(i)) continue;
                return false;
            }
            return true;
        }
    }
}

