/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.util;

import java.util.Objects;
import java.util.function.Function;
import java.util.function.LongPredicate;
import net.openhft.chronicle.core.internal.invariant.longs.LongCondition;
import net.openhft.chronicle.core.util.LongBiPredicate;

public final class Longs {
    private Longs() {
    }

    public static long requireNonNegative(long value) {
        if (value < 0L) {
            throw new IllegalArgumentException("The provided value (" + value + ") is negative");
        }
        return value;
    }

    public static long requirePositive(long value) {
        if (value <= 0L) {
            throw new IllegalArgumentException("The provided value (" + value + ") is not positive");
        }
        return value;
    }

    public static <X extends RuntimeException> long require(LongPredicate requirement, long value, Function<String, X> exceptionMapper) {
        Objects.requireNonNull(exceptionMapper);
        if (!requirement.test(value)) {
            throw (RuntimeException)exceptionMapper.apply(Longs.failDescription(requirement, value));
        }
        return value;
    }

    public static boolean assertIfEnabled(LongBiPredicate requirement, long value, long otherValue) {
        return true;
    }

    private static String failDescription(LongPredicate requirement, long value) {
        return String.format("The provided value (%d) is illegal because it does not satisfy the provided requirement: %d %s", value, value, requirement);
    }

    private static String failDescription(LongBiPredicate requirement, long value, long otherValue) {
        return String.format("The provided value (%d) is illegal because it does not satisfy the provided requirement: %d %s %d", value, value, requirement, otherValue);
    }

    public static LongPredicate nonNegative() {
        return LongCondition.NON_NEGATIVE;
    }
}

