/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.io;

import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.Maths;
import net.openhft.chronicle.core.UnsafeMemory;

public final class UnsafeText {
    public static final long MASK32 = 0xFFFFFFFFL;
    private static final long MAX_VALUE_DIVIDE_5 = 0x1999999999999999L;
    private static final String MIN_VALUE_STR = "-9223372036854775808";
    private static final long ARRAY_BYTE_BASE_OFFSET = Jvm.arrayByteBaseOffset();
    static final ThreadLocal<StringBuilder> TL_SB = ThreadLocal.withInitial(StringBuilder::new);

    private UnsafeText() {
    }

    public static long appendFixed(long address, long num) {
        long div;
        if (num < 0L) {
            if (num > Long.MIN_VALUE) {
                UnsafeMemory.MEMORY.writeByte(address++, (byte)45);
                num = -num;
            } else {
                return UnsafeText.appendText(address, MIN_VALUE_STR);
            }
        }
        long start = address;
        do {
            div = num / 10L;
            long mod = num % 10L;
            UnsafeMemory.MEMORY.writeByte(address++, (byte)(48L + mod));
        } while ((num = div) > 0L);
        UnsafeText.reverseTheOrder(address, start);
        return address;
    }

    private static void reverseTheOrder(long address, long start) {
        int end = (int)(address - start) - 1;
        for (int i = 0; i < end; ++i, --end) {
            long a1 = start + (long)i;
            long a2 = start + (long)end;
            byte b1 = UnsafeMemory.UNSAFE.getByte(a1);
            byte b2 = UnsafeMemory.UNSAFE.getByte(a2);
            UnsafeMemory.MEMORY.writeByte(a2, b1);
            UnsafeMemory.MEMORY.writeByte(a1, b2);
        }
    }

    public static long appendFixed(long address, double num, int digits) {
        long tens = Maths.tens(digits);
        double mag = num * (double)tens;
        if (Math.abs(mag) < 9.007199254740992E15) {
            long num2 = Math.round(mag);
            return UnsafeText.appendBase10d(address, num2, digits);
        }
        return UnsafeText.appendDouble(address, num);
    }

    public static long appendBase10d(long address, long num, int decimal) {
        long div;
        if (num < 0L) {
            if (num > Long.MIN_VALUE) {
                UnsafeMemory.MEMORY.writeByte(address++, (byte)45);
                num = -num;
            } else {
                throw new AssertionError();
            }
        }
        long start = address;
        do {
            div = num / 10L;
            long mod = num % 10L;
            UnsafeMemory.MEMORY.writeByte(address++, (byte)(48L + mod));
            if (--decimal != 0) continue;
            UnsafeMemory.MEMORY.writeByte(address++, (byte)46);
        } while ((num = div) > 0L || decimal >= 0);
        UnsafeText.reverseTheOrder(address, start);
        return address;
    }

    public static long appendDouble(long address, double d) {
        double abs = Math.abs(d);
        if (5.0E-10 > abs || abs > 1.0E31) {
            return UnsafeText.appendDoubleString(address, d);
        }
        return UnsafeText.appendDouble0(address, d);
    }

    static long appendDouble0(long address, double d) {
        int shift;
        long val = Double.doubleToRawLongBits(d);
        int sign = (int)(val >>> 63);
        int exp = (int)(val >>> 52 & 0x7FFL);
        long mantissa = val & 0xFFFFFFFFFFFFFL;
        if (sign != 0) {
            UnsafeMemory.MEMORY.writeByte(address++, (byte)45);
        }
        if (exp == 0 && mantissa == 0L) {
            UnsafeMemory.MEMORY.writeByte(address, (byte)48);
            UnsafeMemory.UNSAFE.putShort(address + 1L, (short)12334);
            return address += 3L;
        }
        if (exp == 2047) {
            return UnsafeText.appendText(address, mantissa == 0L ? "Infinity" : "NaN");
        }
        if (exp > 0) {
            mantissa += 0x10000000000000L;
        }
        if ((shift = 1075 - exp) > 0) {
            if (shift < 53) {
                return UnsafeText.appendIntegerAndFraction(address, d, sign, mantissa, shift);
            }
            return UnsafeText.appendFraction(address, d, sign, mantissa, shift);
        }
        return UnsafeText.appendLargeNumber(address, mantissa, shift);
    }

    static long appendDoubleString(long address, double d) {
        StringBuilder sb = TL_SB.get();
        sb.setLength(0);
        sb.append(d);
        for (int i = 0; i < sb.length(); ++i) {
            UnsafeMemory.UNSAFE.putByte(address++, (byte)sb.charAt(i));
        }
        return address;
    }

    private static long appendLargeNumber(long address, long mantissa, int shift) {
        mantissa <<= 10;
        int precision = -10 - shift;
        int digits = 0;
        while ((precision > 53 || mantissa > Long.MAX_VALUE >> precision) && precision > 0) {
            ++digits;
            --precision;
            long mod = mantissa % 5L;
            mantissa /= 5L;
            int modDiv = 1;
            while (mantissa < 0x1999999999999999L && precision > 1) {
                --precision;
                mantissa <<= 1;
                modDiv <<= 1;
            }
            mantissa += (long)modDiv * mod / 5L;
        }
        long val2 = precision > 0 ? mantissa << precision : mantissa >>> -precision;
        address = UnsafeText.appendFixed(address, val2);
        for (int i = 0; i < digits; ++i) {
            UnsafeMemory.MEMORY.writeByte(address++, (byte)48);
        }
        return address;
    }

    private static long appendFraction(long address, double d, int sign, long mantissa, int shift) {
        long value2;
        double parsedValue;
        long value = 0L;
        int digits = -1;
        mantissa <<= 9;
        shift += 9;
        do {
            if (shift < 63) {
                value = value * 10L + (mantissa >> shift);
                mantissa &= (1L << shift) - 1L;
            }
            if (mantissa >= 0x1999999999999999L) {
                mantissa >>>= 3;
                shift -= 3;
            }
            mantissa *= 5L;
            --shift;
            ++digits;
        } while ((double)value < 1.0E17);
        long value3 = value;
        while ((parsedValue = Maths.asDouble(value2 = (value + 5L) / 10L, 0, sign != 0, digits - 1)) == d) {
            --digits;
            value3 = value2;
            value /= 10L;
        }
        UnsafeMemory.UNSAFE.putShort(address, (short)11824);
        long addressOfLastNonZero = (address += 2L) + (long)digits;
        do {
            long num = value3 % 10L;
            char c = (char)(48L + num);
            UnsafeMemory.MEMORY.writeByte(address + (long)(--digits), (byte)c);
        } while ((value3 /= 10L) > 0L);
        while (digits > 0) {
            UnsafeMemory.UNSAFE.putByte(address + (long)(--digits), (byte)48);
        }
        return addressOfLastNonZero;
    }

    private static long appendIntegerAndFraction(long address, double d, int sign, long mantissa, int shift) {
        long intValue = mantissa >> shift;
        address = UnsafeText.appendFixed(address, intValue);
        if ((mantissa -= intValue << shift) > 0L) {
            long num;
            UnsafeMemory.MEMORY.writeByte(address++, (byte)46);
            mantissa <<= 1;
            ++mantissa;
            int precision = shift + 1;
            long value = intValue;
            int decimalPlaces = 0;
            for (long error = 1L; mantissa > error; error *= 5L, mantissa -= num << precision) {
                num = (mantissa *= 5L) >> --precision;
                value = value * 10L + num;
                UnsafeMemory.MEMORY.writeByte(address++, (byte)(48L + num));
                double parsedValue = Maths.asDouble(value, 0, sign != 0, ++decimalPlaces);
                if (parsedValue != d) continue;
                break;
            }
        } else {
            UnsafeMemory.UNSAFE.putShort(address, (short)12334);
            address += 2L;
        }
        return address;
    }

    private static long appendText(long address, String s) {
        for (int i = 0; i < s.length(); ++i) {
            UnsafeMemory.MEMORY.writeByte(address++, (byte)s.charAt(i));
        }
        return address;
    }

    public static long append8bit(long address, byte[] bytes) {
        int i;
        int len = bytes.length;
        for (i = 0; i < len - 7; i += 8) {
            UnsafeMemory.MEMORY.writeLong(address + (long)i, UnsafeMemory.UNSAFE.getLong(bytes, ARRAY_BYTE_BASE_OFFSET + (long)i));
        }
        while (i < len) {
            UnsafeMemory.MEMORY.writeByte(address + (long)i, UnsafeMemory.UNSAFE.getByte(bytes, ARRAY_BYTE_BASE_OFFSET + (long)i));
            ++i;
        }
        return address + (long)len;
    }

    public static long append8bit(long address, char[] chars) {
        int len = chars.length;
        for (int i = 0; i < len; ++i) {
            UnsafeMemory.MEMORY.writeByte(address + (long)i, (byte)chars[i]);
        }
        return address + (long)len;
    }
}

