/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.onoes;

import net.openhft.chronicle.core.onoes.Slf4jExceptionHandler;
import net.openhft.chronicle.core.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@FunctionalInterface
public interface ExceptionHandler {
    default public void on(@NotNull Class<?> clazz, @NotNull Throwable thrown) {
        this.on(clazz, "", thrown);
    }

    default public void on(@NotNull Class<?> clazz, @NotNull String message) {
        this.on(clazz, message, null);
    }

    default public void on(@NotNull Class<?> clazz, @Nullable String message, @Nullable Throwable thrown) {
        try {
            this.on(LoggerFactory.getLogger(clazz), message, thrown);
        }
        catch (Throwable t) {
            try {
                Slf4jExceptionHandler.ERROR.on(clazz, "unable to handle the exception so logging to SLF", t);
                Slf4jExceptionHandler.ERROR.on(clazz, message, thrown);
            }
            catch (Throwable t0) {
                t0.printStackTrace();
            }
        }
    }

    public void on(@NotNull Logger var1, @Nullable String var2, @Nullable Throwable var3);

    default public void on(@NotNull Logger logger, @Nullable String message) {
        this.on(logger, message, null);
    }

    default public boolean isEnabled(@NotNull Class<?> aClass) {
        ObjectUtils.requireNonNull(aClass);
        return true;
    }
}

