/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.io;

import java.util.Set;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.StackTrace;
import net.openhft.chronicle.core.internal.ReferenceCountedUtils;
import net.openhft.chronicle.core.io.BackgroundResourceReleaser;
import net.openhft.chronicle.core.io.ClosedIllegalStateException;
import net.openhft.chronicle.core.io.IOTools;
import net.openhft.chronicle.core.io.MonitorReferenceCounted;
import net.openhft.chronicle.core.io.ReferenceChangeListener;
import net.openhft.chronicle.core.io.ReferenceCounted;
import net.openhft.chronicle.core.io.ReferenceCountedTracer;
import net.openhft.chronicle.core.io.ReferenceOwner;
import net.openhft.chronicle.core.io.SingleThreadedChecked;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractReferenceCounted
implements ReferenceCountedTracer,
ReferenceOwner,
SingleThreadedChecked {
    protected static final long WARN_NS = (long)(Jvm.getDouble("reference.warn.secs", 0.003) * 1.0E9);
    protected static final int WARN_COUNT = Jvm.getInteger("reference.warn.count", Integer.MAX_VALUE);
    static volatile Set<AbstractReferenceCounted> referenceCountedSet;
    protected final transient MonitorReferenceCounted referenceCounted;
    private final int referenceId;
    private volatile transient Thread usedByThread;
    private volatile transient StackTrace usedByThreadHere;
    private boolean singleThreadedCheckDisabled;

    protected AbstractReferenceCounted() {
        this(true);
    }

    protected AbstractReferenceCounted(boolean monitored) {
        Runnable performRelease = BackgroundResourceReleaser.BG_RELEASER && this.canReleaseInBackground() ? this::backgroundPerformRelease : this::inThreadPerformRelease;
        this.referenceId = IOTools.counter(this.getClass()).incrementAndGet();
        this.referenceCounted = (MonitorReferenceCounted)ReferenceCountedTracer.onReleased(performRelease, this::referenceName, this.getClass());
        this.referenceCounted.unmonitored(!monitored);
        if (monitored) {
            ReferenceCountedUtils.add(this);
        }
    }

    public static void enableReferenceTracing() {
        ReferenceCountedUtils.enableReferenceTracing();
    }

    public static void disableReferenceTracing() {
        ReferenceCountedUtils.disableReferenceTracing();
    }

    public static void assertReferencesReleased() {
        ReferenceCountedUtils.assertReferencesReleased();
    }

    public static void unmonitor(ReferenceCounted counted) {
        ReferenceCountedUtils.unmonitor(counted);
    }

    @Override
    public int referenceId() {
        return this.referenceId;
    }

    @Override
    public StackTrace createdHere() {
        return this.referenceCounted.createdHere();
    }

    @Override
    public void throwExceptionIfNotReleased() throws IllegalStateException {
        this.referenceCounted.throwExceptionIfNotReleased();
    }

    protected void backgroundPerformRelease() {
        BackgroundResourceReleaser.release(this);
    }

    void inThreadPerformRelease() {
        try {
            this.performRelease();
        }
        catch (Exception e) {
            Jvm.warn().on(this.getClass(), e);
        }
    }

    protected boolean canReleaseInBackground() {
        return false;
    }

    protected abstract void performRelease() throws IllegalStateException;

    @Override
    public void reserve(ReferenceOwner id) throws IllegalStateException {
        if (WARN_COUNT < Integer.MAX_VALUE && this.referenceCounted.refCount() >= WARN_COUNT && (this.referenceCounted.refCount() - WARN_COUNT) % 10 == 0) {
            Jvm.warn().on(this.getClass(), "high reserve count for " + this.referenceName() + " was " + this.referenceCounted.refCount(), (Throwable)new StackTrace("reserved here"));
        }
        this.referenceCounted.reserve(id);
    }

    @Override
    public void release(ReferenceOwner id) throws IllegalStateException {
        this.referenceCounted.release(id);
    }

    @Override
    public void releaseLast(ReferenceOwner id) throws IllegalStateException {
        this.referenceCounted.releaseLast(id);
    }

    @Override
    public boolean tryReserve(ReferenceOwner id) throws IllegalStateException, IllegalArgumentException {
        return this.referenceCounted.tryReserve(id);
    }

    @Override
    public void reserveTransfer(ReferenceOwner from, ReferenceOwner to) throws IllegalStateException {
        this.referenceCounted.reserveTransfer(from, to);
    }

    @Override
    public int refCount() {
        return this.referenceCounted.refCount();
    }

    @Override
    public void throwExceptionIfReleased() throws ClosedIllegalStateException {
        this.referenceCounted.throwExceptionIfReleased();
    }

    @Override
    public void warnAndReleaseIfNotReleased() throws ClosedIllegalStateException {
        this.referenceCounted.warnAndReleaseIfNotReleased();
    }

    @Override
    @Deprecated
    public boolean reservedBy(ReferenceOwner owner) throws IllegalStateException {
        return this.referenceCounted.reservedBy(owner);
    }

    @Override
    public void singleThreadedCheckDisabled(boolean singleThreadedCheckDisabled) {
        this.singleThreadedCheckDisabled = singleThreadedCheckDisabled;
    }

    @Override
    public void addReferenceChangeListener(ReferenceChangeListener referenceChangeListener) {
        this.referenceCounted.addReferenceChangeListener(referenceChangeListener);
    }

    @Override
    public void removeReferenceChangeListener(ReferenceChangeListener referenceChangeListener) {
        this.referenceCounted.removeReferenceChangeListener(referenceChangeListener);
    }

    protected boolean threadSafetyCheck(boolean isUsed) throws IllegalStateException {
        if (DISABLE_SINGLE_THREADED_CHECK || this.singleThreadedCheckDisabled) {
            return true;
        }
        return this.threadSafetyCheck0(isUsed);
    }

    private boolean threadSafetyCheck0(boolean isUsed) {
        if (this.usedByThread == null && !isUsed) {
            return true;
        }
        Thread currentThread = Thread.currentThread();
        if (this.usedByThread == currentThread) {
            return true;
        }
        return this.threadSafetyCheck2(currentThread);
    }

    private boolean threadSafetyCheck2(Thread currentThread) {
        if (this.usedByThread == null || !this.usedByThread.isAlive()) {
            this.usedByThread = currentThread;
            this.usedByThreadHere = new StackTrace("Used here");
            return true;
        }
        String message = this.getClass().getName() + " component which is not thread safe used by " + this.usedByThread + " and " + currentThread;
        throw new IllegalStateException(message, this.usedByThreadHere);
    }

    @Override
    public void singleThreadedCheckReset() {
        this.usedByThread = null;
    }

    @Deprecated
    public void clearUsedByThread() {
        this.usedByThread = null;
    }

    @NotNull
    public String toString() {
        return this.referenceName();
    }

    public void referenceCountedUnmonitored(boolean unmonitored) {
        this.referenceCounted.unmonitored(unmonitored);
    }
}

