/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.io;

import net.openhft.chronicle.core.io.InvalidMarshallableException;
import net.openhft.chronicle.core.io.Validatable;

public class ValidatableUtil {
    static final ThreadLocal<int[]> VALIDATE_DISABLED = ThreadLocal.withInitial(() -> new int[1]);

    public static void startValidateDisabled() {
        int[] nArray = VALIDATE_DISABLED.get();
        nArray[0] = nArray[0] + 1;
    }

    public static void endValidateDisabled() {
        int[] val = VALIDATE_DISABLED.get();
        assert (val[0] > 0);
        val[0] = val[0] - 1;
    }

    public static <T> T validate(T t) throws InvalidMarshallableException {
        if (t instanceof Validatable && VALIDATE_DISABLED.get()[0] <= 0) {
            ((Validatable)t).validate();
        }
        return t;
    }

    public static void requireNonNull(Object tested, String name) throws InvalidMarshallableException {
        if (tested == null) {
            throw new InvalidMarshallableException(name + " must not be null");
        }
    }

    public static void requireTrue(boolean test, String msg) throws InvalidMarshallableException {
        if (!test) {
            throw new InvalidMarshallableException(msg);
        }
    }
}

