/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import net.openhft.chronicle.core.Jvm;

final class Bootstrap {
    public static final String OS_ARCH = System.getProperty("os.arch", "?");
    public static final String VM_VENDOR = System.getProperty("java.vm.vendor", "?");
    public static final String VM_VERSION = System.getProperty("java.vm.version", "?");
    public static final String VM_NAME = System.getProperty("java.vm.name", "?");
    static final int JVM_JAVA_MAJOR_VERSION = Bootstrap.getMajorVersion0();
    static final boolean IS_JAVA_9_PLUS = JVM_JAVA_MAJOR_VERSION > 8;
    static final boolean IS_JAVA_12_PLUS = JVM_JAVA_MAJOR_VERSION > 11;
    static final boolean IS_JAVA_14_PLUS = JVM_JAVA_MAJOR_VERSION > 13;
    static final boolean IS_JAVA_15_PLUS = JVM_JAVA_MAJOR_VERSION > 14;

    private Bootstrap() {
    }

    static boolean isArm0() {
        return Boolean.parseBoolean(System.getProperty("jvm.isarm")) || OS_ARCH.startsWith("arm") || OS_ARCH.startsWith("aarch");
    }

    static boolean isMacArm0() {
        return System.getProperty("os.name", "?").equals("Mac OS X") && OS_ARCH.equals("aarch64");
    }

    static boolean isAzulZing0() {
        return VM_VENDOR.startsWith("Azul ") && VM_VERSION.contains("zing");
    }

    static boolean isAzulZulu0() {
        return VM_VENDOR.startsWith("Azul ") && (VM_NAME.startsWith("OpenJDK ") || VM_NAME.startsWith("Zulu"));
    }

    private static int getMajorVersion0() {
        try {
            Method method = Runtime.class.getDeclaredMethod("version", new Class[0]);
            if (method != null) {
                Object version = method.invoke((Object)Runtime.getRuntime(), new Object[0]);
                Class<?> clz = Class.forName("java.lang.Runtime$Version");
                return (Integer)clz.getDeclaredMethod("major", new Class[0]).invoke(version, new Object[0]);
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchMethodException | InvocationTargetException method) {
            // empty catch block
        }
        try {
            return Integer.parseInt(Runtime.class.getPackage().getSpecificationVersion().split("\\.")[1]);
        }
        catch (NumberFormatException nfe) {
            Jvm.warn().on(Jvm.class, "Unable to get the major version, defaulting to 8 " + nfe);
            return 8;
        }
    }
}

