/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.annotation.Annotation;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.management.ManagementFactory;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.LockSupport;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.openhft.chronicle.core.Bootstrap;
import net.openhft.chronicle.core.ChronicleInit;
import net.openhft.chronicle.core.ClassMetrics;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.core.PerformanceTuning;
import net.openhft.chronicle.core.UnsafeMemory;
import net.openhft.chronicle.core.annotation.DontChain;
import net.openhft.chronicle.core.internal.util.DirectBufferUtil;
import net.openhft.chronicle.core.internal.util.MapUtil;
import net.openhft.chronicle.core.onoes.ChainedExceptionHandler;
import net.openhft.chronicle.core.onoes.ExceptionHandler;
import net.openhft.chronicle.core.onoes.ExceptionKey;
import net.openhft.chronicle.core.onoes.LogLevel;
import net.openhft.chronicle.core.onoes.NullExceptionHandler;
import net.openhft.chronicle.core.onoes.RecordingExceptionHandler;
import net.openhft.chronicle.core.onoes.Slf4jExceptionHandler;
import net.openhft.chronicle.core.onoes.ThreadLocalisedExceptionHandler;
import net.openhft.chronicle.core.util.ObjectUtils;
import net.openhft.chronicle.core.util.ThrowingSupplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.misc.Signal;
import sun.misc.Unsafe;

public final class Jvm {
    public static final String JAVA_CLASS_PATH = "java.class.path";
    public static final String SYSTEM_PROPERTIES = "system.properties";
    private static final ExceptionHandler DEFAULT_ERROR_EXCEPTION_HANDLER;
    private static final ExceptionHandler DEFAULT_WARN_EXCEPTION_HANDLER;
    private static final ExceptionHandler DEFAULT_PERF_EXCEPTION_HANDLER;
    private static final ExceptionHandler DEFAULT_DEBUG_EXCEPTION_HANDLER;
    private static final String PROC = "/proc";
    private static final String PROC_SELF = "/proc/self";
    private static final List<String> INPUT_ARGUMENTS;
    private static final String INPUT_ARGUMENTS2;
    private static final boolean IS_DEBUG;
    private static final boolean IS_FLIGHT_RECORDER;
    private static final boolean IS_COVERAGE;
    private static final int COMPILE_THRESHOLD;
    private static final boolean REPORT_UNOPTIMISED;
    private static final Supplier<Long> reservedMemory;
    private static final boolean IS_64BIT;
    private static final int PROCESS_ID;
    private static final boolean IS_AZUL_ZING;
    private static final boolean IS_AZUL_ZULU;
    @NotNull
    private static final ThreadLocalisedExceptionHandler ERROR;
    @NotNull
    private static final ThreadLocalisedExceptionHandler WARN;
    @NotNull
    private static final ThreadLocalisedExceptionHandler PERF;
    @NotNull
    private static final ThreadLocalisedExceptionHandler DEBUG;
    private static final long MAX_DIRECT_MEMORY;
    private static final boolean SAFEPOINT_ENABLED;
    private static final boolean IS_ARM;
    private static final boolean IS_MAC_ARM;
    private static final Map<Class<?>, ClassMetrics> CLASS_METRICS_MAP;
    private static final Map<Class<?>, Integer> PRIMITIVE_SIZE;
    private static final MethodHandle setAccessible0_Method;
    private static final MethodHandle onSpinWaitMH;
    private static final ChainedSignalHandler signalHandlerGlobal;
    private static final boolean RESOURCE_TRACING;
    private static final boolean PROC_EXISTS;
    private static final int OBJECT_HEADER_SIZE;
    private static final boolean ASSERT_ENABLED;

    private Jvm() {
    }

    public static void reportUnoptimised() {
        if (!REPORT_UNOPTIMISED) {
            return;
        }
        StackTraceElement[] stes = Thread.currentThread().getStackTrace();
        int i = 0;
        while (i < stes.length && !stes[i++].getMethodName().equals("reportUnoptimised")) {
        }
        while (i < stes.length && !stes[i++].getMethodName().equals("<clinit>")) {
        }
        Jvm.warn().on(Jvm.class, "Reporting usage of unoptimised method " + stes[i]);
    }

    private static void findAndLoadSystemProperties() {
        String systemProperties = Jvm.getProperty(SYSTEM_PROPERTIES);
        boolean wasSet = true;
        if (systemProperties == null) {
            if (new File(SYSTEM_PROPERTIES).exists()) {
                systemProperties = SYSTEM_PROPERTIES;
            } else if (new File("../system.properties").exists()) {
                systemProperties = "../system.properties";
            } else {
                systemProperties = SYSTEM_PROPERTIES;
                wasSet = false;
            }
        }
        Jvm.loadSystemProperties(systemProperties, wasSet);
    }

    private static MethodHandle getSetAccessible0Method() {
        if (!Bootstrap.IS_JAVA_9_PLUS) {
            return null;
        }
        MethodType signature = MethodType.methodType(Boolean.TYPE, Boolean.TYPE);
        try {
            Method privateLookupIn = MethodHandles.class.getDeclaredMethod("privateLookupIn", Class.class, MethodHandles.Lookup.class);
            MethodHandles.Lookup lookup = (MethodHandles.Lookup)privateLookupIn.invoke(null, AccessibleObject.class, MethodHandles.lookup());
            return lookup.findVirtual(AccessibleObject.class, "setAccessible0", signature);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | InvocationTargetException e) {
            throw new ExceptionInInitializerError(e);
        }
    }

    public static void init() {
        ChronicleInit.init();
    }

    private static void loadSystemProperties(String name, boolean wasSet) {
        try {
            File file;
            InputStream is0;
            ClassLoader classLoader = Jvm.class.getClassLoader();
            InputStream inputStream = is0 = classLoader == null ? null : classLoader.getResourceAsStream(name);
            if (is0 == null && (file = new File(name)).exists()) {
                is0 = new FileInputStream(file);
            }
            try (InputStream is = is0;){
                if (is == null) {
                    (wasSet ? Slf4jExceptionHandler.WARN : Slf4jExceptionHandler.DEBUG).on(Jvm.class, "No " + name + " file found");
                } else {
                    Properties prop = new Properties();
                    prop.load(is);
                    prop.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(o, o2) -> System.getProperties().putIfAbsent(o, o2)));
                    Slf4jExceptionHandler.DEBUG.on(Jvm.class, "Loaded " + name + " with " + prop);
                }
            }
        }
        catch (Exception e) {
            Slf4jExceptionHandler.WARN.on(Jvm.class, "Error loading " + name, e);
        }
    }

    private static int getCompileThreshold0() {
        for (String inputArgument : INPUT_ARGUMENTS) {
            String prefix = "-XX:CompileThreshold=";
            if (!inputArgument.startsWith("-XX:CompileThreshold=")) continue;
            try {
                return Integer.parseInt(inputArgument.substring("-XX:CompileThreshold=".length()));
            }
            catch (NumberFormatException numberFormatException) {
            }
        }
        return 10000;
    }

    public static int compileThreshold() {
        return COMPILE_THRESHOLD;
    }

    public static int majorVersion() {
        return Bootstrap.JVM_JAVA_MAJOR_VERSION;
    }

    public static boolean isJava9Plus() {
        return Bootstrap.IS_JAVA_9_PLUS;
    }

    public static boolean isJava12Plus() {
        return Bootstrap.IS_JAVA_12_PLUS;
    }

    public static boolean isJava14Plus() {
        return Bootstrap.IS_JAVA_14_PLUS;
    }

    public static boolean isJava15Plus() {
        return Bootstrap.IS_JAVA_15_PLUS;
    }

    private static boolean is64bit0() {
        String systemProp = Jvm.getProperty("com.ibm.vm.bitmode");
        if (systemProp != null) {
            return "64".equals(systemProp);
        }
        systemProp = Jvm.getProperty("sun.arch.data.model");
        if (systemProp != null) {
            return "64".equals(systemProp);
        }
        systemProp = System.getProperty("java.vm.version");
        return systemProp != null && systemProp.contains("_64");
    }

    public static int getProcessId() {
        return PROCESS_ID;
    }

    private static int getProcessId0() {
        String pid = null;
        File self = new File(PROC_SELF);
        try {
            if (self.exists()) {
                pid = self.getCanonicalFile().getName();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (pid == null) {
            pid = ManagementFactory.getRuntimeMXBean().getName().split("@", 0)[0];
        }
        if (pid != null) {
            try {
                return Integer.parseInt(pid);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        int rpid = 1;
        System.err.println(Jvm.class.getName() + ": Unable to determine PID, picked 1 as a PID");
        return rpid;
    }

    @NotNull
    public static <T extends Throwable> RuntimeException rethrow(Throwable throwable) throws T {
        throw throwable;
    }

    public static void trimStackTrace(@NotNull StringBuilder stringBuilder, StackTraceElement ... stackTraceElements) {
        int first = Jvm.trimFirst(stackTraceElements);
        int last = Jvm.trimLast(first, stackTraceElements);
        for (int i = first; i <= last; ++i) {
            stringBuilder.append("\n\tat ").append(stackTraceElements[i]);
        }
    }

    static int trimFirst(@NotNull StackTraceElement[] stes) {
        int first;
        if (stes.length > 2 && stes[1].getMethodName().endsWith("afepoint")) {
            return 2;
        }
        for (first = 0; first < stes.length && Jvm.isInternal(stes[first].getClassName()); ++first) {
        }
        return Math.max(0, first - 2);
    }

    public static int trimLast(int first, @NotNull StackTraceElement[] stes) {
        int last;
        for (last = stes.length - 1; first < last && Jvm.isInternal(stes[last].getClassName()); --last) {
        }
        if (last < stes.length - 1) {
            ++last;
        }
        return last;
    }

    static boolean isInternal(@NotNull String className) {
        return className.startsWith("jdk.") || className.startsWith("sun.") || className.startsWith("java.");
    }

    public static boolean isDebug() {
        return IS_DEBUG;
    }

    public static boolean isFlightRecorder() {
        return IS_FLIGHT_RECORDER;
    }

    public static boolean isCodeCoverage() {
        return IS_COVERAGE;
    }

    public static void pause(long durationMs) {
        if (durationMs <= 0L) {
            Thread.yield();
            return;
        }
        try {
            Thread.sleep(durationMs);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public static void nanoPause() {
        if (onSpinWaitMH == null) {
            if (Bootstrap.IS_JAVA_9_PLUS) {
                Safepoint.force();
            } else {
                Compiler.enable();
            }
        } else {
            try {
                onSpinWaitMH.invokeExact();
            }
            catch (Throwable throwable) {
                throw new AssertionError((Object)throwable);
            }
        }
    }

    public static void busyWaitMicros(long durationUs) {
        Jvm.busyWaitUntil(System.nanoTime() + durationUs * 1000L);
    }

    public static void busyWaitUntil(long waitUntilNs) {
        while (waitUntilNs > System.nanoTime()) {
            Jvm.nanoPause();
        }
    }

    @NotNull
    public static Field getField(@NotNull Class<?> clazz, @NotNull String fieldName) {
        return Jvm.getField0(clazz, fieldName, true);
    }

    static Field getField0(@NotNull Class<?> clazz, @NotNull String name, boolean error) {
        try {
            Field field = clazz.getDeclaredField(name);
            Jvm.setAccessible(field);
            return field;
        }
        catch (NoSuchFieldException e) {
            Field field;
            Class<?> superclass = clazz.getSuperclass();
            if (superclass != null && (field = Jvm.getField0(superclass, name, false)) != null) {
                return field;
            }
            if (error) {
                throw new AssertionError((Object)e);
            }
            return null;
        }
    }

    @Nullable
    public static Field getFieldOrNull(@NotNull Class<?> clazz, @NotNull String fieldName) {
        return Jvm.getField0(clazz, fieldName, false);
    }

    @NotNull
    public static Method getMethod(@NotNull Class<?> clazz, @NotNull String methodName, Class ... argTypes) {
        return Jvm.getMethod0(clazz, methodName, argTypes, true);
    }

    private static Method getMethod0(@NotNull Class<?> clazz, @NotNull String name, Class[] args, boolean first) {
        try {
            Method method = clazz.getDeclaredMethod(name, args);
            if (!Modifier.isPublic(method.getModifiers()) || !Modifier.isPublic(method.getDeclaringClass().getModifiers())) {
                Jvm.setAccessible(method);
            }
            return method;
        }
        catch (NoSuchMethodException e) {
            Class<?> superclass = clazz.getSuperclass();
            if (superclass != null) {
                try {
                    Method m = Jvm.getMethod0(superclass, name, args, false);
                    if (m != null) {
                        return m;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (first) {
                throw new AssertionError((Object)e);
            }
            return null;
        }
    }

    public static void setAccessible(@NotNull AccessibleObject accessibleObject) {
        block4: {
            if (Bootstrap.IS_JAVA_9_PLUS) {
                try {
                    boolean newFlag = setAccessible0_Method.invokeExact(accessibleObject, true);
                    assert (newFlag);
                    break block4;
                }
                catch (Throwable throwable) {
                    throw Jvm.rethrow(throwable);
                }
            }
            accessibleObject.setAccessible(true);
        }
    }

    @Nullable
    public static <V> V getValue(@NotNull Object target, @NotNull String fieldName) {
        Class<?> aClass = target.getClass();
        for (String n : fieldName.split("/")) {
            Field f = Jvm.getField(aClass, n);
            try {
                target = f.get(target);
                if (target == null) {
                    return null;
                }
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                throw new AssertionError((Object)e);
            }
            aClass = target.getClass();
        }
        return (V)target;
    }

    public static String lockWithStack(@NotNull ReentrantLock lock) {
        Thread t = (Thread)Jvm.getValue(lock, "sync/exclusiveOwnerThread");
        if (t == null) {
            return lock.toString();
        }
        StringBuilder ret = new StringBuilder();
        ret.append(lock).append(" running at");
        Jvm.trimStackTrace(ret, t.getStackTrace());
        return ret.toString();
    }

    public static long fieldOffset(Class<?> clazz, String fieldName) {
        try {
            return UnsafeMemory.UNSAFE.objectFieldOffset(clazz.getDeclaredField(fieldName));
        }
        catch (NoSuchFieldException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static long usedDirectMemory() {
        return reservedMemory.get();
    }

    public static long usedNativeMemory() {
        return UnsafeMemory.INSTANCE.nativeMemoryUsed();
    }

    public static long maxDirectMemory() {
        return MAX_DIRECT_MEMORY;
    }

    public static boolean is64bit() {
        return IS_64BIT;
    }

    public static void resetExceptionHandlers() {
        Jvm.setErrorExceptionHandler(DEFAULT_ERROR_EXCEPTION_HANDLER);
        Jvm.setWarnExceptionHandler(DEFAULT_WARN_EXCEPTION_HANDLER);
        Jvm.setDebugExceptionHandler(DEFAULT_DEBUG_EXCEPTION_HANDLER);
        Jvm.setPerfExceptionHandler(DEFAULT_PERF_EXCEPTION_HANDLER);
    }

    public static void setErrorExceptionHandler(ExceptionHandler exceptionHandler) {
        ERROR.defaultHandler(exceptionHandler).resetThreadLocalHandler();
    }

    public static void setWarnExceptionHandler(ExceptionHandler exceptionHandler) {
        WARN.defaultHandler(exceptionHandler).resetThreadLocalHandler();
    }

    public static void setDebugExceptionHandler(ExceptionHandler exceptionHandler) {
        DEBUG.defaultHandler(exceptionHandler).resetThreadLocalHandler();
    }

    public static void setPerfExceptionHandler(ExceptionHandler exceptionHandler) {
        PERF.defaultHandler(exceptionHandler).resetThreadLocalHandler();
    }

    public static void disableDebugHandler() {
        Jvm.setDebugExceptionHandler(null);
    }

    public static void disablePerfHandler() {
        Jvm.setPerfExceptionHandler(null);
    }

    public static void disableWarnHandler() {
        Jvm.setWarnExceptionHandler(null);
    }

    @NotNull
    public static Map<ExceptionKey, Integer> recordExceptions() {
        return Jvm.recordExceptions(true);
    }

    @NotNull
    public static Map<ExceptionKey, Integer> recordExceptions(boolean debug) {
        return Jvm.recordExceptions(debug, false);
    }

    @NotNull
    public static Map<ExceptionKey, Integer> recordExceptions(boolean debug, boolean exceptionsOnly) {
        return Jvm.recordExceptions(debug, exceptionsOnly, true);
    }

    @NotNull
    public static Map<ExceptionKey, Integer> recordExceptions(boolean debug, boolean exceptionsOnly, boolean logToSlf4j) {
        Map<ExceptionKey, Integer> map = Collections.synchronizedMap(new LinkedHashMap());
        Jvm.setErrorExceptionHandler(Jvm.recordingExceptionHandler(LogLevel.ERROR, map, exceptionsOnly, logToSlf4j));
        Jvm.setWarnExceptionHandler(Jvm.recordingExceptionHandler(LogLevel.WARN, map, exceptionsOnly, logToSlf4j));
        Jvm.setPerfExceptionHandler((ExceptionHandler)(debug ? Jvm.recordingExceptionHandler(LogLevel.PERF, map, exceptionsOnly, logToSlf4j) : (logToSlf4j ? Slf4jExceptionHandler.PERF : NullExceptionHandler.NOTHING)));
        Jvm.setDebugExceptionHandler((ExceptionHandler)(debug ? Jvm.recordingExceptionHandler(LogLevel.DEBUG, map, exceptionsOnly, logToSlf4j) : (logToSlf4j ? Slf4jExceptionHandler.DEBUG : NullExceptionHandler.NOTHING)));
        return map;
    }

    private static ExceptionHandler recordingExceptionHandler(LogLevel logLevel, Map<ExceptionKey, Integer> map, boolean exceptionsOnly, boolean logToSlf4j) {
        RecordingExceptionHandler eh = new RecordingExceptionHandler(logLevel, map, exceptionsOnly);
        if (logToSlf4j) {
            return new ChainedExceptionHandler(eh, Slf4jExceptionHandler.valueOf(logLevel));
        }
        return eh;
    }

    public static boolean hasException(@NotNull Map<ExceptionKey, Integer> exceptions) {
        for (ExceptionKey k : exceptions.keySet()) {
            if (k.level() == LogLevel.DEBUG || k.level() == LogLevel.PERF) continue;
            return true;
        }
        return false;
    }

    public static void setExceptionHandlers(@Nullable ExceptionHandler error, @Nullable ExceptionHandler warn, @Nullable ExceptionHandler debug) {
        ERROR.defaultHandler(error);
        WARN.defaultHandler(warn);
        DEBUG.defaultHandler(debug);
    }

    public static void setExceptionHandlers(@Nullable ExceptionHandler error, @Nullable ExceptionHandler warn, @Nullable ExceptionHandler debug, @Nullable ExceptionHandler perf) {
        Jvm.setExceptionHandlers(error, warn, debug);
        PERF.defaultHandler(perf);
    }

    public static void setThreadLocalExceptionHandlers(@Nullable ExceptionHandler error, @Nullable ExceptionHandler warn, @Nullable ExceptionHandler debug) {
        ERROR.threadLocalHandler(error);
        WARN.threadLocalHandler(warn);
        DEBUG.threadLocalHandler(debug);
    }

    public static void setThreadLocalExceptionHandlers(@Nullable ExceptionHandler error, @Nullable ExceptionHandler warn, @Nullable ExceptionHandler debug, @Nullable ExceptionHandler perf) {
        Jvm.setThreadLocalExceptionHandlers(error, warn, debug);
        PERF.threadLocalHandler(perf);
    }

    @NotNull
    public static ExceptionHandler error() {
        return ERROR;
    }

    @NotNull
    public static ExceptionHandler warn() {
        return WARN;
    }

    @NotNull
    public static ExceptionHandler startup() {
        return PERF;
    }

    @NotNull
    public static ExceptionHandler perf() {
        return PERF;
    }

    @NotNull
    public static ExceptionHandler debug() {
        return DEBUG;
    }

    public static void dumpException(@NotNull Map<ExceptionKey, Integer> exceptions) {
        Slf4jExceptionHandler warn = Slf4jExceptionHandler.WARN;
        for (Map.Entry<ExceptionKey, Integer> entry : exceptions.entrySet()) {
            ExceptionKey key = entry.getKey();
            warn.on(Jvm.class, (Object)((Object)key.level()) + " " + key.clazz().getSimpleName() + " " + key.message(), key.throwable());
            Integer value = entry.getValue();
            if (value <= 1) continue;
            warn.on(Jvm.class, "Repeated " + value + " times");
        }
        Jvm.resetExceptionHandlers();
    }

    public static boolean isDebugEnabled(Class<?> aClass) {
        return DEBUG.isEnabled(aClass);
    }

    public static boolean isPerfEnabled(Class<?> aClass) {
        return PERF.isEnabled(aClass);
    }

    private static long maxDirectMemory0() {
        try {
            Class<?> clz = Bootstrap.IS_JAVA_9_PLUS ? Class.forName("jdk.internal.misc.VM") : Class.forName("sun.misc.VM");
            Field f = Jvm.getField(clz, "directMemory");
            return f.getLong(null);
        }
        catch (Exception exception) {
            System.err.println(Jvm.class.getName() + ": Unable to determine max direct memory");
            return 0L;
        }
    }

    public static void addSignalHandler(SignalHandler signalHandler) {
        SignalHandler signalHandler2 = signal -> {
            Jvm.warn().on(signalHandler.getClass(), "Signal " + signal + " triggered for " + signalHandler);
            signalHandler.handle(signal);
        };
        Jvm.signalHandlerGlobal.handlers2.add(signalHandler2);
        InitSignalHandlers.init();
    }

    public static void safepoint() {
        if (SAFEPOINT_ENABLED) {
            if (Bootstrap.IS_JAVA_9_PLUS) {
                Safepoint.force();
            } else {
                Compiler.enable();
            }
        }
    }

    public static boolean areOptionalSafepointsEnabled() {
        return SAFEPOINT_ENABLED;
    }

    public static boolean stackTraceEndsWith(String endsWith, int maxDepth) {
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        for (int i = maxDepth + 2; i < stackTrace.length; ++i) {
            if (!stackTrace[i].getClassName().endsWith(endsWith)) continue;
            return true;
        }
        return false;
    }

    public static boolean isArm() {
        return IS_ARM;
    }

    public static boolean isMacArm() {
        return IS_MAC_ARM;
    }

    @NotNull
    public static ClassMetrics classMetrics(Class<?> clazz) throws IllegalArgumentException {
        return CLASS_METRICS_MAP.computeIfAbsent(clazz, Jvm::getClassMetrics);
    }

    private static ClassMetrics getClassMetrics(Class<?> c) {
        Class<?> superclass = c.getSuperclass();
        int start = Integer.MAX_VALUE;
        int end = 0;
        for (Field f : c.getDeclaredFields()) {
            if ((f.getModifiers() & 0x88) != 0 || !f.getType().isPrimitive()) continue;
            int start0 = Math.toIntExact(UnsafeMemory.unsafeObjectFieldOffset(f));
            int size = PRIMITIVE_SIZE.get(f.getType());
            start = Math.min(start0, start);
            end = Math.max(start0 + size, end);
        }
        if (superclass != null && superclass != Object.class) {
            ClassMetrics cm0 = Jvm.getClassMetrics(superclass);
            start = Math.min(cm0.offset(), start);
            end = Math.max(cm0.offset() + cm0.length(), end);
            Jvm.validateClassMetrics(superclass, start, end);
        }
        Jvm.validateClassMetrics(c, start, end);
        return new ClassMetrics(start, end - start);
    }

    private static void validateClassMetrics(Class<?> c, int start, int end) {
        for (Field f : c.getDeclaredFields()) {
            int start0;
            if ((f.getModifiers() & 8) != 0 || f.getType().isPrimitive() || start > (start0 = Math.toIntExact(UnsafeMemory.unsafeObjectFieldOffset(f))) || start0 >= end) continue;
            Jvm.rethrow(new IllegalArgumentException(c + " is not suitable for raw copies due to " + f));
        }
    }

    @NotNull
    public static String userHome() {
        return System.getProperty("user.home", ".");
    }

    public static boolean dontChain(Class<?> tClass) {
        return tClass.getAnnotation(DontChain.class) != null || tClass.getName().startsWith("java");
    }

    public static boolean isResourceTracing() {
        return RESOURCE_TRACING;
    }

    public static String getProperty(String systemPropertyKey) {
        Jvm.init();
        return System.getProperty(systemPropertyKey);
    }

    public static String getProperty(String systemPropertyKey, String defaultValue) {
        Jvm.init();
        return System.getProperty(systemPropertyKey, defaultValue);
    }

    public static Long getLong(String systemPropertyKey, Long defVal) {
        Jvm.init();
        return Long.getLong(systemPropertyKey, defVal);
    }

    public static Integer getInteger(String systemPropertyKey, Integer defVal) {
        Jvm.init();
        return Integer.getInteger(systemPropertyKey, defVal);
    }

    public static boolean getBoolean(String systemPropertyKey) {
        return Jvm.getBoolean(systemPropertyKey, false);
    }

    public static boolean getBoolean(String systemPropertyKey, boolean defaultValue) {
        String value = Jvm.getProperty(systemPropertyKey);
        if (value == null) {
            return defaultValue;
        }
        if (value.isEmpty()) {
            return true;
        }
        String trim = value.trim();
        return defaultValue ? !ObjectUtils.isFalse(trim) : ObjectUtils.isTrue(trim);
    }

    public static long parseSize(@NotNull String value) throws IllegalArgumentException {
        long factor = 1L;
        if (value.length() > 1) {
            char last = value.charAt(value.length() - 1);
            if (last == 'b' || last == 'B') {
                value = value.substring(0, value.length() - 1);
                last = value.charAt(value.length() - 1);
            }
            if (last == 'i') {
                value = value.substring(0, value.length() - 1);
                last = value.charAt(value.length() - 1);
            }
            if (Character.isLetter(last)) {
                switch (last) {
                    case 'T': 
                    case 't': {
                        factor = 0x10000000000L;
                        break;
                    }
                    case 'G': 
                    case 'g': {
                        factor = 0x40000000L;
                        break;
                    }
                    case 'M': 
                    case 'm': {
                        factor = 0x100000L;
                        break;
                    }
                    case 'K': 
                    case 'k': {
                        factor = 1024L;
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unrecognised suffix for size " + value);
                    }
                }
                value = value.substring(0, value.length() - 1);
            }
        }
        double number = Double.parseDouble(value.trim());
        factor = (long)((double)factor * number);
        return factor;
    }

    public static long getSize(String property, long defaultValue) {
        String value = Jvm.getProperty(property);
        if (value == null || value.length() <= 0) {
            return defaultValue;
        }
        try {
            return Jvm.parseSize(value);
        }
        catch (IllegalArgumentException iae) {
            Jvm.warn().on(Jvm.class, "Unable to parse the property " + property + " as a size " + iae.getMessage() + " using " + defaultValue);
            return defaultValue;
        }
    }

    public static long address(@NotNull ByteBuffer byteBuffer) {
        return DirectBufferUtil.addressOrThrow(byteBuffer);
    }

    public static int arrayByteBaseOffset() {
        return Unsafe.ARRAY_BYTE_BASE_OFFSET;
    }

    public static void doNotCloseOnInterrupt(Class<?> clazz, FileChannel fc) {
        if (Jvm.isJava9Plus()) {
            Jvm.doNotCloseOnInterrupt9(clazz, fc);
        } else {
            Jvm.doNotCloseOnInterrupt8(clazz, fc);
        }
    }

    private static void doNotCloseOnInterrupt8(Class<?> clazz, FileChannel fc) {
        try {
            Field field = AbstractInterruptibleChannel.class.getDeclaredField("interruptor");
            Jvm.setAccessible(field);
            CommonInterruptible ci = new CommonInterruptible(clazz, fc);
            field.set(fc, thread -> ci.interrupt());
        }
        catch (Throwable e) {
            Jvm.warn().on(clazz, "Couldn't disable close on interrupt", e);
        }
    }

    private static void doNotCloseOnInterrupt9(Class<?> clazz, FileChannel fc) {
        try {
            Field field = AbstractInterruptibleChannel.class.getDeclaredField("interruptor");
            Class<?> interruptibleClass = field.getType();
            Jvm.setAccessible(field);
            CommonInterruptible ci = new CommonInterruptible(clazz, fc);
            field.set(fc, Proxy.newProxyInstance(interruptibleClass.getClassLoader(), new Class[]{interruptibleClass}, (p, m, a) -> {
                if (m.getDeclaringClass() != Object.class) {
                    ci.interrupt();
                }
                return ObjectUtils.defaultValue(m.getReturnType());
            }));
        }
        catch (Throwable e) {
            Jvm.warn().on(clazz, "Couldn't disable close on interrupt", e);
        }
    }

    public static void addToClassPath(@NotNull Class<?> clazz) {
        ClassLoader cl = clazz.getClassLoader();
        if (!(cl instanceof URLClassLoader)) {
            return;
        }
        String property = Jvm.getProperty(JAVA_CLASS_PATH);
        LinkedHashSet jcp = new LinkedHashSet();
        Collections.addAll(jcp, property.split(File.pathSeparator));
        jcp.addAll(jcp.stream().map(f -> new File((String)f).getAbsolutePath()).collect(Collectors.toList()));
        URLClassLoader ucl = (URLClassLoader)cl;
        StringBuilder classpath = new StringBuilder(property);
        for (URL url : ucl.getURLs()) {
            try {
                String path = Paths.get(url.toURI()).toString();
                if (jcp.contains(path)) continue;
                if (Jvm.isDebugEnabled(Jvm.class)) {
                    Jvm.debug().on(Jvm.class, "Adding " + path + " to the classpath");
                }
                classpath.append(File.pathSeparator).append(path);
            }
            catch (Throwable e) {
                Jvm.debug().on(Jvm.class, "Could not add URL " + url + " to classpath");
            }
        }
        System.setProperty(JAVA_CLASS_PATH, classpath.toString());
    }

    public static double getDouble(String systemPropertyKey, double defaultValue) {
        String value = Jvm.getProperty(systemPropertyKey);
        if (value != null) {
            try {
                return Double.parseDouble(value);
            }
            catch (NumberFormatException e) {
                Jvm.debug().on(Jvm.class, "Unable to parse property " + systemPropertyKey + " as a double " + e);
            }
        }
        return defaultValue;
    }

    public static boolean isProcessAlive(long pid) {
        if (OS.isWindows()) {
            String command = "cmd /c tasklist /FI \"PID eq " + pid + "\"";
            return Jvm.isProcessAlive0(pid, command);
        }
        if (OS.isLinux() && PROC_EXISTS) {
            return new File("/proc/" + pid).exists();
        }
        if (OS.isMacOSX() || OS.isLinux()) {
            String command = "ps -p " + pid;
            return Jvm.isProcessAlive0(pid, command);
        }
        throw new UnsupportedOperationException("Not supported on this OS");
    }

    private static boolean isProcessAlive0(long pid, String command) {
        try {
            String strLine;
            InputStreamReader isReader = new InputStreamReader(Runtime.getRuntime().exec(command).getInputStream());
            BufferedReader bReader = new BufferedReader(isReader);
            while ((strLine = bReader.readLine()) != null) {
                if (!strLine.contains(" " + pid + " ") && !strLine.startsWith(pid + " ")) continue;
                return true;
            }
            return false;
        }
        catch (Exception ex) {
            return true;
        }
    }

    public static boolean isAzulZing() {
        return IS_AZUL_ZING;
    }

    public static boolean isAzulZulu() {
        return IS_AZUL_ZULU;
    }

    public static int objectHeaderSize() {
        return OBJECT_HEADER_SIZE;
    }

    public static String getCpuClass() {
        return Bootstrap.CpuClass.CPU_MODEL;
    }

    public static boolean isAssertEnabled() {
        return ASSERT_ENABLED;
    }

    public static boolean supportThread() {
        String name = Thread.currentThread().getName();
        return "Finalizer".equals(name) || name.contains("~");
    }

    public static void park() {
        while (!Thread.currentThread().isInterrupted()) {
            LockSupport.park();
        }
    }

    public static <A extends Annotation> A findAnnotation(AnnotatedElement ae, Class<A> annotationType) {
        return Jvm.findAnnotation(ae, annotationType, new HashSet<Annotation>());
    }

    private static <A extends Annotation> A findAnnotation(AnnotatedElement ae, Class<A> annotationType, Set<Annotation> visited) {
        A annotation;
        try {
            Annotation[] anns = ae.getDeclaredAnnotations();
            for (Annotation ann : anns) {
                if (ann.annotationType() != annotationType) continue;
                return (A)ann;
            }
            for (Annotation ann : anns) {
                if (!visited.add(ann) || (annotation = Jvm.findAnnotation(ann.annotationType(), annotationType, visited)) == null) continue;
                return annotation;
            }
        }
        catch (Exception ex) {
            return null;
        }
        if (!(ae instanceof Class)) {
            return null;
        }
        Class clazz = (Class)ae;
        for (Class<?> ifc : clazz.getInterfaces()) {
            annotation = Jvm.findAnnotation(ifc, annotationType, visited);
            if (annotation == null) continue;
            return annotation;
        }
        Class superclass = clazz.getSuperclass();
        if (superclass == null || Object.class == superclass) {
            return null;
        }
        return Jvm.findAnnotation(superclass, annotationType, visited);
    }

    static {
        Supplier<Long> reservedMemoryGetter;
        DEFAULT_ERROR_EXCEPTION_HANDLER = Slf4jExceptionHandler.ERROR;
        DEFAULT_WARN_EXCEPTION_HANDLER = Slf4jExceptionHandler.WARN;
        DEFAULT_PERF_EXCEPTION_HANDLER = Slf4jExceptionHandler.PERF;
        DEFAULT_DEBUG_EXCEPTION_HANDLER = Slf4jExceptionHandler.DEBUG;
        INPUT_ARGUMENTS = ManagementFactory.getRuntimeMXBean().getInputArguments();
        INPUT_ARGUMENTS2 = " " + String.join((CharSequence)" ", INPUT_ARGUMENTS);
        IS_DEBUG = Jvm.getBoolean("debug", INPUT_ARGUMENTS2.contains("jdwp"));
        IS_FLIGHT_RECORDER = Jvm.getBoolean("jfr", INPUT_ARGUMENTS2.contains(" -XX:+FlightRecorder"));
        IS_COVERAGE = INPUT_ARGUMENTS2.contains("coverage");
        COMPILE_THRESHOLD = Jvm.getCompileThreshold0();
        IS_64BIT = Jvm.is64bit0();
        PROCESS_ID = Jvm.getProcessId0();
        IS_AZUL_ZING = Bootstrap.isAzulZing0();
        IS_AZUL_ZULU = Bootstrap.isAzulZulu0();
        ERROR = new ThreadLocalisedExceptionHandler(DEFAULT_ERROR_EXCEPTION_HANDLER);
        WARN = new ThreadLocalisedExceptionHandler(DEFAULT_WARN_EXCEPTION_HANDLER);
        PERF = new ThreadLocalisedExceptionHandler(DEFAULT_PERF_EXCEPTION_HANDLER);
        DEBUG = new ThreadLocalisedExceptionHandler(DEFAULT_DEBUG_EXCEPTION_HANDLER);
        IS_ARM = Bootstrap.isArm0();
        IS_MAC_ARM = Bootstrap.isMacArm0();
        CLASS_METRICS_MAP = new ConcurrentHashMap();
        PRIMITIVE_SIZE = MapUtil.ofUnmodifiable(MapUtil.entry(Boolean.TYPE, 1), MapUtil.entry(Byte.TYPE, 1), MapUtil.entry(Character.TYPE, 2), MapUtil.entry(Short.TYPE, 2), MapUtil.entry(Integer.TYPE, 4), MapUtil.entry(Float.TYPE, 4), MapUtil.entry(Long.TYPE, 8), MapUtil.entry(Double.TYPE, 8));
        PROC_EXISTS = new File(PROC).exists();
        boolean debug = false;
        if (!$assertionsDisabled) {
            debug = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        ASSERT_ENABLED = debug;
        Field[] declaredFields = ObjectHeaderSizeChecker.class.getDeclaredFields();
        setAccessible0_Method = Jvm.getSetAccessible0Method();
        MAX_DIRECT_MEMORY = Jvm.maxDirectMemory0();
        OBJECT_HEADER_SIZE = (int)UnsafeMemory.INSTANCE.getFieldOffset(declaredFields[0]);
        try {
            Field f;
            Class<?> bitsClass = Class.forName("java.nio.Bits");
            Field firstTry = Jvm.getFieldOrNull(bitsClass, "reservedMemory");
            Field field = f = firstTry != null ? firstTry : Jvm.getField(bitsClass, "RESERVED_MEMORY");
            if (f.getType() == AtomicLong.class) {
                AtomicLong reservedMemory = (AtomicLong)f.get(null);
                reservedMemoryGetter = reservedMemory::get;
            } else {
                reservedMemoryGetter = ThrowingSupplier.asSupplier(() -> f.getLong(null));
            }
        }
        catch (Exception e) {
            System.err.println(Jvm.class.getName() + ": Unable to determine the reservedMemory value, will always report 0");
            reservedMemoryGetter = () -> 0L;
        }
        reservedMemory = reservedMemoryGetter;
        signalHandlerGlobal = new ChainedSignalHandler();
        MethodHandle onSpinWait = null;
        if (Bootstrap.IS_JAVA_9_PLUS) {
            try {
                onSpinWait = MethodHandles.lookup().findStatic(Thread.class, "onSpinWait", MethodType.methodType(Void.TYPE));
            }
            catch (Exception firstTry) {
                // empty catch block
            }
        }
        onSpinWaitMH = onSpinWait;
        Jvm.findAndLoadSystemProperties();
        boolean disablePerfInfo = Jvm.getBoolean("disable.perf.info");
        if (disablePerfInfo) {
            PERF.defaultHandler(NullExceptionHandler.NOTHING);
        }
        SAFEPOINT_ENABLED = Jvm.getBoolean("jvm.safepoint.enabled");
        RESOURCE_TRACING = Jvm.getBoolean("jvm.resource.tracing");
        Logger logger = LoggerFactory.getLogger(Jvm.class);
        if (logger.isInfoEnabled()) {
            logger.info("Chronicle core loaded from " + Jvm.class.getProtectionDomain().getCodeSource().getLocation());
        }
        if (RESOURCE_TRACING && !Jvm.getBoolean("disable.resource.warning")) {
            logger.warn("Resource tracing is turned on. If you are performance testing or running in PROD you probably don't want this");
        }
        REPORT_UNOPTIMISED = Jvm.getBoolean("report.unoptimised");
        if (!Jvm.getBoolean("disable.performance.tuning.report")) {
            PerformanceTuning.reportIssues();
        }
    }

    static final class ChainedSignalHandler
    implements sun.misc.SignalHandler {
        final List<sun.misc.SignalHandler> handlers = new CopyOnWriteArrayList<sun.misc.SignalHandler>();
        final List<SignalHandler> handlers2 = new CopyOnWriteArrayList<SignalHandler>();

        ChainedSignalHandler() {
        }

        @Override
        public void handle(Signal signal) {
            for (sun.misc.SignalHandler signalHandler : this.handlers) {
                try {
                    if (signalHandler == null) continue;
                    signalHandler.handle(signal);
                }
                catch (Throwable t) {
                    Jvm.warn().on(this.getClass(), "Problem handling signal", t);
                }
            }
            for (SignalHandler signalHandler : this.handlers2) {
                try {
                    if (signalHandler == null) continue;
                    signalHandler.handle(signal.getName());
                }
                catch (Throwable t) {
                    Jvm.warn().on(this.getClass(), "Problem handling signal", t);
                }
            }
        }
    }

    static final class InitSignalHandlers {
        private InitSignalHandlers() {
        }

        static void init() {
        }

        private static void addSignalHandler(String sig, sun.misc.SignalHandler signalHandler) {
            try {
                Signal.handle(new Signal(sig), signalHandler);
            }
            catch (IllegalArgumentException e) {
                Jvm.warn().on(signalHandler.getClass(), "Unable add a signal handler", e);
            }
        }

        static {
            if (!OS.isWindows()) {
                InitSignalHandlers.addSignalHandler("HUP", signalHandlerGlobal);
            }
            InitSignalHandlers.addSignalHandler("INT", signalHandlerGlobal);
            InitSignalHandlers.addSignalHandler("TERM", signalHandlerGlobal);
        }
    }

    static final class Safepoint {
        private static volatile int one = 1;

        private Safepoint() {
        }

        public static void force() {
            for (int i = 0; i < one; ++i) {
            }
        }
    }

    static final class CommonInterruptible {
        static final ThreadLocal<AtomicBoolean> insideTL = ThreadLocal.withInitial(AtomicBoolean::new);
        private final Class<?> clazz;
        private final FileChannel fc;

        CommonInterruptible(Class<?> clazz, FileChannel fc) {
            this.clazz = clazz;
            this.fc = fc;
        }

        public void interrupt() {
            AtomicBoolean inside = insideTL.get();
            if (inside.get()) {
                return;
            }
            inside.set(true);
            boolean interrupted = Thread.currentThread().isInterrupted();
            if (Jvm.isDebugEnabled(this.getClass())) {
                Jvm.debug().on(this.clazz, this.fc + " not closed on interrupt, interrupted= " + interrupted);
            }
            inside.set(false);
        }
    }

    private static final class ObjectHeaderSizeChecker {
        private int a;

        private ObjectHeaderSizeChecker() {
        }
    }

    public static interface SignalHandler {
        public void handle(String var1);
    }
}

