/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.io;

import java.lang.ref.Reference;
import java.util.Collection;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.io.QueryCloseable;
import org.jetbrains.annotations.Nullable;

public interface Closeable
extends java.io.Closeable,
QueryCloseable {
    public static void closeQuietly(Object ... closeables) {
        if (closeables == null) {
            return;
        }
        for (Object o : closeables) {
            Closeable.closeQuietly(o);
        }
    }

    public static void closeQuietly(@Nullable Object o) {
        if (o instanceof Collection) {
            ((Collection)o).forEach(Closeable::closeQuietly);
        } else if (o instanceof Object[]) {
            for (Object o2 : (Object[])o) {
                Closeable.closeQuietly(o2);
            }
        } else if (o instanceof java.io.Closeable) {
            try {
                ((java.io.Closeable)o).close();
            }
            catch (Exception e) {
                Jvm.debug().on(Closeable.class, e);
            }
            catch (Throwable e) {
                Jvm.warn().on(Closeable.class, e);
            }
        } else if (o instanceof Reference) {
            Closeable.closeQuietly(((Reference)o).get());
        }
    }

    @Override
    public void close();
}

