/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.io;

import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.StackTrace;
import net.openhft.chronicle.core.io.ClosedIllegalStateException;
import net.openhft.chronicle.core.io.MonitorReferenceCounted;
import net.openhft.chronicle.core.io.ReferenceCountedTracer;
import net.openhft.chronicle.core.io.ReferenceOwner;

public class DualReferenceCounted
implements MonitorReferenceCounted {
    private final ReferenceCountedTracer a;
    private final ReferenceCountedTracer b;
    private volatile int refCount;
    private volatile Throwable error;
    private int refCountB;

    public DualReferenceCounted(ReferenceCountedTracer a, ReferenceCountedTracer b) {
        this.a = a;
        this.b = b;
        this.refCount = a.refCount();
    }

    @Override
    public void warnAndReleaseIfNotReleased() throws ClosedIllegalStateException {
        this.a.warnAndReleaseIfNotReleased();
    }

    @Override
    public void throwExceptionIfNotReleased() throws IllegalStateException {
        this.a.throwExceptionIfNotReleased();
    }

    @Override
    public StackTrace createdHere() {
        return this.a.createdHere();
    }

    @Override
    public boolean reservedBy(ReferenceOwner owner) throws IllegalStateException {
        return this.a.reservedBy(owner);
    }

    @Override
    public synchronized void reserve(ReferenceOwner id) throws IllegalStateException {
        this.checkError();
        try {
            this.a.reserve(id);
            this.b.reserve(id);
            this.refCount = this.a.refCount();
            this.refCountB = this.b.refCount();
            if (this.refCount != this.refCountB) {
                throw new AssertionError((Object)(this.refCount + " != " + this.refCountB + " , id= " + id));
            }
        }
        catch (IllegalStateException e) {
            throw e;
        }
        catch (Throwable e) {
            this.error = e;
            throw Jvm.rethrow(this.error);
        }
    }

    private void checkError() {
        int bRefCount;
        if (this.error != null) {
            throw new AssertionError("Unable to use this resource due to previous error", this.error);
        }
        int aRefCount = this.a.refCount();
        if (aRefCount != (bRefCount = this.b.refCount())) {
            this.error = new AssertionError(aRefCount + " != " + bRefCount, this.error);
            throw Jvm.rethrow((Throwable)this.error);
        }
    }

    @Override
    public synchronized boolean tryReserve(ReferenceOwner id) throws IllegalStateException, IllegalArgumentException {
        this.checkError();
        try {
            boolean aa = this.a.tryReserve(id);
            boolean bb = this.b.tryReserve(id);
            assert (aa == bb);
            this.refCount = this.a.refCount();
            this.refCountB = this.b.refCount();
            if (this.refCount != this.refCountB) {
                throw new AssertionError((Object)(this.refCount + " != " + this.refCountB + " , id= " + id));
            }
            return aa;
        }
        catch (IllegalStateException e) {
            throw e;
        }
        catch (Throwable e) {
            this.error = e;
            throw Jvm.rethrow(this.error);
        }
    }

    @Override
    public synchronized void release(ReferenceOwner id) throws IllegalStateException {
        this.checkError();
        try {
            this.a.release(id);
            this.b.release(id);
            this.refCount = this.a.refCount();
            this.refCountB = this.b.refCount();
            if (this.refCount != this.refCountB) {
                throw new AssertionError((Object)(this.refCount + " != " + this.refCountB + " , id= " + id));
            }
        }
        catch (IllegalStateException e) {
            throw e;
        }
        catch (Throwable e) {
            this.error = e;
            throw Jvm.rethrow(this.error);
        }
    }

    @Override
    public synchronized void releaseLast(ReferenceOwner id) throws IllegalStateException {
        this.checkError();
        try {
            this.a.releaseLast(id);
            this.b.releaseLast(id);
            this.refCount = this.a.refCount();
            this.refCountB = this.b.refCount();
            if (this.refCount != this.refCountB) {
                throw new AssertionError((Object)(this.refCount + " != " + this.refCountB + " , id= " + id));
            }
        }
        catch (IllegalStateException e) {
            throw e;
        }
        catch (Throwable e) {
            this.error = e;
            throw Jvm.rethrow(this.error);
        }
    }

    @Override
    public int refCount() {
        return this.refCount;
    }

    @Override
    public synchronized void throwExceptionIfReleased() throws ClosedIllegalStateException {
        this.checkError();
        this.a.throwExceptionIfReleased();
    }

    @Override
    public synchronized void reserveTransfer(ReferenceOwner from, ReferenceOwner to) throws IllegalStateException {
        this.checkError();
        try {
            this.a.reserveTransfer(from, to);
            this.b.reserveTransfer(from, to);
            this.refCount = this.a.refCount();
            this.refCountB = this.b.refCount();
            if (this.refCount != this.refCountB) {
                throw new AssertionError((Object)(this.refCount + " != " + this.refCountB + " , from= " + from + ", to=" + to));
            }
        }
        catch (IllegalStateException e) {
            throw e;
        }
        catch (Throwable e) {
            this.error = e;
            throw Jvm.rethrow(this.error);
        }
    }

    @Override
    public int referenceId() {
        return this.a.referenceId();
    }

    @Override
    public String referenceName() {
        return this.a.referenceName();
    }
}

