/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.management.ManagementFactory;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;
import net.openhft.chronicle.core.ClassMetrics;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.core.StackTrace;
import net.openhft.chronicle.core.UnsafeMemory;
import net.openhft.chronicle.core.annotation.DontChain;
import net.openhft.chronicle.core.onoes.ChainedExceptionHandler;
import net.openhft.chronicle.core.onoes.ExceptionHandler;
import net.openhft.chronicle.core.onoes.ExceptionKey;
import net.openhft.chronicle.core.onoes.LogLevel;
import net.openhft.chronicle.core.onoes.NullExceptionHandler;
import net.openhft.chronicle.core.onoes.RecordingExceptionHandler;
import net.openhft.chronicle.core.onoes.Slf4jExceptionHandler;
import net.openhft.chronicle.core.onoes.ThreadLocalisedExceptionHandler;
import net.openhft.chronicle.core.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sun.misc.Signal;
import sun.misc.SignalHandler;
import sun.misc.Unsafe;
import sun.nio.ch.DirectBuffer;

public final class Jvm
extends Enum<Jvm> {
    private static final List<String> INPUT_ARGUMENTS;
    private static final int COMPILE_THRESHOLD;
    private static final boolean IS_DEBUG;
    private static final boolean IS_FLIGHT_RECORDER;
    private static final Supplier<Long> reservedMemory;
    private static final boolean IS_64BIT;
    private static final int PROCESS_ID;
    @NotNull
    private static final ThreadLocalisedExceptionHandler FATAL;
    @NotNull
    private static final ThreadLocalisedExceptionHandler WARN;
    @NotNull
    private static final ThreadLocalisedExceptionHandler PERF;
    @NotNull
    private static final ThreadLocalisedExceptionHandler DEBUG;
    private static final int JVM_JAVA_MAJOR_VERSION;
    private static final boolean IS_JAVA_9_PLUS;
    private static final boolean IS_JAVA_12_PLUS;
    private static final boolean IS_JAVA_14_PLUS;
    private static final long MAX_DIRECT_MEMORY;
    private static final boolean SAFEPOINT_ENABLED;
    private static final boolean IS_ARM;
    private static final Map<Class, ClassMetrics> CLASS_METRICS_MAP;
    private static final Map<Class, Integer> PRIMITIVE_SIZE;
    private static final MethodHandle setAccessible0_Method;
    private static final MethodHandle onSpinWaitMH;
    private static final ChainedSignalHandler signalHandlerGlobal;
    private static final boolean RESOURCE_TRACING;
    private static final /* synthetic */ Jvm[] $VALUES;

    public static Jvm[] values() {
        return (Jvm[])$VALUES.clone();
    }

    public static Jvm valueOf(String name) {
        return Enum.valueOf(Jvm.class, name);
    }

    private static void findAndLoadSystemProperties() {
        String systemProperties = System.getProperty("system.properties");
        boolean wasSet = true;
        if (systemProperties == null) {
            if (new File("system.properties").exists()) {
                systemProperties = "system.properties";
            } else if (new File("../system.properties").exists()) {
                systemProperties = "../system.properties";
            } else {
                systemProperties = "system.properties";
                wasSet = false;
            }
        }
        Jvm.loadSystemProperties(systemProperties, wasSet);
    }

    private static MethodHandle get_setAccessible0_Method() {
        if (!IS_JAVA_9_PLUS) {
            return null;
        }
        MethodType signature = MethodType.methodType(Boolean.TYPE, Boolean.TYPE);
        try {
            Method privateLookupIn = MethodHandles.class.getDeclaredMethod("privateLookupIn", Class.class, MethodHandles.Lookup.class);
            MethodHandles.Lookup lookup = (MethodHandles.Lookup)privateLookupIn.invoke(null, AccessibleObject.class, MethodHandles.lookup());
            return lookup.findVirtual(AccessibleObject.class, "setAccessible0", signature);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new ExceptionInInitializerError(e);
        }
    }

    public static void init() {
    }

    private static void loadSystemProperties(String name, boolean wasSet) {
        try {
            File file;
            InputStream is0;
            ClassLoader classLoader = Jvm.class.getClassLoader();
            InputStream inputStream = is0 = classLoader == null ? null : classLoader.getResourceAsStream(name);
            if (is0 == null && (file = new File(name)).exists()) {
                is0 = new FileInputStream(file);
            }
            try (InputStream is = is0;){
                if (is == null) {
                    (wasSet ? Slf4jExceptionHandler.WARN : Slf4jExceptionHandler.DEBUG).on(Jvm.class, "No " + name + " file found");
                } else {
                    Properties prop = new Properties();
                    prop.load(is);
                    System.getProperties().putAll((Map<?, ?>)prop);
                    Slf4jExceptionHandler.DEBUG.on(Jvm.class, "Loaded " + name + " with " + prop);
                }
            }
        }
        catch (Exception e) {
            Slf4jExceptionHandler.WARN.on(Jvm.class, "Error loading " + name, e);
        }
    }

    private static int getCompileThreshold0() {
        for (String inputArgument : INPUT_ARGUMENTS) {
            String prefix;
            if (!inputArgument.startsWith(prefix = "-XX:CompileThreshold=")) continue;
            return Integer.parseInt(inputArgument.substring(prefix.length()));
        }
        return 10000;
    }

    public static int compileThreshold() {
        return COMPILE_THRESHOLD;
    }

    public static int majorVersion() {
        return JVM_JAVA_MAJOR_VERSION;
    }

    public static boolean isJava9Plus() {
        return IS_JAVA_9_PLUS;
    }

    public static boolean isJava12Plus() {
        return IS_JAVA_12_PLUS;
    }

    public static boolean isJava14Plus() {
        return IS_JAVA_14_PLUS;
    }

    private static boolean is64bit0() {
        String systemProp = System.getProperty("com.ibm.vm.bitmode");
        if (systemProp != null) {
            return "64".equals(systemProp);
        }
        systemProp = System.getProperty("sun.arch.data.model");
        if (systemProp != null) {
            return "64".equals(systemProp);
        }
        systemProp = System.getProperty("java.vm.version");
        return systemProp != null && systemProp.contains("_64");
    }

    public static int getProcessId() {
        return PROCESS_ID;
    }

    private static int getProcessId0() {
        String pid = null;
        File self = new File("/proc/self");
        try {
            if (self.exists()) {
                pid = self.getCanonicalFile().getName();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (pid == null) {
            pid = ManagementFactory.getRuntimeMXBean().getName().split("@", 0)[0];
        }
        if (pid == null) {
            int rpid = new Random().nextInt(65536);
            System.err.println(Jvm.class.getName() + ": Unable to determine PID, picked a random number=" + rpid);
            return rpid;
        }
        return Integer.parseInt(pid);
    }

    @NotNull
    public static <T extends Throwable> RuntimeException rethrow(Throwable throwable) throws T {
        throw throwable;
    }

    public static void trimStackTrace(@NotNull StringBuilder sb, StackTraceElement ... stes) {
        int first = Jvm.trimFirst(stes);
        int last = Jvm.trimLast(first, stes);
        for (int i = first; i <= last; ++i) {
            sb.append("\n\tat ").append(stes[i]);
        }
    }

    static int trimFirst(@NotNull StackTraceElement[] stes) {
        int first;
        if (stes.length > 2 && stes[1].getMethodName().endsWith("afepoint")) {
            return 2;
        }
        for (first = 0; first < stes.length && Jvm.isInternal(stes[first].getClassName()); ++first) {
        }
        return Math.max(0, first - 2);
    }

    public static int trimLast(int first, @NotNull StackTraceElement[] stes) {
        int last;
        for (last = stes.length - 1; first < last && Jvm.isInternal(stes[last].getClassName()); --last) {
        }
        if (last < stes.length - 1) {
            ++last;
        }
        return last;
    }

    static boolean isInternal(@NotNull String className) {
        return className.startsWith("jdk.") || className.startsWith("sun.") || className.startsWith("java.");
    }

    public static boolean isDebug() {
        return IS_DEBUG;
    }

    public static boolean isFlightRecorder() {
        return IS_FLIGHT_RECORDER;
    }

    public static void pause(long millis) {
        if (millis <= 0L) {
            Thread.yield();
            return;
        }
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public static void nanoPause() {
        if (onSpinWaitMH == null) {
            Jvm.safepoint();
        } else {
            try {
                onSpinWaitMH.invokeExact();
            }
            catch (Throwable throwable) {
                throw new AssertionError((Object)throwable);
            }
        }
    }

    public static void busyWaitMicros(long micros) {
        Jvm.busyWaitUntil(System.nanoTime() + micros * 1000L);
    }

    public static void busyWaitUntil(long waitUntil) {
        while (waitUntil > System.nanoTime()) {
            Jvm.nanoPause();
        }
    }

    public static Field getField(@NotNull Class clazz, @NotNull String name) {
        try {
            Field field = clazz.getDeclaredField(name);
            Jvm.setAccessible(field);
            return field;
        }
        catch (NoSuchFieldException e) {
            Class superclass = clazz.getSuperclass();
            if (superclass != null) {
                try {
                    return Jvm.getField(superclass, name);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            throw new AssertionError((Object)e);
        }
    }

    public static Method getMethod(@NotNull Class clazz, @NotNull String name, Class ... args) {
        return Jvm.getMethod0(clazz, name, args, true);
    }

    private static Method getMethod0(@NotNull Class clazz, @NotNull String name, Class[] args, boolean first) {
        try {
            Method method = clazz.getDeclaredMethod(name, args);
            if (!Modifier.isPublic(method.getModifiers()) || !Modifier.isPublic(method.getDeclaringClass().getModifiers())) {
                Jvm.setAccessible(method);
            }
            return method;
        }
        catch (NoSuchMethodException e) {
            Class superclass = clazz.getSuperclass();
            if (superclass != null) {
                try {
                    Method m = Jvm.getMethod0(superclass, name, args, false);
                    if (m != null) {
                        return m;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (first) {
                throw new AssertionError((Object)e);
            }
            return null;
        }
    }

    public static void setAccessible(AccessibleObject h) {
        if (IS_JAVA_9_PLUS) {
            try {
                boolean newFlag = setAccessible0_Method.invokeExact(h, true);
                assert (newFlag);
            }
            catch (Throwable throwable) {
                Jvm.rethrow(throwable);
            }
        } else {
            h.setAccessible(true);
        }
    }

    public static <V> V getValue(@NotNull Object obj, @NotNull String name) {
        Class<?> aClass = obj.getClass();
        for (String n : name.split("/")) {
            Field f = Jvm.getField(aClass, n);
            try {
                obj = f.get(obj);
                if (obj == null) {
                    return null;
                }
            }
            catch (IllegalAccessException e) {
                throw new AssertionError((Object)e);
            }
            aClass = obj.getClass();
        }
        return (V)obj;
    }

    public static String lockWithStack(@NotNull ReentrantLock lock) {
        Thread t = (Thread)Jvm.getValue(lock, "sync/exclusiveOwnerThread");
        if (t == null) {
            return lock.toString();
        }
        StringBuilder ret = new StringBuilder();
        ret.append(lock).append(" running at");
        Jvm.trimStackTrace(ret, t.getStackTrace());
        return ret.toString();
    }

    public static long usedDirectMemory() {
        return reservedMemory.get();
    }

    public static long usedNativeMemory() {
        return UnsafeMemory.INSTANCE.nativeMemoryUsed();
    }

    public static long maxDirectMemory() {
        return MAX_DIRECT_MEMORY;
    }

    public static boolean is64bit() {
        return IS_64BIT;
    }

    public static void resetExceptionHandlers() {
        FATAL.defaultHandler(Slf4jExceptionHandler.FATAL).resetThreadLocalHandler();
        WARN.defaultHandler(Slf4jExceptionHandler.WARN).resetThreadLocalHandler();
        DEBUG.defaultHandler(Slf4jExceptionHandler.DEBUG).resetThreadLocalHandler();
        PERF.defaultHandler(Slf4jExceptionHandler.DEBUG).resetThreadLocalHandler();
    }

    public static void disableDebugHandler() {
        DEBUG.defaultHandler(null).resetThreadLocalHandler();
    }

    @NotNull
    public static Map<ExceptionKey, Integer> recordExceptions() {
        return Jvm.recordExceptions(true);
    }

    @NotNull
    public static Map<ExceptionKey, Integer> recordExceptions(boolean debug) {
        return Jvm.recordExceptions(debug, false);
    }

    @NotNull
    public static Map<ExceptionKey, Integer> recordExceptions(boolean debug, boolean exceptionsOnly) {
        return Jvm.recordExceptions(debug, exceptionsOnly, true);
    }

    @NotNull
    public static Map<ExceptionKey, Integer> recordExceptions(boolean debug, boolean exceptionsOnly, boolean logToSlf4j) {
        Map<ExceptionKey, Integer> map = Collections.synchronizedMap(new LinkedHashMap());
        FATAL.defaultHandler(Jvm.recordingExceptionHandler(LogLevel.FATAL, map, exceptionsOnly, logToSlf4j));
        WARN.defaultHandler(Jvm.recordingExceptionHandler(LogLevel.WARN, map, exceptionsOnly, logToSlf4j));
        DEBUG.defaultHandler((ExceptionHandler)(debug ? Jvm.recordingExceptionHandler(LogLevel.DEBUG, map, exceptionsOnly, logToSlf4j) : (logToSlf4j ? Slf4jExceptionHandler.DEBUG : NullExceptionHandler.NOTHING)));
        return map;
    }

    private static ExceptionHandler recordingExceptionHandler(LogLevel logLevel, Map<ExceptionKey, Integer> map, boolean exceptionsOnly, boolean logToSlf4j) {
        ExceptionHandler eh = new RecordingExceptionHandler(logLevel, map, exceptionsOnly);
        if (logToSlf4j) {
            eh = new ChainedExceptionHandler(eh, Slf4jExceptionHandler.valueOf(logLevel));
        }
        return eh;
    }

    public static boolean hasException(@NotNull Map<ExceptionKey, Integer> exceptions) {
        for (ExceptionKey k : exceptions.keySet()) {
            if (k.throwable == null || k.throwable instanceof StackTrace || k.level == LogLevel.DEBUG) continue;
            return true;
        }
        return false;
    }

    @Deprecated
    public static void setExceptionsHandlers(@Nullable ExceptionHandler fatal, @Nullable ExceptionHandler warn, @Nullable ExceptionHandler debug) {
        Jvm.setExceptionHandlers(fatal, warn, debug);
    }

    public static void setExceptionHandlers(@Nullable ExceptionHandler fatal, @Nullable ExceptionHandler warn, @Nullable ExceptionHandler debug) {
        FATAL.defaultHandler(fatal);
        WARN.defaultHandler(warn);
        DEBUG.defaultHandler(debug);
    }

    public static void setExceptionHandlers(@Nullable ExceptionHandler fatal, @Nullable ExceptionHandler warn, @Nullable ExceptionHandler debug, @Nullable ExceptionHandler perf) {
        Jvm.setExceptionHandlers(fatal, warn, debug);
        PERF.defaultHandler(perf);
    }

    public static void setThreadLocalExceptionHandlers(@Nullable ExceptionHandler fatal, @Nullable ExceptionHandler warn, @Nullable ExceptionHandler debug) {
        FATAL.threadLocalHandler(fatal);
        WARN.threadLocalHandler(warn);
        DEBUG.threadLocalHandler(debug);
    }

    public static void setThreadLocalExceptionHandlers(@Nullable ExceptionHandler fatal, @Nullable ExceptionHandler warn, @Nullable ExceptionHandler debug, @Nullable ExceptionHandler perf) {
        Jvm.setThreadLocalExceptionHandlers(fatal, warn, debug);
        PERF.threadLocalHandler(debug);
    }

    @NotNull
    public static ExceptionHandler fatal() {
        return FATAL;
    }

    @NotNull
    public static ExceptionHandler warn() {
        return WARN;
    }

    @NotNull
    public static ExceptionHandler perf() {
        return PERF;
    }

    @NotNull
    public static ExceptionHandler debug() {
        return DEBUG;
    }

    public static void dumpException(@NotNull Map<ExceptionKey, Integer> exceptions) {
        System.out.println("exceptions: " + exceptions.size());
        for (Map.Entry<ExceptionKey, Integer> entry : exceptions.entrySet()) {
            Integer value;
            ExceptionKey key = entry.getKey();
            System.err.println((Object)((Object)key.level) + " " + key.clazz.getSimpleName() + " " + key.message);
            if (key.throwable != null) {
                key.throwable.printStackTrace();
            }
            if ((value = entry.getValue()) <= 1) continue;
            System.err.println("Repeated " + value + " times");
        }
        Jvm.resetExceptionHandlers();
    }

    public static boolean isDebugEnabled(Class aClass) {
        return DEBUG.isEnabled(aClass) || Jvm.isDebug();
    }

    private static long maxDirectMemory0() {
        try {
            Class<?> clz = IS_JAVA_9_PLUS ? Class.forName("jdk.internal.misc.VM") : Class.forName("sun.misc.VM");
            Field f = clz.getDeclaredField("directMemory");
            long offset = UnsafeMemory.UNSAFE.staticFieldOffset(f);
            Object base = UnsafeMemory.UNSAFE.staticFieldBase(f);
            return UnsafeMemory.UNSAFE.getLong(base, offset);
        }
        catch (Exception exception) {
            System.err.println(Jvm.class.getName() + ": Unable to determine max direct memory");
            return 0L;
        }
    }

    private static int getMajorVersion0() {
        try {
            Method method = Runtime.class.getDeclaredMethod("version", new Class[0]);
            if (method != null) {
                Object version = method.invoke((Object)Runtime.getRuntime(), new Object[0]);
                Class<?> clz = Class.forName("java.lang.Runtime$Version");
                return (Integer)clz.getDeclaredMethod("major", new Class[0]).invoke(version, new Object[0]);
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            // empty catch block
        }
        return Integer.parseInt(Runtime.class.getPackage().getSpecificationVersion().split("\\.")[1]);
    }

    public static void signalHandler(SignalHandler signalHandler) {
        if (Jvm.signalHandlerGlobal.handlers.isEmpty()) {
            if (!OS.isWindows()) {
                Jvm.addSignalHandler("HUP", signalHandlerGlobal);
            }
            Jvm.addSignalHandler("INT", signalHandlerGlobal);
            Jvm.addSignalHandler("TERM", signalHandlerGlobal);
        }
        SignalHandler signalHandler2 = signal -> {
            Jvm.warn().on(signalHandler.getClass(), "Signal " + signal.getName() + " triggered");
            signalHandler.handle(signal);
        };
        Jvm.signalHandlerGlobal.handlers.add(signalHandler2);
    }

    private static void addSignalHandler(String sig, SignalHandler signalHandler) {
        try {
            Signal.handle(new Signal(sig), signalHandler);
        }
        catch (IllegalArgumentException e) {
            Jvm.warn().on(signalHandler.getClass(), "Unable add a signal handler", e);
        }
    }

    public static void safepoint() {
        if (SAFEPOINT_ENABLED) {
            if (IS_JAVA_9_PLUS) {
                Safepoint.force();
            } else {
                Compiler.enable();
            }
        }
    }

    @Deprecated
    public static void optionalSafepoint() {
        Jvm.safepoint();
    }

    public static boolean areOptionalSafepointsEnabled() {
        return SAFEPOINT_ENABLED;
    }

    public static boolean stackTraceEndsWith(String endsWith, int n) {
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        for (int i = n + 2; i < stackTrace.length; ++i) {
            if (!stackTrace[i].getClassName().endsWith(endsWith)) continue;
            return true;
        }
        return false;
    }

    public static boolean isArm() {
        return IS_ARM;
    }

    public static ClassMetrics classMetrics(Class c) throws IllegalArgumentException {
        return CLASS_METRICS_MAP.computeIfAbsent(c, Jvm::getClassMetrics);
    }

    private static ClassMetrics getClassMetrics(Class c) {
        Class superclass = c.getSuperclass();
        int start = Integer.MAX_VALUE;
        int end = 0;
        for (Field f : c.getDeclaredFields()) {
            if ((f.getModifiers() & 0x88) != 0 || !f.getType().isPrimitive()) continue;
            int start0 = Math.toIntExact(UnsafeMemory.UNSAFE.objectFieldOffset(f));
            int size = PRIMITIVE_SIZE.get(f.getType());
            start = Math.min(start0, start);
            end = Math.max(start0 + size, end);
        }
        if (superclass != null && superclass != Object.class) {
            ClassMetrics cm0 = Jvm.getClassMetrics(superclass);
            start = Math.min(cm0.offset(), start);
            end = Math.max(cm0.offset() + cm0.length(), end);
            Jvm.validateClassMetrics(superclass, start, end);
        }
        Jvm.validateClassMetrics(c, start, end);
        return new ClassMetrics(start, end - start);
    }

    private static void validateClassMetrics(Class c, int start, int end) {
        for (Field f : c.getDeclaredFields()) {
            int start0;
            if ((f.getModifiers() & 8) != 0 || f.getType().isPrimitive() || start > (start0 = Math.toIntExact(UnsafeMemory.UNSAFE.objectFieldOffset(f))) || start0 >= end) continue;
            throw new IllegalArgumentException(c + " is not suitable for raw copies due to " + f);
        }
    }

    public static String userHome() {
        return System.getProperty("user.home", ".");
    }

    public static boolean dontChain(Class tClass) {
        return tClass.getAnnotation(DontChain.class) != null || tClass.getName().startsWith("java");
    }

    public static boolean isResourceTracing() {
        return RESOURCE_TRACING;
    }

    public static boolean getBoolean(String property) {
        return Jvm.getBoolean(property, false);
    }

    public static boolean getBoolean(String property, boolean defaultValue) {
        String value = System.getProperty(property);
        if (value == null) {
            return defaultValue;
        }
        if (value.isEmpty()) {
            return true;
        }
        String trim = value.trim();
        return defaultValue ? !ObjectUtils.isFalse(trim) : ObjectUtils.isTrue(trim);
    }

    public static long address(ByteBuffer bb) {
        return ((DirectBuffer)((Object)bb)).address();
    }

    public static int arrayByteBaseOffset() {
        return Unsafe.ARRAY_BYTE_BASE_OFFSET;
    }

    public static void doNotCloseOnInterrupt(Class clazz, FileChannel fc) {
        if (Jvm.isJava9Plus()) {
            Jvm.doNotCloseOnInterrupt9(clazz, fc);
        } else {
            Jvm.doNotCloseOnInterrupt8(clazz, fc);
        }
    }

    private static void doNotCloseOnInterrupt8(Class clazz, FileChannel fc) {
        try {
            Field field = AbstractInterruptibleChannel.class.getDeclaredField("interruptor");
            Jvm.setAccessible(field);
            field.set(fc, thread -> System.err.println(clazz.getName() + " - " + fc + " not closed on interrupt"));
        }
        catch (Throwable e) {
            Jvm.warn().on(clazz, "Couldn't disable close on interrupt", e);
        }
    }

    private static void doNotCloseOnInterrupt9(Class clazz, FileChannel fc) {
        try {
            Field field = AbstractInterruptibleChannel.class.getDeclaredField("interruptor");
            Class<?> interruptibleClass = field.getType();
            Jvm.setAccessible(field);
            field.set(fc, Proxy.newProxyInstance(interruptibleClass.getClassLoader(), new Class[]{interruptibleClass}, (p, m, a) -> {
                System.err.println(clazz.getName() + " - " + fc + " not closed on interrupt");
                return null;
            }));
        }
        catch (Throwable e) {
            Jvm.warn().on(clazz, "Couldn't disable close on interrupt", e);
        }
    }

    static {
        Supplier<Long> reservedMemoryGetter;
        $VALUES = new Jvm[0];
        INPUT_ARGUMENTS = ManagementFactory.getRuntimeMXBean().getInputArguments();
        COMPILE_THRESHOLD = Jvm.getCompileThreshold0();
        IS_DEBUG = INPUT_ARGUMENTS.toString().contains("jdwp") || Jvm.getBoolean("debug");
        IS_FLIGHT_RECORDER = (" " + ManagementFactory.getRuntimeMXBean().getInputArguments()).contains(" -XX:+FlightRecorder") || Jvm.getBoolean("jfr");
        IS_64BIT = Jvm.is64bit0();
        PROCESS_ID = Jvm.getProcessId0();
        FATAL = new ThreadLocalisedExceptionHandler(Slf4jExceptionHandler.FATAL);
        WARN = new ThreadLocalisedExceptionHandler(Slf4jExceptionHandler.WARN);
        PERF = new ThreadLocalisedExceptionHandler(Slf4jExceptionHandler.PERF);
        DEBUG = new ThreadLocalisedExceptionHandler(Slf4jExceptionHandler.DEBUG);
        IS_ARM = Jvm.getBoolean("jvm.isarm") || System.getProperty("os.arch", "?").startsWith("arm") || System.getProperty("os.arch", "?").startsWith("aarch");
        CLASS_METRICS_MAP = new ConcurrentHashMap<Class, ClassMetrics>();
        PRIMITIVE_SIZE = new HashMap<Class, Integer>(){
            {
                this.put(Boolean.TYPE, 1);
                this.put(Byte.TYPE, 1);
                this.put(Character.TYPE, 2);
                this.put(Short.TYPE, 2);
                this.put(Integer.TYPE, 4);
                this.put(Float.TYPE, 4);
                this.put(Long.TYPE, 8);
                this.put(Double.TYPE, 8);
            }
        };
        JVM_JAVA_MAJOR_VERSION = Jvm.getMajorVersion0();
        IS_JAVA_9_PLUS = JVM_JAVA_MAJOR_VERSION > 8;
        IS_JAVA_12_PLUS = JVM_JAVA_MAJOR_VERSION > 11;
        IS_JAVA_14_PLUS = JVM_JAVA_MAJOR_VERSION > 13;
        MAX_DIRECT_MEMORY = Jvm.maxDirectMemory0();
        try {
            Field f;
            Class<?> bitsClass = Class.forName("java.nio.Bits");
            try {
                f = bitsClass.getDeclaredField("reservedMemory");
            }
            catch (NoSuchFieldException e) {
                f = bitsClass.getDeclaredField("RESERVED_MEMORY");
            }
            long offset = UnsafeMemory.UNSAFE.staticFieldOffset(f);
            Object base = UnsafeMemory.UNSAFE.staticFieldBase(f);
            if (f.getType() == AtomicLong.class) {
                AtomicLong reservedMemory = (AtomicLong)UnsafeMemory.UNSAFE.getObject(base, offset);
                reservedMemoryGetter = reservedMemory::get;
            } else {
                reservedMemoryGetter = () -> UnsafeMemory.UNSAFE.getLong(base, offset);
            }
        }
        catch (Exception e) {
            System.err.println(Jvm.class.getName() + ": Unable to determine the reservedMemory value, will always report 0");
            reservedMemoryGetter = () -> 0L;
        }
        reservedMemory = reservedMemoryGetter;
        signalHandlerGlobal = new ChainedSignalHandler();
        MethodHandle onSpinWait = null;
        if (IS_JAVA_9_PLUS) {
            try {
                onSpinWait = MethodHandles.lookup().findStatic(Thread.class, "onSpinWait", MethodType.methodType(Void.TYPE));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        onSpinWaitMH = onSpinWait;
        setAccessible0_Method = Jvm.get_setAccessible0_Method();
        Jvm.findAndLoadSystemProperties();
        SAFEPOINT_ENABLED = Jvm.getBoolean("jvm.safepoint.enabled");
        RESOURCE_TRACING = Jvm.getBoolean("jvm.resource.tracing");
    }

    private static class ChainedSignalHandler
    implements SignalHandler {
        final List<SignalHandler> handlers = new CopyOnWriteArrayList<SignalHandler>();

        private ChainedSignalHandler() {
        }

        @Override
        public void handle(Signal signal) {
            for (SignalHandler handler : this.handlers) {
                try {
                    if (handler == null) continue;
                    handler.handle(signal);
                }
                catch (Throwable t) {
                    Jvm.warn().on(this.getClass(), "Problem handling signal", t);
                }
            }
        }
    }

    static class Safepoint {
        private static volatile int one = 1;

        Safepoint() {
        }

        public static void force() {
            for (int i = 0; i < one; ++i) {
            }
        }
    }
}

