/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.internal.analytics.http;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import net.openhft.chronicle.core.Jvm;
import org.jetbrains.annotations.NotNull;

public enum HttpUtil {

    private static final boolean OUTPUT = Jvm.getBoolean("chronicle.analytics.output");
    private static final Executor EXECUTOR = Executors.newSingleThreadExecutor(runnable -> {
        Thread thread = new Thread(runnable, "analytics-http-client");
        thread.setDaemon(true);
        return thread;
    });

    public static void send(@NotNull String urlString, @NotNull String json) {
        EXECUTOR.execute(new Sender(urlString, json));
    }

    private static final class Sender
    implements Runnable {
        private final String urlString;
        private final String json;

        public Sender(@NotNull String urlString, @NotNull String json) {
            this.urlString = urlString;
            this.json = json;
        }

        @Override
        public void run() {
            block29: {
                try {
                    URL url = new URL(this.urlString);
                    HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                    conn.setRequestMethod("POST");
                    conn.setRequestProperty("Content-Type", "text/plain; charset=UTF-8");
                    conn.setRequestProperty("Accept", "application/json");
                    conn.setDoOutput(true);
                    try (OutputStream os = conn.getOutputStream();){
                        byte[] input = this.json.getBytes(StandardCharsets.UTF_8);
                        os.write(input, 0, input.length);
                        os.flush();
                    }
                    var4_5 = null;
                    try (BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream(), StandardCharsets.UTF_8));){
                        StringBuilder response = new StringBuilder();
                        String responseLine = null;
                        while ((responseLine = br.readLine()) != null) {
                            response.append(responseLine.trim());
                        }
                        if (OUTPUT) {
                            System.out.println(response.toString());
                        }
                    }
                    catch (Throwable throwable) {
                        var4_5 = throwable;
                        throw throwable;
                    }
                }
                catch (IOException ioe) {
                    if (!OUTPUT) break block29;
                    Jvm.warn().on(HttpUtil.class, ioe);
                }
            }
        }
    }
}

