/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.internal.analytics.google;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.AbstractMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.TimeZone;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.analytics.Analytics;
import net.openhft.chronicle.core.internal.analytics.http.HttpUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GoogleAnalytics
implements Analytics {
    private final long GIB = 0x100000L;
    private final String COOKIE_FILE_NAME = "software.chronicle.client.id";
    private static final String ENDPOINT_URL = "https://www.google-analytics.com/mp/collect";
    private static final String START_EVENT_NAME = "started";
    private final String libraryName;
    private final String version;
    private final String clientId;
    private final Account account;

    public GoogleAnalytics(@NotNull String libraryName, @NotNull String version) {
        this.libraryName = libraryName;
        this.version = version;
        this.clientId = this.acquireClientId();
        this.account = this.account(libraryName);
    }

    @Override
    public void onStart(@NotNull Map<String, String> eventParameters) {
        this.httpSend(START_EVENT_NAME, eventParameters);
    }

    @Override
    public void onFeature(@NotNull String id, @NotNull Map<String, String> eventParameters) {
        this.httpSend(id, eventParameters);
    }

    private void httpSend(@NotNull String eventName, @NotNull Map<String, String> eventParameters) {
        if (this.account != null) {
            String url = "https://www.google-analytics.com/mp/collect?measurement_id=" + this.urlEncode(this.account.measurmentId()) + "&api_secret=" + this.urlEncode(this.account.apiSectret());
            String json = this.jsonFor(eventName, eventParameters, this.userProperties());
            HttpUtil.send(url, json);
        }
    }

    private String jsonFor(@NotNull String eventName, @NotNull Map<String, String> eventParameters, @NotNull Map<String, Object> userProperties) {
        return Stream.of("{", this.jsonElement(" ", "clientId", this.clientId) + ",", this.jsonElement(" ", "userId", this.clientId) + ",", this.jsonElement(" ", "nonPersonalizedAds", true) + ",", " " + this.asElement("events") + ": [{", this.jsonElement("  ", "name", eventName) + ",", "  " + this.asElement("params") + ": {", this.jsonElement("   ", "app_version", this.version) + (eventParameters.isEmpty() ? "" : ","), eventParameters.entrySet().stream().map(e -> this.jsonElement("   ", (String)e.getKey(), e.getValue())).collect(Collectors.joining(String.format(",%n", new Object[0]))), "  }", " }],", " " + this.asElement("userProperties") + ": {", userProperties.entrySet().stream().map(this::userProperty).collect(Collectors.joining(String.format(",%n", new Object[0]))), " }", "}").collect(Collectors.joining(this.nl()));
    }

    private String jsonElement(String indent, String key, Object value) {
        return indent + this.asElement(key) + ": " + this.asElement(value);
    }

    private String asElement(Object value) {
        return value instanceof CharSequence ? "\"" + value + "\"" : value.toString();
    }

    private String userProperty(Map.Entry<String, Object> userProperty) {
        return String.format("  %s: {%n %s%n  }", this.asElement(userProperty.getKey()), this.jsonElement("   ", "value", userProperty.getValue()));
    }

    private String urlEncode(String s) {
        try {
            return URLEncoder.encode(s, StandardCharsets.UTF_8.toString());
        }
        catch (UnsupportedEncodingException e) {
            Jvm.rethrow(e);
            throw new RuntimeException();
        }
    }

    private Map<String, Object> userProperties() {
        return Stream.of(GoogleAnalytics.entryFor("java.runtime.name"), GoogleAnalytics.entryFor("java.runtime.version"), GoogleAnalytics.entryFor("os.name"), GoogleAnalytics.entryFor("os.arch"), GoogleAnalytics.entryFor("os.version"), GoogleAnalytics.entry(GoogleAnalytics.replaceDotsWithUnderscore("timezone.default"), TimeZone.getDefault().getID()), GoogleAnalytics.entry(GoogleAnalytics.replaceDotsWithUnderscore("available.processors"), Integer.toString(Runtime.getRuntime().availableProcessors())), GoogleAnalytics.entry(GoogleAnalytics.replaceDotsWithUnderscore("max.memory.gib"), Long.toString(Runtime.getRuntime().maxMemory() / 0x100000L)), GoogleAnalytics.entry(GoogleAnalytics.replaceDotsWithUnderscore("java.major.version"), Long.toString(Jvm.majorVersion())), GoogleAnalytics.entry(GoogleAnalytics.replaceDotsWithUnderscore("max.direct.memory.gib"), Long.toString(Jvm.maxDirectMemory() / 0x100000L))).filter(e -> e.getValue() != null).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (a, b) -> b, LinkedHashMap::new));
    }

    private static Map.Entry<String, String> entryFor(@NotNull String systemProperty) {
        return new AbstractMap.SimpleImmutableEntry<String, String>(GoogleAnalytics.replaceDotsWithUnderscore(systemProperty), System.getProperty(systemProperty));
    }

    private static Map.Entry<String, Object> entry(@NotNull String key, @Nullable Object value) {
        return new AbstractMap.SimpleImmutableEntry<String, Object>(key, value);
    }

    private String acquireClientId() {
        String userHome = System.getProperty("user.home");
        try {
            Path path = Paths.get(userHome, "software.chronicle.client.id");
            return Files.lines(path, StandardCharsets.UTF_8).findFirst().map(UUID::fromString).orElseThrow(NoSuchElementException::new).toString();
        }
        catch (Exception path) {
            String clientId = UUID.randomUUID().toString();
            try {
                Path path2 = Paths.get(userHome, "software.chronicle.client.id");
                Files.write(path2, clientId.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return clientId;
        }
    }

    private Account account(String libraryName) {
        switch (libraryName) {
            case "chronicle-map": {
                return Account.create("G-TDTJG5CT6G", "J8qsWGHgQP6CLs43mQ10KQ");
            }
            case "chronicle-queue": {
                return Account.create("G-4K5MBLGPLE", "k1hK3x2qQaKk4F5gL-PBhQ");
            }
            case "chronicle-queue-demo": {
                return Account.create("G-Q699PK0278", "YDkgw-3DR6yMIcGsCGxrBg");
            }
            case "chronicle-decentred": {
                return Account.create("G-MHNQF60609", "lwahZLwuR62lmlhWQO_XYA");
            }
            case "chronicle-websocket-jetty": {
                return Account.create("G-664QLSXFND", "CI402HSGRN-ou20YMSTV9Q");
            }
            case "chronicle-wire-enterprise": {
                return Account.create("G-FLEY5Z3PTV", "w4HxPDbzR2We_8XoF79BRA");
            }
            case "chronicle-network-enterprise": {
                return Account.create("G-TVNVZ37HC0", "ymz2OTZgQtSUAHEV_fxVjw");
            }
            case "chronicle-services": {
                return Account.create("G-7QVV85K3RG", "u-ED1zpYRPqq4WwuuD25RQ");
            }
            case "chronicle-services-demo": {
                return Account.create("G-4H93Z95F9S", "VmiM3ElBRbaJXl6fskAOqw");
            }
            case "chronicle-fix": {
                return Account.create("G-V9N5NL07WJ", "iCo8d19UQG26zZKHDi5M5A");
            }
            case "chronicle-fix-demo": {
                return Account.create("G-1QJ7EZKQEZ", "HxiuHF85QKyZAJ9dWEHJZQ");
            }
            case "chronicle-queue-enterprise": {
                return Account.create("G-BP94BVC2ZS", "iPRHY5a2TbeBP8GuWaK0rA");
            }
            case "chronicle-queue-enterprise-demo": {
                return Account.create("G-XXR6JRVS5V", "Fz9YiKtmQ1ukSunPIwxfQw");
            }
            case "chronicle-queue-zero": {
                return Account.create("G-H50N0NLQ7C", "2NgRCqTtQx-aR6gwZVpshg");
            }
            case "chronicle-map-enterprise": {
                return Account.create("G-TKNRN0Y813", "SKYi5vinTDGgLuiMKU2UXA");
            }
            case "chronicle-ring": {
                return Account.create("G-C1WV1K8P3C", "MqQm60ViRkO385xUs1zQ9Q");
            }
            case "chronicle-datagrid": {
                return Account.create("G-H0VN4G0ZYL", "-hftABXXRB-Z4hL8KrMOPw");
            }
            case "chronicle-datagrid-demo": {
                return Account.create("G-N8NLPDX36X", "BdyxSG6iT6Cc8nWz5YxzrA");
            }
            case "chronicle-market-data-distributor": {
                return Account.create("G-FR9BRC8NSW", "FC8RHQpLROOGCCRFiXiKjg");
            }
            case "chronicle-market-data-distributor-demo": {
                return Account.create("G-RPPKNQD1PR", "4vpBLpK4QuOd6_3lDfL8sw");
            }
            case "efx": {
                return Account.create("G-PK6BJZNRD9", "c6ujn9xNQQqMfu07p8zPhw");
            }
        }
        return null;
    }

    private String nl() {
        return String.format("%n", new Object[0]);
    }

    private static String replaceDotsWithUnderscore(@NotNull String s) {
        return s.replace('.', '_');
    }

    static interface Account {
        public String measurmentId();

        public String apiSectret();

        public static Account create(final @NotNull String measurementId, final @NotNull String apiSecret) {
            return new Account(){

                @Override
                public String measurmentId() {
                    return measurementId;
                }

                @Override
                public String apiSectret() {
                    return apiSecret;
                }

                public String toString() {
                    return "(" + measurementId + ", " + apiSecret + ")";
                }
            };
        }
    }
}

