/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core;

import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.onoes.Slf4jExceptionHandler;

public enum FlakyTestRunner {

    static boolean IN_RUN = false;

    public static <T extends Throwable> void run(RunnableThrows<T> rt) throws T {
        FlakyTestRunner.run(true, rt);
    }

    public static <T extends Throwable> void run(boolean flakyOnThisArch, RunnableThrows<T> rt) throws T {
        if (!flakyOnThisArch) {
            rt.run();
            return;
        }
        try {
            if (IN_RUN) {
                throw new AssertionError((Object)"Can't run nested");
            }
            IN_RUN = true;
            rt.run();
        }
        catch (Throwable t) {
            System.err.println("Rerunning failing test");
            System.gc();
            Jvm.pause(500L);
            rt.run();
            Slf4jExceptionHandler.WARN.on(FlakyTestRunner.class, "Flaky test threw an error the first run, passed the second time", t);
        }
        finally {
            IN_RUN = false;
        }
    }

    public static interface RunnableThrows<T extends Throwable> {
        public void run() throws T;
    }
}

