/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.threads;

import java.util.function.Function;
import java.util.function.Supplier;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.core.util.ThrowingConsumer;

public class CleaningThreadLocal<T>
extends ThreadLocal<T> {
    private final Supplier<T> supplier;
    private final Function<T, T> getWrapper;
    private ThrowingConsumer<T, Exception> cleanup;

    CleaningThreadLocal(Supplier<T> supplier, ThrowingConsumer<T, Exception> cleanup) {
        this(supplier, cleanup, Function.identity());
    }

    CleaningThreadLocal(Supplier<T> supplier, ThrowingConsumer<T, Exception> cleanup, Function<T, T> getWrapper) {
        this.supplier = supplier;
        this.cleanup = cleanup;
        this.getWrapper = getWrapper;
    }

    public static <T> CleaningThreadLocal<T> withCloseQuietly() {
        return new CleaningThreadLocal<Object>(() -> null, Closeable::closeQuietly);
    }

    public static <T> CleaningThreadLocal<T> withCloseQuietly(Supplier<T> supplier) {
        return new CleaningThreadLocal<Object>(supplier, Closeable::closeQuietly);
    }

    public static <T> CleaningThreadLocal<T> withCleanup(ThrowingConsumer<T, Exception> cleanup) {
        return new CleaningThreadLocal<Object>(() -> null, cleanup);
    }

    public static <T> CleaningThreadLocal<T> withCleanup(Supplier<T> supplier, ThrowingConsumer<T, Exception> cleanup) {
        return new CleaningThreadLocal<T>(supplier, cleanup);
    }

    public static <T> CleaningThreadLocal<T> withCleanup(Supplier<T> supplier, ThrowingConsumer<T, Exception> cleanup, Function<T, T> getWrapper) {
        return new CleaningThreadLocal<T>(supplier, cleanup, getWrapper);
    }

    @Override
    protected T initialValue() {
        return this.supplier.get();
    }

    @Override
    public T get() {
        return this.getWrapper.apply(super.get());
    }

    public synchronized void cleanup(T value) {
        try {
            ThrowingConsumer<T, Exception> cleanup = this.cleanup;
            if (cleanup != null) {
                cleanup.accept(value);
            }
            this.cleanup = null;
        }
        catch (Exception e) {
            Jvm.warn().on(this.getClass(), "Exception cleaning up " + value.getClass(), e);
        }
    }
}

