/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.cleaner.impl.jdk9;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.nio.ByteBuffer;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.UnsafeMemory;
import net.openhft.chronicle.core.annotation.TargetMajorVersion;
import net.openhft.chronicle.core.cleaner.spi.ByteBufferCleanerService;

@TargetMajorVersion(majorVersion=9, includeNewer=true)
public final class Jdk9ByteBufferCleanerService
implements ByteBufferCleanerService {
    private static final MethodHandle invokeCleaner_Method = Jdk9ByteBufferCleanerService.get_invokeCleaner_Method();

    private static MethodHandle get_invokeCleaner_Method() {
        if (!Jvm.isJava9Plus()) {
            return null;
        }
        MethodType signature = MethodType.methodType(Void.TYPE, ByteBuffer.class);
        try {
            return MethodHandles.publicLookup().findVirtual(UnsafeMemory.UNSAFE.getClass(), "invokeCleaner", signature);
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            throw new ExceptionInInitializerError(e);
        }
    }

    @Override
    public void clean(ByteBuffer buffer) {
        try {
            invokeCleaner_Method.invokeExact(UnsafeMemory.UNSAFE, buffer);
        }
        catch (Throwable throwable) {
            Jvm.rethrow(throwable);
        }
    }

    @Override
    public int impact() {
        return 0;
    }
}

