/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core;

import org.jetbrains.annotations.Nullable;

public class StackTrace
extends Throwable {
    public StackTrace() {
        this("stack trace");
    }

    public StackTrace(String message) {
        this(message, null);
    }

    public StackTrace(String message, Throwable cause) {
        super(message + " on " + Thread.currentThread().getName(), cause);
    }

    @Nullable
    public static StackTrace forThread(Thread t) {
        if (t == null) {
            return null;
        }
        StackTrace st = new StackTrace(t.toString());
        StackTraceElement[] stackTrace = t.getStackTrace();
        if (stackTrace.length >= 2) {
            StackTraceElement[] stackTrace2 = new StackTraceElement[stackTrace.length - 2];
            System.arraycopy(stackTrace, 2, stackTrace2, 0, stackTrace2.length);
            st.setStackTrace(stackTrace2);
        }
        return st;
    }
}

