/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.io;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.io.AbstractCloseable;
import net.openhft.chronicle.core.io.AbstractReferenceCounted;

public enum BackgroundResourceReleaser {

    static final boolean BG_RELEASER = Jvm.getBoolean("background.releaser", true);
    private static final BlockingQueue<Object> RESOURCES = new ArrayBlockingQueue<Object>(128);
    private static transient long COUNT = 0L;
    private static final Thread RELEASER = new Thread(BackgroundResourceReleaser::runReleaseResources, "background~resource~releaser");

    private static void runReleaseResources() {
        try {
            while (true) {
                Object o = RESOURCES.take();
                ++COUNT;
                BackgroundResourceReleaser.performRelease(o);
                ++COUNT;
            }
        }
        catch (InterruptedException e) {
            Jvm.warn().on(BackgroundResourceReleaser.class, "Died on interrupt");
            return;
        }
    }

    public static void release(AbstractCloseable closeable) {
        BackgroundResourceReleaser.release0(closeable);
    }

    private static void release0(Object o) {
        if (RESOURCES.offer(o)) {
            return;
        }
        BackgroundResourceReleaser.performRelease(o);
    }

    public static void releasePendingResources() {
        try {
            while (true) {
                long count = COUNT;
                Object o = RESOURCES.poll(1L, TimeUnit.MILLISECONDS);
                if (o == null) {
                    long count2 = COUNT;
                    if (count != count2 || (count2 & 1L) == 1L) continue;
                    return;
                }
                BackgroundResourceReleaser.performRelease(o);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return;
        }
    }

    public static void release(AbstractReferenceCounted referenceCounted) {
        BackgroundResourceReleaser.release0(referenceCounted);
    }

    private static void performRelease(Object o) {
        if (o instanceof AbstractCloseable) {
            ((AbstractCloseable)o).performClose();
        } else if (o instanceof AbstractReferenceCounted) {
            ((AbstractReferenceCounted)o).performRelease();
        } else {
            Jvm.warn().on(BackgroundResourceReleaser.class, "Don't know how to release a " + o.getClass());
        }
    }

    static {
        RELEASER.setDaemon(true);
        RELEASER.start();
    }
}

