/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.util;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.LockSupport;

public enum Time {

    static volatile long lastTime = System.currentTimeMillis();
    static volatile long tickTime = 0L;

    public static long currentTimeMillis() {
        long now = System.currentTimeMillis();
        if (now == lastTime) {
            return now;
        }
        ++tickTime;
        lastTime = now;
        return lastTime;
    }

    public static long tickTime() {
        Time.currentTimeMillis();
        return tickTime;
    }

    public static void parkNanos(long nanos) {
        long millis = nanos / 1000000L;
        if (millis > 0L) {
            long start = System.currentTimeMillis();
            long startTT = tickTime;
            LockSupport.parkNanos(nanos);
            long end = System.currentTimeMillis();
            long endTT = Math.min(end - start, millis) + startTT;
            if (endTT > tickTime) {
                tickTime = endTT;
            }
        } else {
            Time.currentTimeMillis();
            LockSupport.parkNanos(nanos);
            Time.currentTimeMillis();
        }
    }

    public static void sleep(long time, TimeUnit timeUnit) {
        int millis = (int)timeUnit.convert(time, TimeUnit.MILLISECONDS);
        for (int i = 0; i < millis; ++i) {
            Time.currentTimeMillis();
            LockSupport.parkNanos(1000000L);
        }
    }
}

