/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.io;

import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.UnsafeMemory;
import net.openhft.chronicle.core.annotation.UsedViaReflection;
import net.openhft.chronicle.core.io.ReferenceCounted;
import net.openhft.chronicle.core.io.ReferenceOwner;

public final class VanillaReferenceCounted
implements ReferenceCounted {
    private static final long VALUE = UnsafeMemory.UNSAFE.objectFieldOffset(Jvm.getField(VanillaReferenceCounted.class, "value"));
    private final Runnable onRelease;
    private final boolean releaseOnOne;
    @UsedViaReflection
    private volatile int value;

    VanillaReferenceCounted(Runnable onRelease, boolean releaseOnOne) {
        this.onRelease = onRelease;
        this.releaseOnOne = releaseOnOne;
    }

    @Override
    public void reserve(ReferenceOwner id) throws IllegalStateException {
        int v;
        do {
            if ((v = this.value) > 0) continue;
            throw new IllegalStateException("Released");
        } while (!this.valueCompareAndSet(v, v + 1));
    }

    @Override
    public void reserveTransfer(ReferenceOwner from, ReferenceOwner to) throws IllegalStateException {
        this.throwExceptionIfReleased();
    }

    @Override
    public boolean tryReserve(ReferenceOwner id) {
        int v;
        do {
            if ((v = this.value) > 0) continue;
            return false;
        } while (!this.valueCompareAndSet(v, v + 1));
        return true;
    }

    private boolean valueCompareAndSet(int from, int to) {
        return UnsafeMemory.UNSAFE.compareAndSwapInt(this, VALUE, from, to);
    }

    @Override
    public void release(ReferenceOwner id) throws IllegalStateException {
        block2: {
            int count;
            block1: {
                int v;
                do {
                    if ((v = this.value) > 0) continue;
                    throw new IllegalStateException("Released");
                } while (!this.valueCompareAndSet(v, count = v - 1));
                if (count != 0) break block1;
                this.onRelease.run();
                break block2;
            }
            if (!this.releaseOnOne || count != 1) break block2;
            this.releaseLast(INIT);
        }
    }

    @Override
    public void releaseLast(ReferenceOwner id) throws IllegalStateException {
        do {
            int v;
            if ((v = this.value) <= 0) {
                throw new IllegalStateException("Released");
            }
            if (v <= 1) continue;
            throw new IllegalStateException("Not the last released");
        } while (!this.valueCompareAndSet(1, 0));
        this.onRelease.run();
    }

    @Override
    public int refCount() {
        return this.value;
    }

    public String toString() {
        return Integer.toString(this.value);
    }

    @Override
    public void throwExceptionBadResourceOwner() {
    }
}

