/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.io;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.StackTrace;
import net.openhft.chronicle.core.io.AbstractCloseable;
import net.openhft.chronicle.core.io.QueryCloseable;
import net.openhft.chronicle.core.io.ReferenceCounted;
import net.openhft.chronicle.core.io.ReferenceOwner;
import net.openhft.chronicle.core.io.VanillaReferenceOwner;
import org.jetbrains.annotations.NotNull;

public final class TracingReferenceCounted
implements ReferenceCounted {
    private final Map<ReferenceOwner, StackTrace> references = Collections.synchronizedMap(new IdentityHashMap());
    private final Map<ReferenceOwner, StackTrace> releases = Collections.synchronizedMap(new IdentityHashMap());
    private final Runnable onRelease;
    private final StackTrace init;
    private final boolean releaseOnOne;

    TracingReferenceCounted(Runnable onRelease, boolean releaseOnOne) {
        this.onRelease = onRelease;
        this.init = this.stackTrace("init", INIT);
        this.references.put(INIT, this.init);
        this.releaseOnOne = releaseOnOne;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reserve(ReferenceOwner id) throws IllegalStateException {
        if (id == this) {
            throw new IllegalArgumentException("The counter cannot reserve itself");
        }
        if (Jvm.isDebug()) {
            System.out.println(Thread.currentThread().getName() + " " + this.uniqueId() + " - reserve " + this.asString(id));
        }
        Map<ReferenceOwner, StackTrace> map = this.references;
        synchronized (map) {
            if (this.references.isEmpty()) {
                throw new IllegalStateException("Cannot reserve freed resource", this.init);
            }
            StackTrace stackTrace = this.references.get(id);
            if (stackTrace != null) {
                throw new IllegalStateException("Already reserved resource by " + id + " here", stackTrace);
            }
            this.references.putIfAbsent(id, this.stackTrace("reserve", id));
        }
        this.releases.remove(id);
    }

    private String asString(ReferenceOwner id) {
        return id == INIT ? "INIT" : (id instanceof VanillaReferenceOwner ? id.toString() : id.getClass().getSimpleName() + "@" + Integer.toHexString(System.identityHashCode(id)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean tryReserve(ReferenceOwner id) {
        if (Jvm.isDebug()) {
            System.out.println(Thread.currentThread().getName() + " " + this.uniqueId() + " - tryReserve " + this.asString(id));
        }
        Map<ReferenceOwner, StackTrace> map = this.references;
        synchronized (map) {
            if (this.references.isEmpty()) {
                return false;
            }
            this.references.put(id, this.stackTrace("reserve", id));
        }
        this.releases.remove(id);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release(ReferenceOwner id) throws IllegalStateException {
        if (Jvm.isDebug()) {
            System.out.println(Thread.currentThread().getName() + " " + this.uniqueId() + " - release " + this.asString(id));
        }
        Map<ReferenceOwner, StackTrace> map = this.references;
        synchronized (map) {
            if (this.releaseOnOne && id == INIT && this.references.containsKey(INIT) && this.references.size() > 1) {
                throw new IllegalStateException("INIT has to be the last release for releaseOnOne");
            }
            if (this.references.remove(id) == null) {
                StackTrace stackTrace = this.releases.get(id);
                if (stackTrace == null) {
                    Throwable cause = this.init;
                    if (!this.references.isEmpty()) {
                        StackTrace ste = this.references.values().iterator().next();
                        cause = new IllegalStateException("Reserved by " + this.referencesAsString(), ste);
                    }
                    throw new IllegalStateException("Not reserved by " + this.asString(id), cause);
                }
                throw new IllegalStateException("Already released " + this.asString(id) + " location ", stackTrace);
            }
            this.releases.put(id, this.stackTrace("release", id));
            if (this.references.isEmpty()) {
                this.onRelease.run();
            } else if (this.releaseOnOne && this.references.size() == 1) {
                this.releaseLast(INIT);
            }
        }
    }

    @NotNull
    public List<String> referencesAsString() {
        return this.references.keySet().stream().map(this::asString).collect(Collectors.toList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void releaseLast(ReferenceOwner id) throws IllegalStateException {
        Map<ReferenceOwner, StackTrace> map = this.references;
        synchronized (map) {
            if (this.references.size() > 1) {
                try {
                    this.release(id);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                IllegalStateException ise = new IllegalStateException("Still reserved " + this.referencesAsString(), this.init);
                this.references.values().forEach(ise::addSuppressed);
                throw ise;
            }
            this.release(id);
        }
    }

    @Override
    public int refCount() {
        return this.references.size();
    }

    @NotNull
    public String toString() {
        return this.uniqueId() + " - " + this.referencesAsString();
    }

    private String uniqueId() {
        return Integer.toHexString(System.identityHashCode(this));
    }

    @NotNull
    private StackTrace stackTrace(String oper, ReferenceOwner ro) {
        return new StackTrace(this.toString() + " " + Thread.currentThread().getName() + " " + oper + " " + this.asString(ro));
    }

    @Override
    public void throwExceptionBadResourceOwner() throws IllegalStateException {
        IllegalStateException ise = new IllegalStateException("Retained reference closed");
        for (ReferenceOwner referenceOwner : this.references.keySet()) {
            if (referenceOwner instanceof AbstractCloseable) {
                AbstractCloseable ac = (AbstractCloseable)referenceOwner;
                try {
                    ac.throwExceptionIfClosed();
                }
                catch (IllegalStateException e) {
                    ise.addSuppressed(e);
                }
                continue;
            }
            if (referenceOwner instanceof QueryCloseable) {
                try {
                    boolean closed = ((QueryCloseable)((Object)referenceOwner)).isClosed();
                    if (!closed) continue;
                    ise.addSuppressed(new IllegalStateException("Closed " + this.asString(referenceOwner)));
                }
                catch (Throwable t) {
                    ise.addSuppressed(new IllegalStateException("Closed unknown " + this.asString(referenceOwner), t));
                }
                continue;
            }
            try {
                Method isClosed = referenceOwner.getClass().getDeclaredMethod("isClosed", new Class[0]);
                boolean closed = (Boolean)isClosed.invoke((Object)referenceOwner, new Object[0]);
                if (!closed) continue;
                ise.addSuppressed(new IllegalStateException("Closed " + this.asString(referenceOwner)));
            }
            catch (Exception e) {
                ise.addSuppressed(new IllegalStateException("Closed status unknown " + this.asString(referenceOwner), e));
            }
        }
        if (ise.getSuppressed().length > 0) {
            throw ise;
        }
    }
}

