/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.io;

import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.io.ReferenceOwner;
import net.openhft.chronicle.core.io.TracingReferenceCounted;
import net.openhft.chronicle.core.io.VanillaReferenceCounted;
import org.jetbrains.annotations.NotNull;

public interface ReferenceCounted
extends ReferenceOwner {
    @NotNull
    public static ReferenceCounted onReleased(Runnable onRelease) {
        return ReferenceCounted.onReleased(onRelease, false);
    }

    @NotNull
    public static ReferenceCounted onReleased(Runnable onRelease, boolean releaseOnOne) {
        return Jvm.isResourceTracing() ? new TracingReferenceCounted(onRelease, releaseOnOne) : new VanillaReferenceCounted(onRelease, releaseOnOne);
    }

    public void reserve(ReferenceOwner var1) throws IllegalStateException;

    default public void reserveTransfer(ReferenceOwner from, ReferenceOwner to) throws IllegalStateException {
        this.reserve(to);
        this.release(from);
    }

    public boolean tryReserve(ReferenceOwner var1) throws IllegalStateException;

    public void release(ReferenceOwner var1) throws IllegalStateException;

    public void releaseLast(ReferenceOwner var1) throws IllegalStateException;

    default public void releaseLast() throws IllegalStateException {
        this.releaseLast(INIT);
    }

    public int refCount();

    public void throwExceptionBadResourceOwner() throws IllegalStateException;

    default public void throwExceptionIfReleased() throws IllegalStateException {
        if (this.refCount() <= 0) {
            throw new IllegalStateException("Released");
        }
    }
}

