/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.io;

import java.util.Collections;
import java.util.Map;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.StackTrace;
import net.openhft.chronicle.core.UnsafeMemory;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.core.io.ReferenceOwner;
import net.openhft.chronicle.core.util.WeakIdentityHashMap;

public abstract class AbstractCloseable
implements Closeable,
ReferenceOwner {
    private static final long CLOSED_OFFSET;
    static volatile Map<AbstractCloseable, StackTrace> CLOSEABLE_STACK_TRACE_MAP;
    private volatile transient int closed = 0;
    private volatile transient StackTrace createdHere = Jvm.isResourceTracing() ? new StackTrace("Created Here") : null;
    private volatile transient StackTrace closedHere;

    protected AbstractCloseable() {
        Map<AbstractCloseable, StackTrace> map = CLOSEABLE_STACK_TRACE_MAP;
        if (map != null) {
            map.put(this, new StackTrace("Created here"));
        }
    }

    public static void enableCloseableTracing() {
        CLOSEABLE_STACK_TRACE_MAP = Collections.synchronizedMap(new WeakIdentityHashMap());
    }

    public static void disableCloseableTracing() {
        CLOSEABLE_STACK_TRACE_MAP = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void assertCloseablesClosed() {
        Map<AbstractCloseable, StackTrace> traceMap = CLOSEABLE_STACK_TRACE_MAP;
        if (traceMap == null) {
            Jvm.warn().on(AbstractCloseable.class, "closable tracing disabled");
            return;
        }
        AssertionError openFiles = new AssertionError((Object)"Closeables still open");
        Map<AbstractCloseable, StackTrace> map = traceMap;
        synchronized (map) {
            for (Map.Entry<AbstractCloseable, StackTrace> entry : traceMap.entrySet()) {
                AbstractCloseable key = entry.getKey();
                if (key != null && !key.isClosed()) {
                    ((Throwable)((Object)openFiles)).addSuppressed(entry.getValue());
                }
                Closeable.closeQuietly((Object)key);
            }
        }
        if (((Throwable)((Object)openFiles)).getSuppressed().length > 0) {
            throw openFiles;
        }
    }

    public static void unmonitor(AbstractCloseable closeable) {
        if (CLOSEABLE_STACK_TRACE_MAP != null) {
            CLOSEABLE_STACK_TRACE_MAP.remove(closeable);
        }
    }

    @Override
    public final void close() {
        if (UnsafeMemory.UNSAFE.getAndSetInt(this, CLOSED_OFFSET, 1) != 0) {
            return;
        }
        this.closedHere = Jvm.isResourceTracing() ? new StackTrace("Closed here") : null;
        this.performClose();
    }

    @Override
    public void throwExceptionIfClosed() throws IllegalStateException {
        if (this.isClosed()) {
            throw new IllegalStateException("Closed", this.closedHere);
        }
    }

    protected void warnIfNotClosed() {
        if (!this.isClosed()) {
            if (Jvm.isResourceTracing()) {
                Jvm.warn().on(this.getClass(), "Discarded without closing", new IllegalStateException(this.createdHere));
            }
            this.close();
        }
    }

    protected abstract void performClose();

    @Override
    public boolean isClosed() {
        return this.closed != 0;
    }

    static {
        AbstractCloseable.enableCloseableTracing();
        CLOSED_OFFSET = UnsafeMemory.UNSAFE.objectFieldOffset(Jvm.getField(AbstractCloseable.class, "closed"));
    }
}

