/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.cooler;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import net.openhft.chronicle.core.UnsafeMemory;
import net.openhft.chronicle.core.cooler.CpuCooler;
import net.openhft.chronicle.core.util.Histogram;

public class CoolerTester {
    static Object blackhole;
    private final List<CpuCooler> disturbers = new ArrayList<CpuCooler>();
    private final List<Histogram> histograms = new ArrayList<Histogram>();
    private final List<String> testNames = new ArrayList<String>();
    private final List<Callable> tests = new ArrayList<Callable>();
    private int repeat = 10;
    private int runTimeMS = 5000;
    private int minCount = 20;
    private int maxCount = 20000;

    public CoolerTester(Callable tested, CpuCooler ... disturbers) {
        Collections.addAll(this.disturbers, disturbers);
        this.testNames.add("");
        this.tests.add(tested);
    }

    public CoolerTester(CpuCooler ... disturbers) {
        Collections.addAll(this.disturbers, disturbers);
    }

    public CoolerTester(CpuCooler disturber, Callable ... tests) {
        this.disturbers.add(disturber);
        Collections.addAll(this.tests, tests);
    }

    static void innerloop0(Callable tested, CpuCooler disturber, Histogram histogram, long start, int count, int minCount, int runTimeMS, int maxCount) throws Exception {
        do {
            CoolerTester.innerLoop2(tested, histogram);
        } while (++count < minCount || System.currentTimeMillis() - start <= (long)runTimeMS && count < maxCount);
    }

    static void innerloop1(Callable tested, CpuCooler disturber, Histogram histogram, long start, int count, int minCount, int runTimeMS, int maxCount) throws Exception {
        do {
            disturber.disturb();
            CoolerTester.innerLoop2(tested, histogram);
        } while (++count < minCount || System.currentTimeMillis() - start <= (long)runTimeMS && count < maxCount);
    }

    private static void innerLoop2(Callable tested, Histogram histogram) throws Exception {
        UnsafeMemory.UNSAFE.fullFence();
        long start0 = System.nanoTime();
        blackhole = tested.call();
        long time0 = System.nanoTime() - start0;
        histogram.sample(time0);
    }

    public CoolerTester add(String name, Callable test) {
        this.testNames.add(name);
        this.tests.add(test);
        return this;
    }

    public int repeat() {
        return this.repeat;
    }

    public CoolerTester repeat(int repeat) {
        this.repeat = repeat;
        return this;
    }

    public int runTimeMS() {
        return this.runTimeMS;
    }

    public CoolerTester runTimeMS(int runTimeMS) {
        this.runTimeMS = runTimeMS;
        return this;
    }

    public int minCount() {
        return this.minCount;
    }

    public CoolerTester minCount(int minCount) {
        this.minCount = minCount;
        return this;
    }

    public int maxCount() {
        return this.maxCount;
    }

    public CoolerTester maxCount(int maxCount) {
        this.maxCount = maxCount;
        return this;
    }

    public void run() {
        try {
            System.out.println("---- Warmup ----");
            for (int j = 0; j < this.tests.size(); ++j) {
                for (int i = 0; i < this.disturbers.size(); ++i) {
                    this.histograms.add(new Histogram(32, 7));
                }
            }
            for (int t = 0; t <= this.repeat; ++t) {
                if (t == 1) {
                    System.out.println("\n---- Real Tests ----");
                }
                if (t == this.repeat) {
                    System.out.println("\n---- RESULTS ----\n");
                }
                for (int j = 0; j < this.tests.size(); ++j) {
                    Callable tested = this.tests.get(j);
                    for (int i = 0; i < this.disturbers.size(); ++i) {
                        CpuCooler disturber = this.disturbers.get(i);
                        Histogram histogram = this.histograms.get(j * this.disturbers.size() + i);
                        long start = System.currentTimeMillis();
                        int count = 0;
                        if (t > 0) {
                            CoolerTester.innerloop1(tested, disturber, histogram, start, count, this.minCount, this.runTimeMS, this.maxCount);
                        } else {
                            CoolerTester.innerloop0(tested, disturber, histogram, start, count, this.minCount, this.runTimeMS, this.maxCount);
                        }
                        if (this.tests.size() > 1) {
                            System.out.print(this.testNames.get(j) + " ");
                        }
                        System.out.print(disturber);
                        System.out.println(" - " + histogram.toLongMicrosFormat());
                        if (t != 0) continue;
                        histogram.reset();
                    }
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

