/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.jlbh;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import net.openhft.affinity.Affinity;
import net.openhft.affinity.AffinityLock;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.jlbh.JLBHOptions;
import net.openhft.chronicle.core.util.Histogram;
import net.openhft.chronicle.core.util.NanoSampler;
import org.jetbrains.annotations.NotNull;

public class JLBH
implements NanoSampler {
    private static final Double[] NO_DOUBLES = new Double[0];
    private final SortedMap<String, Histogram> additionHistograms = new ConcurrentSkipListMap<String, Histogram>();
    private final long latencyBetweenTasks;
    @NotNull
    private final JLBHOptions jlbhOptions;
    @NotNull
    private Histogram endToEndHistogram = new Histogram();
    @NotNull
    private Histogram osJitterHistogram = new Histogram();
    private long noResultsReturned;
    @NotNull
    private AtomicBoolean warmUpComplete = new AtomicBoolean(false);
    private boolean warmedUp;

    public JLBH(@NotNull JLBHOptions jlbhOptions) {
        this.jlbhOptions = jlbhOptions;
        if (jlbhOptions.jlbhTask == null) {
            throw new IllegalStateException("jlbhTask must be set");
        }
        this.latencyBetweenTasks = jlbhOptions.throughputTimeUnit.toNanos(1L) / (long)jlbhOptions.throughput;
    }

    public NanoSampler addProbe(String name) {
        return this.additionHistograms.computeIfAbsent(name, n -> new Histogram());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        this.jlbhOptions.jlbhTask.init(this);
        OSJitterMonitor osJitterMonitor = new OSJitterMonitor();
        ArrayList<double[]> percentileRuns = new ArrayList<double[]>();
        TreeMap additionalPercentileRuns = new TreeMap();
        if (this.jlbhOptions.recordOSJitter) {
            osJitterMonitor.setDaemon(true);
            osJitterMonitor.start();
        }
        long warmupStart = System.currentTimeMillis();
        for (int i = 0; i < this.jlbhOptions.warmUpIterations; ++i) {
            this.jlbhOptions.jlbhTask.run(System.nanoTime());
        }
        AffinityLock lock = Affinity.acquireLock();
        try {
            for (int run = 0; run < this.jlbhOptions.runs; ++run) {
                long runStart = System.currentTimeMillis();
                long startTimeNs = System.nanoTime();
                for (int i = 0; i < this.jlbhOptions.iterations; ++i) {
                    if (i == 0 && run == 0) {
                        while (!this.warmUpComplete.get()) {
                            Jvm.pause(2000L);
                            System.out.println("Complete: " + this.noResultsReturned);
                        }
                        System.out.println("Warm up complete (" + this.jlbhOptions.warmUpIterations + " iterations took " + (double)(System.currentTimeMillis() - warmupStart) / 1000.0 + "s)");
                        if (this.jlbhOptions.pauseAfterWarmupMS != 0) {
                            System.out.println("Pausing after warmup for " + this.jlbhOptions.pauseAfterWarmupMS + "ms");
                            Jvm.pause(this.jlbhOptions.pauseAfterWarmupMS);
                        }
                        runStart = System.currentTimeMillis();
                        startTimeNs = System.nanoTime();
                    } else if (this.jlbhOptions.accountForCoordinatedOmission) {
                        long millis = ((startTimeNs += this.latencyBetweenTasks) - System.nanoTime()) / 1000000L - 2L;
                        if (millis > 0L) {
                            Jvm.pause(millis);
                        }
                        Jvm.busyWaitUntil(startTimeNs);
                    } else {
                        if ((double)this.latencyBetweenTasks > 2000000.0) {
                            long end = System.nanoTime() + this.latencyBetweenTasks;
                            Jvm.pause(this.latencyBetweenTasks / 1000000L - 1L);
                            Jvm.busyWaitUntil(end);
                        } else {
                            Jvm.busyWaitMicros(this.latencyBetweenTasks / 1000L);
                        }
                        startTimeNs = System.nanoTime();
                    }
                    this.jlbhOptions.jlbhTask.run(startTimeNs);
                }
                while (this.endToEndHistogram.totalCount() < (long)this.jlbhOptions.iterations) {
                    Thread.yield();
                }
                long totalRunTime = System.currentTimeMillis() - runStart;
                percentileRuns.add(this.endToEndHistogram.getPercentiles());
                System.out.println("-------------------------------- BENCHMARK RESULTS (RUN " + (run + 1) + ") --------------------------------------------------------");
                System.out.println("Run time: " + (double)totalRunTime / 1000.0 + "s");
                System.out.println("Correcting for co-ordinated:" + this.jlbhOptions.accountForCoordinatedOmission);
                System.out.println("Target throughput:" + this.jlbhOptions.throughput + "/" + this.timeUnitToString(this.jlbhOptions.throughputTimeUnit) + " = 1 message every " + this.latencyBetweenTasks / 1000L + "us");
                System.out.printf("%-48s", String.format("End to End: (%,d)", this.endToEndHistogram.totalCount()));
                System.out.println(this.endToEndHistogram.toMicrosFormat());
                if (this.additionHistograms.size() > 0) {
                    this.additionHistograms.entrySet().forEach(e -> {
                        List ds = additionalPercentileRuns.computeIfAbsent(e.getKey(), i -> new ArrayList());
                        ds.add(((Histogram)e.getValue()).getPercentiles());
                        System.out.printf("%-48s", String.format("%s (%,d) ", e.getKey(), ((Histogram)e.getValue()).totalCount()));
                        System.out.println(((Histogram)e.getValue()).toMicrosFormat());
                    });
                }
                if (this.jlbhOptions.recordOSJitter) {
                    System.out.printf("%-48s", String.format("OS Jitter (%,d)", this.osJitterHistogram.totalCount()));
                    System.out.println(this.osJitterHistogram.toMicrosFormat());
                }
                System.out.println("-------------------------------------------------------------------------------------------------------------------");
                this.noResultsReturned = 0L;
                this.endToEndHistogram.reset();
                this.additionHistograms.values().forEach(Histogram::reset);
                osJitterMonitor.reset();
            }
        }
        finally {
            Jvm.pause(5L);
            lock.release();
            Jvm.pause(5L);
        }
        this.printPercentilesSummary("end to end", percentileRuns);
        if (additionalPercentileRuns.size() > 0) {
            additionalPercentileRuns.entrySet().forEach(e -> this.printPercentilesSummary((String)e.getKey(), (List)e.getValue()));
        }
        this.jlbhOptions.jlbhTask.complete();
    }

    private void printPercentilesSummary(String label, @NotNull List<double[]> percentileRuns) {
        System.out.println("-------------------------------- SUMMARY (" + label + ")------------------------------------------------------------");
        ArrayList<Double> consistencies = new ArrayList<Double>();
        double maxValue = Double.MIN_VALUE;
        double minValue = Double.MAX_VALUE;
        int length = percentileRuns.get(0).length;
        for (int i = 0; i < length; ++i) {
            boolean skipFirst;
            boolean bl = skipFirst = length > 3;
            if (this.jlbhOptions.skipFirstRun == JLBHOptions.SKIP_FIRST_RUN.SKIP) {
                skipFirst = true;
            } else if (this.jlbhOptions.skipFirstRun == JLBHOptions.SKIP_FIRST_RUN.NO_SKIP) {
                skipFirst = false;
            }
            for (double[] percentileRun : percentileRuns) {
                if (skipFirst) {
                    skipFirst = false;
                    continue;
                }
                double v = percentileRun[i];
                if (v > maxValue) {
                    maxValue = v;
                }
                if (!(v < minValue)) continue;
                minValue = v;
            }
            consistencies.add(100.0 * (maxValue - minValue) / (maxValue + minValue / 2.0));
            maxValue = Double.MIN_VALUE;
            minValue = Double.MAX_VALUE;
        }
        ArrayList<Double> summary = new ArrayList<Double>();
        for (int i = 0; i < length; ++i) {
            for (double[] percentileRun : percentileRuns) {
                summary.add(percentileRun[i] / 1000.0);
            }
            summary.add((Double)consistencies.get(i));
        }
        StringBuilder sb = new StringBuilder();
        this.addHeaderToPrint(sb, this.jlbhOptions.runs);
        System.out.println(sb.toString());
        sb = new StringBuilder();
        this.addPrToPrint(sb, "50:     ", this.jlbhOptions.runs);
        this.addPrToPrint(sb, "90:     ", this.jlbhOptions.runs);
        this.addPrToPrint(sb, "99:     ", this.jlbhOptions.runs);
        this.addPrToPrint(sb, "99.9:   ", this.jlbhOptions.runs);
        this.addPrToPrint(sb, "99.99:  ", this.jlbhOptions.runs);
        if (this.jlbhOptions.iterations > 1000000) {
            this.addPrToPrint(sb, "99.999: ", this.jlbhOptions.runs);
        }
        if (this.jlbhOptions.iterations > 10000000) {
            this.addPrToPrint(sb, "99.9999:", this.jlbhOptions.runs);
        }
        this.addPrToPrint(sb, "worst:  ", this.jlbhOptions.runs);
        System.out.printf(sb.toString(), summary.toArray(NO_DOUBLES));
        System.out.println("-------------------------------------------------------------------------------------------------------------------");
    }

    private void addPrToPrint(@NotNull StringBuilder sb, String pr, int runs) {
        sb.append(pr);
        for (int i = 0; i < runs; ++i) {
            sb.append("%12.2f ");
        }
        sb.append("%12.2f");
        sb.append("%n");
    }

    private void addHeaderToPrint(@NotNull StringBuilder sb, int runs) {
        sb.append("Percentile");
        for (int i = 1; i < runs + 1; ++i) {
            if (i == 1) {
                sb.append("   run").append(i);
                continue;
            }
            sb.append("         run").append(i);
        }
        sb.append("      % Variation");
    }

    private String timeUnitToString(@NotNull TimeUnit timeUnit) {
        switch (timeUnit) {
            case NANOSECONDS: {
                return "ns";
            }
            case MICROSECONDS: {
                return "us";
            }
            case MILLISECONDS: {
                return "ms";
            }
            case SECONDS: {
                return "s";
            }
            case MINUTES: {
                return "min";
            }
            case HOURS: {
                return "h";
            }
            case DAYS: {
                return "day";
            }
        }
        throw new IllegalArgumentException("Unrecognized time unit value '" + (Object)((Object)timeUnit) + "'");
    }

    @Override
    public void sampleNanos(long nanos) {
        this.sample(nanos);
    }

    public void sample(long nanoTime) {
        ++this.noResultsReturned;
        if (this.noResultsReturned < (long)this.jlbhOptions.warmUpIterations && !this.warmedUp) {
            this.endToEndHistogram.sample(nanoTime);
            return;
        }
        if (this.noResultsReturned == (long)this.jlbhOptions.warmUpIterations && !this.warmedUp) {
            this.warmedUp = true;
            this.endToEndHistogram.reset();
            if (this.additionHistograms.size() > 0) {
                this.additionHistograms.values().forEach(Histogram::reset);
            }
            this.warmUpComplete.set(true);
            return;
        }
        this.endToEndHistogram.sample(nanoTime);
    }

    private class OSJitterMonitor
    extends Thread {
        final AtomicBoolean reset = new AtomicBoolean(false);

        private OSJitterMonitor() {
        }

        @Override
        public void run() {
            Affinity.setAffinity((BitSet)AffinityLock.BASE_AFFINITY);
            AffinityLock affinityLock = null;
            if (((JLBH)JLBH.this).jlbhOptions.jitterAffinity) {
                System.out.println("Jitter thread running with affinity.");
                affinityLock = AffinityLock.acquireLock();
            }
            try {
                long lastTime;
                long start = lastTime = System.nanoTime();
                while (true) {
                    if (this.reset.compareAndSet(true, false)) {
                        JLBH.this.osJitterHistogram.reset();
                        lastTime = System.nanoTime();
                    }
                    for (int i = 0; i < 1000; ++i) {
                        long time = System.nanoTime();
                        if (time - lastTime > (long)((JLBH)JLBH.this).jlbhOptions.recordJitterGreaterThanNs) {
                            JLBH.this.osJitterHistogram.sample(time - lastTime);
                        }
                        lastTime = time;
                    }
                    if (!((double)lastTime > (double)start + 6.0E10)) continue;
                    Jvm.pause(1L);
                }
            }
            catch (Throwable throwable) {
                if (affinityLock != null) {
                    affinityLock.release();
                }
                throw throwable;
            }
        }

        void reset() {
            this.reset.set(true);
        }
    }
}

