/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.management.ManagementFactory;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.channels.FileChannel;
import java.util.Random;
import java.util.Scanner;
import java.util.concurrent.atomic.AtomicLong;
import net.openhft.chronicle.core.ClassLocal;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.Maths;
import net.openhft.chronicle.core.Memory;
import net.openhft.chronicle.core.ReferenceCounted;
import net.openhft.chronicle.core.UnsafeMemory;
import net.openhft.chronicle.core.util.ThrowingFunction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.nio.ch.FileChannelImpl;

public final class OS
extends Enum<OS> {
    public static final String TMP;
    public static final String TARGET;
    public static final String USER_DIR;
    private static final String HOST_NAME;
    private static final String USER_NAME;
    private static final Logger LOG;
    private static final int MAP_RO = 0;
    private static final int MAP_RW = 1;
    private static final int MAP_PV = 2;
    private static final boolean IS64BIT;
    private static final int PROCESS_ID;
    @Nullable
    private static final Memory MEMORY;
    private static final String OS;
    private static final boolean IS_LINUX;
    private static final boolean IS_MAC;
    private static final boolean IS_WIN;
    private static final boolean IS_WIN10;
    private static final int MAP_ALIGNMENT;
    private static final Method UNMAPP0;
    private static final AtomicLong memoryMapped;
    private static MethodHandle UNMAPP0_MH;
    static final ClassLocal<MethodHandle> MAP0_MH;
    private static final /* synthetic */ OS[] $VALUES;

    public static OS[] values() {
        return (OS[])$VALUES.clone();
    }

    public static OS valueOf(String name) {
        return Enum.valueOf(OS.class, name);
    }

    @NotNull
    private static String findTarget() {
        for (File dir = new File(System.getProperty("user.dir")); dir != null; dir = dir.getParentFile()) {
            File target = new File(dir, "target");
            if (!target.exists()) continue;
            return target.getAbsolutePath();
        }
        return TMP + "/target";
    }

    @NotNull
    public static String findDir(@NotNull String suffix) throws FileNotFoundException {
        for (String s : System.getProperty("java.class.path").split(":")) {
            if (!s.endsWith(suffix) || !new File(s).isDirectory()) continue;
            return s;
        }
        throw new FileNotFoundException(suffix);
    }

    @NotNull
    public static File findFile(String ... path) {
        File dir = new File(".").getAbsoluteFile();
        for (int i = 0; i < path.length - 1; ++i) {
            File dir2 = new File(dir, path[i]);
            if (!dir2.isDirectory()) continue;
            dir = dir2;
        }
        return new File(dir, path[path.length - 1]);
    }

    public static String getHostName() {
        return HOST_NAME;
    }

    public static String getUserName() {
        return USER_NAME;
    }

    public static String getTarget() {
        return TARGET;
    }

    private static String getHostName0() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            return "localhost";
        }
    }

    @Nullable
    private static Memory getMemory() {
        Memory memory = null;
        try {
            Class<Memory> java9MemoryClass = Class.forName("software.chronicle.enterprise.core.Java9Memory").asSubclass(Memory.class);
            Method create = java9MemoryClass.getMethod("create", new Class[0]);
            memory = (Memory)create.invoke(null, new Object[0]);
        }
        catch (ClassNotFoundException java9MemoryClass) {
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | InvocationTargetException e) {
            Jvm.warn().on(OS.class, "Unable to load Java9MemoryClass", e);
        }
        if (memory == null) {
            memory = UnsafeMemory.INSTANCE;
        }
        return memory;
    }

    @Nullable
    public static Memory memory() {
        return MEMORY;
    }

    public static long pageAlign(long size) {
        long mask = net.openhft.chronicle.core.OS.pageSize() - 1;
        return size + mask & (mask ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public static int pageSize() {
        return net.openhft.chronicle.core.OS.memory().pageSize();
    }

    public static long mapAlign(long offset) {
        int chunkMultiple = MAP_ALIGNMENT;
        return (offset + (long)chunkMultiple - 1L) / (long)chunkMultiple * (long)chunkMultiple;
    }

    public static long mapAlignment() {
        return MAP_ALIGNMENT;
    }

    public static boolean is64Bit() {
        return IS64BIT;
    }

    private static boolean is64Bit0() {
        String systemProp = System.getProperty("com.ibm.vm.bitmode");
        if (systemProp != null) {
            return "64".equals(systemProp);
        }
        systemProp = System.getProperty("sun.arch.data.model");
        if (systemProp != null) {
            return "64".equals(systemProp);
        }
        systemProp = System.getProperty("java.vm.version");
        return systemProp != null && systemProp.contains("_64");
    }

    public static int getProcessId() {
        return PROCESS_ID;
    }

    private static int getProcessId0() throws NumberFormatException {
        String pid = null;
        File self = new File("/proc/self");
        try {
            if (self.exists()) {
                pid = self.getCanonicalFile().getName();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (pid == null) {
            pid = ManagementFactory.getRuntimeMXBean().getName().split("@", 0)[0];
        }
        if (pid == null) {
            int rpid = new Random().nextInt(65536);
            Jvm.warn().on(OS.class, "Unable to determine PID, picked a random number=" + rpid);
            return rpid;
        }
        return Integer.parseInt(pid);
    }

    public static boolean isWindows() {
        return IS_WIN;
    }

    public static boolean isMacOSX() {
        return IS_MAC;
    }

    public static boolean isLinux() {
        return IS_LINUX;
    }

    public static long getPidMax() throws NumberFormatException {
        if (net.openhft.chronicle.core.OS.isLinux()) {
            File file = new File("/proc/sys/kernel/pid_max");
            if (file.canRead()) {
                try {
                    return Maths.nextPower2(new Scanner(file).nextLong(), 1L);
                }
                catch (FileNotFoundException e) {
                    Jvm.debug().on(OS.class, e);
                }
            }
        } else if (net.openhft.chronicle.core.OS.isMacOSX()) {
            return 0x1000000L;
        }
        return IS_WIN10 ? 0x100000000L : 65536L;
    }

    public static long map(@NotNull FileChannel fileChannel, FileChannel.MapMode mode, long start, long size) throws IOException, IllegalArgumentException {
        if (net.openhft.chronicle.core.OS.isWindows() && size > 0x100000000L) {
            throw new IllegalArgumentException("Mapping more than 4096 MiB is unusable on Windows, size = " + (size >> 20) + " MiB");
        }
        return net.openhft.chronicle.core.OS.map0(fileChannel, net.openhft.chronicle.core.OS.imodeFor(mode), net.openhft.chronicle.core.OS.mapAlign(start), net.openhft.chronicle.core.OS.pageAlign(size));
    }

    private static long invokeFileChannelMap0(@NotNull MethodHandle map0, @NotNull FileChannel fileChannel, int imode, long start, long size, @NotNull ThrowingFunction<OutOfMemoryError, Long, IOException> errorHandler) throws IOException {
        try {
            return map0.invokeExact((FileChannelImpl)fileChannel, imode, start, size);
        }
        catch (IllegalAccessException e) {
            throw new AssertionError("Method map0 is not accessible", e);
        }
        catch (Throwable e) {
            if (e instanceof OutOfMemoryError) {
                return errorHandler.apply((OutOfMemoryError)e);
            }
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw new IOException(e);
        }
    }

    static long map0(@NotNull FileChannel fileChannel, int imode, long start, long size) throws IOException {
        MethodHandle map0 = MAP0_MH.computeValue(fileChannel.getClass());
        long address = net.openhft.chronicle.core.OS.invokeFileChannelMap0(map0, fileChannel, imode, start, size, oome1 -> {
            System.gc();
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            return net.openhft.chronicle.core.OS.invokeFileChannelMap0(map0, fileChannel, imode, start, size, oome2 -> {
                throw new IOException("Map failed", (Throwable)oome2);
            });
        });
        memoryMapped.addAndGet(size);
        return address;
    }

    public static void unmap(long address, long size) throws IOException {
        try {
            long size2 = net.openhft.chronicle.core.OS.pageAlign(size);
            int n = UNMAPP0_MH.invokeExact(address, size2);
            memoryMapped.addAndGet(-size2);
        }
        catch (Throwable e) {
            throw net.openhft.chronicle.core.OS.asAnIOException(e);
        }
    }

    public static long memoryMapped() {
        return memoryMapped.get();
    }

    @NotNull
    private static IOException asAnIOException(Throwable e) {
        if (e instanceof InvocationTargetException) {
            e = e.getCause();
        }
        if (e instanceof IOException) {
            return (IOException)e;
        }
        return new IOException(e);
    }

    static int imodeFor(FileChannel.MapMode mode) {
        int imode = -1;
        if (FileChannel.MapMode.READ_ONLY.equals(mode)) {
            imode = 0;
        } else if (FileChannel.MapMode.READ_WRITE.equals(mode)) {
            imode = 1;
        } else if (FileChannel.MapMode.PRIVATE.equals(mode)) {
            imode = 2;
        }
        assert (imode >= 0);
        return imode;
    }

    public static long spaceUsed(@NotNull String filename) {
        return net.openhft.chronicle.core.OS.spaceUsed(new File(filename));
    }

    private static long spaceUsed(@NotNull File file) {
        if (!net.openhft.chronicle.core.OS.isWindows()) {
            try {
                String du_k = net.openhft.chronicle.core.OS.run("du", "-ks", file.getAbsolutePath());
                return Long.parseLong(du_k.substring(0, du_k.indexOf(9)));
            }
            catch (IOException | NumberFormatException e) {
                Jvm.warn().on(OS.class, e);
            }
        }
        return file.length();
    }

    private static String run(String ... cmds) throws IOException {
        ProcessBuilder pb = new ProcessBuilder(cmds);
        pb.redirectErrorStream(true);
        Process process = pb.start();
        StringWriter sw = new StringWriter();
        char[] chars = new char[1024];
        try (InputStreamReader r = new InputStreamReader(process.getInputStream());){
            int len;
            while ((len = r.read(chars)) > 0) {
                sw.write(chars, 0, len);
            }
        }
        return sw.toString();
    }

    public static String userDir() {
        return USER_DIR;
    }

    static {
        $VALUES = new OS[0];
        TMP = System.getProperty("java.io.tmpdir");
        TARGET = System.getProperty("project.build.directory", net.openhft.chronicle.core.OS.findTarget());
        USER_DIR = System.getProperty("user.dir");
        HOST_NAME = net.openhft.chronicle.core.OS.getHostName0();
        USER_NAME = System.getProperty("user.name");
        LOG = LoggerFactory.getLogger(OS.class);
        IS64BIT = net.openhft.chronicle.core.OS.is64Bit0();
        PROCESS_ID = net.openhft.chronicle.core.OS.getProcessId0();
        MEMORY = net.openhft.chronicle.core.OS.getMemory();
        OS = System.getProperty("os.name").toLowerCase();
        IS_LINUX = OS.startsWith("linux");
        IS_MAC = OS.contains("mac");
        IS_WIN = OS.startsWith("win");
        IS_WIN10 = OS.equals("windows 10");
        MAP_ALIGNMENT = net.openhft.chronicle.core.OS.isWindows() ? 65536 : net.openhft.chronicle.core.OS.pageSize();
        memoryMapped = new AtomicLong();
        try {
            UNMAPP0 = FileChannelImpl.class.getDeclaredMethod("unmap0", Long.TYPE, Long.TYPE);
            UNMAPP0.setAccessible(true);
            UNMAPP0_MH = MethodHandles.lookup().unreflect(UNMAPP0);
        }
        catch (NoSuchMethodException e) {
            throw new AssertionError((Object)e);
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
        MAP0_MH = ClassLocal.withInitial(c -> {
            try {
                Method map0 = c.getDeclaredMethod("map0", Integer.TYPE, Long.TYPE, Long.TYPE);
                map0.setAccessible(true);
                return MethodHandles.lookup().unreflect(map0);
            }
            catch (NoSuchMethodException e) {
                throw new AssertionError("Method map0 is not available", e);
            }
            catch (IllegalAccessException e) {
                throw new AssertionError((Object)e);
            }
        });
    }

    public static class Unmapper
    implements Runnable {
        private final long size;
        private volatile long address;

        public Unmapper(long address, long size, ReferenceCounted owner) throws IllegalStateException {
            assert (address != 0L);
            this.address = address;
            this.size = size;
        }

        @Override
        public void run() {
            if (this.address == 0L) {
                return;
            }
            try {
                net.openhft.chronicle.core.OS.unmap(this.address, this.size);
                this.address = 0L;
            }
            catch (IOException | IllegalStateException e) {
                Jvm.warn().on(OS.class, "Error on unmap and release", e);
            }
        }
    }
}

