/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.threads;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.openhft.chronicle.core.Jvm;

public class ThreadDump {
    final Set<Thread> threads;
    final Set<String> ignored = new HashSet<String>();

    public ThreadDump() {
        this.threads = new HashSet<Thread>(Thread.getAllStackTraces().keySet());
        this.ignored.add("Time-limited test");
        this.ignored.add("Attach Listener");
        this.ignored.add("process reaper");
        int max = Runtime.getRuntime().availableProcessors();
        for (int i = 0; i < max; ++i) {
            this.ignored.add("ForkJoinPool.commonPool-worker-" + i);
        }
    }

    public void ignore(String threadName) {
        this.ignored.add(threadName);
    }

    public void assertNoNewThreads() {
        Map<Thread, StackTraceElement[]> allStackTraces = null;
        for (int i = 1; i < 4; ++i) {
            Jvm.pause(i * i * 50);
            allStackTraces = Thread.getAllStackTraces();
            allStackTraces.keySet().removeAll(this.threads);
            if (allStackTraces.isEmpty()) {
                return;
            }
            Iterator<Thread> iter = allStackTraces.keySet().iterator();
            while (iter.hasNext()) {
                Thread next = iter.next();
                if (!this.ignored.contains(next.getName())) continue;
                iter.remove();
            }
            if (allStackTraces.isEmpty()) {
                return;
            }
            for (Map.Entry<Thread, StackTraceElement[]> threadEntry : allStackTraces.entrySet()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Thread still running " + threadEntry.getKey());
                Jvm.trimStackTrace(sb, threadEntry.getValue());
                System.err.println(sb);
            }
        }
        throw new AssertionError((Object)("Threads still running " + allStackTraces.keySet()));
    }
}

