/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.onoes;

import java.util.Map;
import net.openhft.chronicle.core.onoes.ExceptionHandler;
import net.openhft.chronicle.core.onoes.ExceptionKey;
import net.openhft.chronicle.core.onoes.LogLevel;

public class RecordingExceptionHandler
implements ExceptionHandler {
    private final LogLevel level;
    private final Map<ExceptionKey, Integer> exceptionKeyCountMap;
    private final boolean exceptionsOnly;

    public RecordingExceptionHandler(LogLevel level, Map<ExceptionKey, Integer> exceptionKeyCountMap, boolean exceptionsOnly) {
        this.level = level;
        this.exceptionKeyCountMap = exceptionKeyCountMap;
        this.exceptionsOnly = exceptionsOnly;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void on(Class clazz, String message, Throwable thrown) {
        if (this.exceptionsOnly && thrown == null) {
            return;
        }
        if (thrown != null && thrown.getClass() == Throwable.class) {
            return;
        }
        Map<ExceptionKey, Integer> map = this.exceptionKeyCountMap;
        synchronized (map) {
            ExceptionKey key = new ExceptionKey(this.level, clazz, message, thrown);
            this.exceptionKeyCountMap.merge(key, 1, (p, v) -> p == null ? v : p + v);
        }
    }
}

