/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core;

import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicLong;
import org.jetbrains.annotations.NotNull;

public class ReferenceCounter {
    private final AtomicLong value = new AtomicLong(1L);
    private final Runnable onRelease;
    private Queue<Throwable> referenceCountHistory;

    private ReferenceCounter(Runnable onRelease) {
        this.onRelease = onRelease;
        assert (this.newRefCountHistory());
    }

    @NotNull
    public static ReferenceCounter onReleased(Runnable onRelease) {
        return new ReferenceCounter(onRelease);
    }

    private boolean newRefCountHistory() {
        this.referenceCountHistory = new ConcurrentLinkedQueue<Throwable>();
        this.referenceCountHistory.add(new Throwable(Integer.toHexString(this.onRelease.hashCode()) + '-' + Thread.currentThread().getName() + " creation ref-count=" + 1));
        return true;
    }

    public void reserve() throws IllegalStateException {
        long v;
        do {
            if ((v = this.value.get()) > 0L) continue;
            throw new IllegalStateException("Released");
        } while (!this.value.compareAndSet(v, v + 1L));
    }

    public boolean tryReserve() {
        long v;
        do {
            if ((v = this.value.get()) > 0L) continue;
            return false;
        } while (!this.value.compareAndSet(v, v + 1L));
        assert (this.recordResevation(v + 1L));
        return true;
    }

    private boolean recordResevation(long v) {
        this.referenceCountHistory.add(new Throwable(Integer.toHexString(this.onRelease.hashCode()) + '-' + Thread.currentThread().getName() + " Reserve ref-count=" + v));
        return true;
    }

    public void release() throws IllegalStateException {
        block1: {
            long v;
            do {
                if ((v = this.value.get()) > 0L) continue;
                throw new IllegalStateException("Released");
            } while (!this.value.compareAndSet(v, v - 1L));
            if (v != 1L) break block1;
            this.onRelease.run();
        }
    }

    private boolean recordRelease(long v) {
        this.referenceCountHistory.add(new Throwable(Integer.toHexString(this.onRelease.hashCode()) + '-' + Thread.currentThread().getName() + " Release ref-count=" + v));
        return true;
    }

    private boolean logReferenceCountHistory() {
        this.referenceCountHistory.forEach(Throwable::printStackTrace);
        return true;
    }

    public long get() {
        return this.value.get();
    }

    @NotNull
    public String toString() {
        return Long.toString(this.value.get());
    }
}

