/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.util;

import java.util.concurrent.locks.LockSupport;

public enum Time {

    static volatile long lastTime = System.currentTimeMillis();
    static volatile long tickTime = 0L;

    public static long currentTimeMillis() {
        long now = System.currentTimeMillis();
        if (now == lastTime) {
            return now;
        }
        ++tickTime;
        lastTime = now;
        return lastTime;
    }

    public static long tickTime() {
        Time.currentTimeMillis();
        return tickTime;
    }

    public static void wait(Object o, long waitTimeMS) throws InterruptedException, IllegalArgumentException {
        long remaining;
        if ((long)((int)waitTimeMS) != waitTimeMS) {
            throw new IllegalArgumentException("waitTimeMS: " + waitTimeMS);
        }
        long end = Time.tickTime() + waitTimeMS;
        while ((remaining = end - Time.tickTime()) > 0L) {
            o.wait(remaining);
        }
    }

    public static void parkNanos(long nanos) {
        long millis = nanos / 1000000L;
        if (millis > 0L) {
            long start = System.currentTimeMillis();
            long startTT = tickTime;
            LockSupport.parkNanos(nanos);
            long end = System.currentTimeMillis();
            long endTT = Math.min(end - start, millis) + startTT;
            if (endTT > tickTime) {
                tickTime = endTT;
            }
        } else {
            Time.currentTimeMillis();
            LockSupport.parkNanos(nanos);
            Time.currentTimeMillis();
        }
    }
}

