/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import net.openhft.chronicle.core.annotation.ForceInline;
import net.openhft.chronicle.core.annotation.NotNull;

public enum StringUtils {

    private static final Constructor<String> STRING_CONSTRUCTOR;
    private static final Field S_VALUE;
    private static final Field SB_VALUE;
    private static final Field SB_COUNT;
    private static final long MAX_VALUE_DIVIDE_10 = 0xCCCCCCCCCCCCCCCL;

    public static boolean endsWith(@org.jetbrains.annotations.NotNull CharSequence source, @org.jetbrains.annotations.NotNull String endsWith) {
        for (int i = 1; i <= endsWith.length(); ++i) {
            if (Character.toLowerCase(source.charAt(source.length() - i)) == Character.toLowerCase(endsWith.charAt(endsWith.length() - i))) continue;
            return false;
        }
        return true;
    }

    @ForceInline
    public static boolean isEqual(CharSequence s, CharSequence cs) {
        if (s == null) {
            return false;
        }
        if (s.length() != cs.length()) {
            return false;
        }
        for (int i = 0; i < cs.length(); ++i) {
            if (s.charAt(i) == cs.charAt(i)) continue;
            return false;
        }
        return true;
    }

    @ForceInline
    public static boolean equalsCaseIgnore(CharSequence s, CharSequence cs) {
        if (s == null) {
            return false;
        }
        if (s.length() != cs.length()) {
            return false;
        }
        for (int i = 0; i < cs.length(); ++i) {
            if (Character.toLowerCase(s.charAt(i)) == Character.toLowerCase(cs.charAt(i))) continue;
            return false;
        }
        return true;
    }

    @ForceInline
    public static String toString(Object o) {
        return o == null ? null : o.toString();
    }

    public static char[] extractChars(StringBuilder sb) {
        try {
            return (char[])SB_VALUE.get(sb);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static char[] extractChars(String s) {
        try {
            return (char[])S_VALUE.get(s);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static void setCount(StringBuilder sb, int count) {
        try {
            SB_COUNT.setInt(sb, count);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static String newString(char[] chars) {
        try {
            return STRING_CONSTRUCTOR.newInstance(chars, true);
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
    }

    public static String firstLowerCase(String str) {
        return Character.toLowerCase(str.charAt(0)) + str.substring(1);
    }

    public static double parseDouble(@NotNull CharSequence in) {
        long value = 0L;
        int exp = 0;
        boolean negative = false;
        int decimalPlaces = Integer.MIN_VALUE;
        char ch = in.charAt(0);
        int pos = 1;
        switch (ch) {
            case 'N': {
                if (StringUtils.compareRest(in, 1, "aN")) {
                    return Double.NaN;
                }
                return Double.NaN;
            }
            case 'I': {
                if (StringUtils.compareRest(in, 1, "nfinity")) {
                    return Double.POSITIVE_INFINITY;
                }
                return Double.NaN;
            }
            case '-': {
                if (StringUtils.compareRest(in, 1, "Infinity")) {
                    return Double.NEGATIVE_INFINITY;
                }
                negative = true;
                ch = in.charAt(pos++);
            }
        }
        while (true) {
            if (ch >= '0' && ch <= '9') {
                while (value >= 0xCCCCCCCCCCCCCCCL) {
                    value >>>= 1;
                    ++exp;
                }
                value = value * 10L + (long)(ch - 48);
                ++decimalPlaces;
            } else {
                if (ch != '.') break;
                decimalPlaces = 0;
            }
            if (pos == in.length()) break;
            ch = in.charAt(pos++);
        }
        return StringUtils.asDouble(value, exp, negative, decimalPlaces);
    }

    private static boolean compareRest(@NotNull CharSequence in, int pos, @NotNull String s) {
        if (s.length() > in.length() - pos) {
            return false;
        }
        for (int i = 0; i < s.length(); ++i) {
            if (in.charAt(i + pos) == s.charAt(i)) continue;
            return false;
        }
        return true;
    }

    private static double asDouble(long value, int exp, boolean negative, int decimalPlaces) {
        if (decimalPlaces > 0 && value < 0x3FFFFFFFFFFFFFFFL) {
            if (value < Integer.MAX_VALUE) {
                exp -= 32;
                value <<= 32;
            }
            if (value < 0x7FFFFFFFFFFFL) {
                exp -= 16;
                value <<= 16;
            }
            if (value < 0x7FFFFFFFFFFFFFL) {
                exp -= 8;
                value <<= 8;
            }
            if (value < 0x7FFFFFFFFFFFFFFL) {
                exp -= 4;
                value <<= 4;
            }
            if (value < 0x1FFFFFFFFFFFFFFFL) {
                exp -= 2;
                value <<= 2;
            }
            if (value < 0x3FFFFFFFFFFFFFFFL) {
                --exp;
                value <<= 1;
            }
        }
        while (decimalPlaces > 0) {
            --exp;
            long mod = value % 5L;
            int modDiv = 1;
            if ((value /= 5L) < 0x7FFFFFFFFFFFFFFL) {
                exp -= 4;
                value <<= 4;
                modDiv <<= 4;
            }
            if (value < 0x1FFFFFFFFFFFFFFFL) {
                exp -= 2;
                value <<= 2;
                modDiv <<= 2;
            }
            if (value < 0x3FFFFFFFFFFFFFFFL) {
                --exp;
                value <<= 1;
                modDiv <<= 1;
            }
            value = decimalPlaces > 1 ? (value += (long)modDiv * mod / 5L) : (value += ((long)modDiv * mod + 4L) / 5L);
            --decimalPlaces;
        }
        double d = Math.scalb((double)value, exp);
        return negative ? -d : d;
    }

    static {
        try {
            STRING_CONSTRUCTOR = String.class.getDeclaredConstructor(char[].class, Boolean.TYPE);
            STRING_CONSTRUCTOR.setAccessible(true);
            S_VALUE = String.class.getDeclaredField("value");
            S_VALUE.setAccessible(true);
            SB_VALUE = Class.forName("java.lang.AbstractStringBuilder").getDeclaredField("value");
            SB_VALUE.setAccessible(true);
            SB_COUNT = Class.forName("java.lang.AbstractStringBuilder").getDeclaredField("count");
            SB_COUNT.setAccessible(true);
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
    }
}

