/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.lang.management.ManagementFactory;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.channels.FileChannel;
import java.util.Random;
import java.util.Scanner;
import net.openhft.chronicle.core.Maths;
import net.openhft.chronicle.core.Memory;
import net.openhft.chronicle.core.ReferenceCounted;
import net.openhft.chronicle.core.UnsafeMemory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.nio.ch.FileChannelImpl;

public class OS {
    private static final String HOST_NAME = net.openhft.chronicle.core.OS.getHostName0();
    private static final String USER_NAME = System.getProperty("user.name");
    private static final String TMP = System.getProperty("java.io.tmpdir");
    public static final String TARGET = System.getProperty("project.build.directory", TMP + "/target");
    private static final Logger LOG = LoggerFactory.getLogger(OS.class);
    private static final int MAP_RO = 0;
    private static final int MAP_RW = 1;
    private static final int MAP_PV = 2;
    private static final boolean IS64BIT = net.openhft.chronicle.core.OS.is64Bit0();
    private static final int PROCESS_ID = net.openhft.chronicle.core.OS.getProcessId0();
    private static final Memory MEMORY = net.openhft.chronicle.core.OS.getMemory();
    private static final String OS = System.getProperty("os.name").toLowerCase();
    private static final boolean IS_LINUX = OS.startsWith("linux");
    private static final boolean IS_MAC = OS.contains("mac");
    private static final boolean IS_WIN = OS.startsWith("win");
    private static final int MAP_ALIGNMENT = net.openhft.chronicle.core.OS.isWindows() ? 65536 : net.openhft.chronicle.core.OS.pageSize();

    public static String getHostName() {
        return HOST_NAME;
    }

    public static String getUserName() {
        return USER_NAME;
    }

    public static String getTarget() {
        return TARGET;
    }

    private static String getHostName0() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            return "localhost";
        }
    }

    private static Memory getMemory() {
        Memory memory = null;
        try {
            Class<Memory> java9MemoryClass = Class.forName("software.chronicle.enterprise.core.Java9Memory").asSubclass(Memory.class);
            Method create = java9MemoryClass.getMethod("create", new Class[0]);
            memory = (Memory)create.invoke(null, new Object[0]);
        }
        catch (ClassNotFoundException java9MemoryClass) {
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | InvocationTargetException e) {
            LOG.warn("Unable to load Java9MemoryClass", (Throwable)e);
        }
        if (memory == null) {
            memory = UnsafeMemory.create();
        }
        return memory;
    }

    public static Memory memory() {
        return MEMORY;
    }

    public static int pageSize() {
        return net.openhft.chronicle.core.OS.memory().pageSize();
    }

    public static long mapAlign(long size) {
        int chunkMultiple = MAP_ALIGNMENT;
        return (size + (long)chunkMultiple - 1L) / (long)chunkMultiple * (long)chunkMultiple;
    }

    public static boolean is64Bit() {
        return IS64BIT;
    }

    private static boolean is64Bit0() {
        String systemProp = System.getProperty("com.ibm.vm.bitmode");
        if (systemProp != null) {
            return "64".equals(systemProp);
        }
        systemProp = System.getProperty("sun.arch.data.model");
        if (systemProp != null) {
            return "64".equals(systemProp);
        }
        systemProp = System.getProperty("java.vm.version");
        return systemProp != null && systemProp.contains("_64");
    }

    public static int getProcessId() {
        return PROCESS_ID;
    }

    private static int getProcessId0() throws NumberFormatException {
        String pid = null;
        File self = new File("/proc/self");
        try {
            if (self.exists()) {
                pid = self.getCanonicalFile().getName();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (pid == null) {
            pid = ManagementFactory.getRuntimeMXBean().getName().split("@", 0)[0];
        }
        if (pid == null) {
            int rpid = new Random().nextInt(65536);
            LOG.warn("Unable to determine PID, picked a random number=" + rpid);
            return rpid;
        }
        return Integer.parseInt(pid);
    }

    public static boolean isWindows() {
        return IS_WIN;
    }

    private static boolean isMacOSX() {
        return IS_MAC;
    }

    private static boolean isLinux() {
        return IS_LINUX;
    }

    public static long getPidMax() throws NumberFormatException {
        if (net.openhft.chronicle.core.OS.isLinux()) {
            File file = new File("/proc/sys/kernel/pid_max");
            if (file.canRead()) {
                try {
                    return Maths.nextPower2(new Scanner(file).nextLong(), 1L);
                }
                catch (FileNotFoundException e) {
                    LOG.warn("", (Throwable)e);
                }
            }
        } else if (net.openhft.chronicle.core.OS.isMacOSX()) {
            return 0x1000000L;
        }
        return 65536L;
    }

    public static long map(FileChannel fileChannel, FileChannel.MapMode mode, long start, long size) throws IOException, IllegalArgumentException {
        if (net.openhft.chronicle.core.OS.isWindows() && size > 0x100000000L) {
            throw new IllegalArgumentException("Mapping more than 4096 MiB is unusable on Windows, size = " + (size >> 20) + " MiB");
        }
        try {
            return net.openhft.chronicle.core.OS.map0(fileChannel, net.openhft.chronicle.core.OS.imodeFor(mode), net.openhft.chronicle.core.OS.mapAlign(start), net.openhft.chronicle.core.OS.mapAlign(size));
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            throw new AssertionError((Object)e);
        }
        catch (InvocationTargetException e) {
            throw net.openhft.chronicle.core.OS.asAnIOException(e);
        }
    }

    static long map0(FileChannel fileChannel, int imode, long start, long size) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, IllegalArgumentException {
        Method map0 = fileChannel.getClass().getDeclaredMethod("map0", Integer.TYPE, Long.TYPE, Long.TYPE);
        map0.setAccessible(true);
        return (Long)map0.invoke((Object)fileChannel, imode, start, size);
    }

    public static void unmap(long address, long size) throws IOException {
        try {
            Method unmap0 = FileChannelImpl.class.getDeclaredMethod("unmap0", Long.TYPE, Long.TYPE);
            unmap0.setAccessible(true);
            unmap0.invoke(null, address, net.openhft.chronicle.core.OS.mapAlign(size));
        }
        catch (Exception e) {
            throw net.openhft.chronicle.core.OS.asAnIOException(e);
        }
    }

    private static IOException asAnIOException(Throwable e) {
        if (e instanceof InvocationTargetException) {
            e = e.getCause();
        }
        if (e instanceof IOException) {
            return (IOException)e;
        }
        return new IOException(e);
    }

    static int imodeFor(FileChannel.MapMode mode) {
        int imode = -1;
        if (mode == FileChannel.MapMode.READ_ONLY) {
            imode = 0;
        } else if (mode == FileChannel.MapMode.READ_WRITE) {
            imode = 1;
        } else if (mode == FileChannel.MapMode.PRIVATE) {
            imode = 2;
        }
        assert (imode >= 0);
        return imode;
    }

    public static long spaceUsed(String filename) {
        return net.openhft.chronicle.core.OS.spaceUsed(new File(filename));
    }

    private static long spaceUsed(File file) throws NumberFormatException {
        if (!net.openhft.chronicle.core.OS.isWindows()) {
            try {
                String du_k = net.openhft.chronicle.core.OS.run("du", "-ks", file.getAbsolutePath());
                return Long.parseLong(du_k.substring(0, du_k.indexOf(9)));
            }
            catch (IOException e) {
                LOG.error("", (Throwable)e);
            }
        }
        return file.length();
    }

    private static String run(String ... cmds) throws IOException {
        ProcessBuilder pb = new ProcessBuilder(cmds);
        pb.redirectErrorStream(true);
        Process process = pb.start();
        StringWriter sw = new StringWriter();
        char[] chars = new char[1024];
        try (InputStreamReader r = new InputStreamReader(process.getInputStream());){
            int len;
            while ((len = r.read(chars)) > 0) {
                sw.write(chars, 0, len);
            }
        }
        return sw.toString();
    }

    public static class Unmapper
    implements Runnable {
        private final long size;
        private final ReferenceCounted owner;
        private volatile long address;

        public Unmapper(long address, long size, ReferenceCounted owner) throws IllegalStateException {
            owner.reserve();
            this.owner = owner;
            assert (address != 0L);
            this.address = address;
            this.size = size;
        }

        @Override
        public void run() {
            if (this.address == 0L) {
                return;
            }
            try {
                net.openhft.chronicle.core.OS.unmap(this.address, this.size);
                this.address = 0L;
                this.owner.release();
            }
            catch (IOException | IllegalStateException e) {
                LOG.error("Error on unmap and release", (Throwable)e);
            }
        }
    }
}

