/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes.ref;

import java.nio.BufferOverflowException;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.HexDumpBytes;
import net.openhft.chronicle.bytes.ref.AbstractReference;
import net.openhft.chronicle.bytes.ref.LongReference;
import net.openhft.chronicle.core.annotation.NonNegative;
import org.jetbrains.annotations.NotNull;

public class BinaryLongReference
extends AbstractReference
implements LongReference {
    public static final long LONG_NOT_COMPLETE = -1L;

    @Override
    public void bytesStore(@NotNull BytesStore bytes, @NonNegative long offset, @NonNegative long length) throws IllegalStateException, IllegalArgumentException, BufferOverflowException {
        this.throwExceptionIfClosed();
        if (length != this.maxSize()) {
            throw new IllegalArgumentException();
        }
        if (bytes instanceof HexDumpBytes) {
            offset &= 0xFFFFFFFFL;
        }
        super.bytesStore(bytes, offset, length);
    }

    @Override
    public long maxSize() {
        return 8L;
    }

    @NotNull
    public String toString() {
        if (this.bytesStore == null) {
            return "bytes is null";
        }
        try {
            return "value: " + this.getValue();
        }
        catch (Throwable e) {
            return e.toString();
        }
    }

    public long getValue() throws IllegalStateException {
        return this.bytesStore == null ? 0L : this.bytesStore.readLong(this.offset);
    }

    public void setValue(long value) throws IllegalStateException {
        try {
            this.bytesStore.writeLong(this.offset, value);
        }
        catch (NullPointerException e) {
            this.throwExceptionIfClosed();
            throw e;
        }
    }

    public long getVolatileValue() throws IllegalStateException {
        try {
            return this.bytesStore.readVolatileLong(this.offset);
        }
        catch (NullPointerException e) {
            this.throwExceptionIfClosed();
            throw e;
        }
    }

    public void setVolatileValue(long value) throws IllegalStateException {
        try {
            this.bytesStore.writeVolatileLong(this.offset, value);
        }
        catch (NullPointerException e) {
            this.throwExceptionIfClosed();
            throw e;
        }
    }

    public void setOrderedValue(long value) throws IllegalStateException {
        try {
            this.bytesStore.writeOrderedLong(this.offset, value);
        }
        catch (NullPointerException e) {
            this.throwExceptionIfClosed();
            throw e;
        }
    }

    public long addValue(long delta) throws IllegalStateException {
        try {
            return this.bytesStore.addAndGetLong(this.offset, delta);
        }
        catch (NullPointerException e) {
            this.throwExceptionIfClosed();
            throw e;
        }
    }

    public long addAtomicValue(long delta) throws IllegalStateException {
        return this.addValue(delta);
    }

    public boolean compareAndSwapValue(long expected, long value) throws IllegalStateException {
        try {
            return this.bytesStore.compareAndSwapLong(this.offset, expected, value);
        }
        catch (NullPointerException e) {
            this.throwExceptionIfClosed();
            throw e;
        }
    }
}

