/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes.internal;

import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import net.openhft.chronicle.core.Jvm;

public final class ByteBuffers {
    private static final Field ADDRESS;
    private static final Field CAPACITY;

    private ByteBuffers() {
    }

    public static void setAddressCapacity(ByteBuffer buffer, long address, long capacity) {
        if (ADDRESS == null || CAPACITY == null) {
            throw new UnsupportedOperationException("Direct ByteBuffer fields not accessible");
        }
        int cap = Math.toIntExact(capacity);
        try {
            ADDRESS.setLong(buffer, address);
            CAPACITY.setInt(buffer, cap);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new AssertionError((Object)e);
        }
    }

    static {
        ByteBuffer direct = ByteBuffer.allocateDirect(0);
        Field address = null;
        Field capacity = null;
        try {
            address = Jvm.getField(direct.getClass(), (String)"address");
            capacity = Jvm.getField(direct.getClass(), (String)"capacity");
        }
        catch (Throwable t) {
            Jvm.warn().on(ByteBuffers.class, "Unable to access direct ByteBuffer fields", t);
        }
        ADDRESS = address;
        CAPACITY = capacity;
    }
}

