/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes.ref;

import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.ref.BinaryLongReference;
import net.openhft.chronicle.bytes.ref.LongReference;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.annotation.NonNegative;
import net.openhft.chronicle.core.io.ReferenceOwner;
import net.openhft.chronicle.core.io.UnsafeCloseable;
import org.jetbrains.annotations.NotNull;

public class UncheckedLongReference
extends UnsafeCloseable
implements LongReference,
ReferenceOwner {
    private BytesStore<?, ?> bytes;

    @NotNull
    public static LongReference create(@NotNull BytesStore<?, ?> bytesStore, @NonNegative long offset, @NonNegative int size) throws IllegalArgumentException, BufferOverflowException, BufferUnderflowException, IllegalStateException {
        @NotNull LongReference ref = Jvm.isDebug() ? new BinaryLongReference() : new UncheckedLongReference();
        ref.bytesStore(bytesStore, offset, size);
        return ref;
    }

    @Override
    public void bytesStore(@NotNull BytesStore bytes, @NonNegative long offset, @NonNegative long length) throws IllegalStateException, IllegalArgumentException, BufferUnderflowException {
        this.throwExceptionIfClosedInSetter();
        if (length != this.maxSize()) {
            throw new IllegalArgumentException();
        }
        if (this.bytes != bytes) {
            if (this.bytes != null) {
                this.bytes.release(this);
            }
            this.bytes = bytes;
            bytes.reserve(this);
        }
        this.address(bytes.addressForRead(offset));
    }

    @Override
    @NotNull
    public BytesStore<?, ?> bytesStore() {
        return this.bytes;
    }

    @Override
    public long offset() {
        return this.address;
    }

    @Override
    public long maxSize() {
        return 8L;
    }

    @NotNull
    public String toString() {
        if (this.address == 0L) {
            return "addressForRead is 0";
        }
        try {
            return "value: " + this.getValue();
        }
        catch (Throwable e) {
            return "value: " + e;
        }
    }

    public long getValue() throws IllegalStateException {
        return this.getLong();
    }

    public void setValue(long value) throws IllegalStateException {
        this.setLong(value);
    }

    public long getVolatileValue() throws IllegalStateException {
        return this.getVolatileLong();
    }

    public void setVolatileValue(long value) throws IllegalStateException {
        this.setVolatileLong(value);
    }

    public long getVolatileValue(long closedValue) {
        return this.getVolatileLong(closedValue);
    }

    public void setOrderedValue(long value) throws IllegalStateException {
        this.setOrderedLong(value);
    }

    public long addValue(long delta) throws IllegalStateException {
        return this.addLong(delta);
    }

    public long addAtomicValue(long delta) throws IllegalStateException {
        return this.addAtomicLong(delta);
    }

    public boolean compareAndSwapValue(long expected, long value) throws IllegalStateException {
        return this.compareAndSwapLong(expected, value);
    }

    protected void performClose() throws IllegalStateException {
        if (this.bytes != null) {
            this.bytes.release(this);
        }
        this.bytes = null;
        super.performClose();
    }
}

