/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes;

import java.lang.reflect.Method;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import net.openhft.chronicle.bytes.BytesMethodWriterInvocationHandler;
import net.openhft.chronicle.bytes.BytesOut;
import net.openhft.chronicle.bytes.MethodEncoder;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.io.InvalidMarshallableException;
import net.openhft.chronicle.core.util.AbstractInvocationHandler;

public class BinaryBytesMethodWriterInvocationHandler
extends AbstractInvocationHandler
implements BytesMethodWriterInvocationHandler {
    private final Function<Method, MethodEncoder> methodToId;
    private final BytesOut<?> out;
    private final Map<Method, MethodEncoder> methodToIdMap = new LinkedHashMap<Method, MethodEncoder>();

    public BinaryBytesMethodWriterInvocationHandler(Class<?> tClass, Function<Method, MethodEncoder> methodToId, BytesOut<?> out) {
        super(tClass);
        this.methodToId = methodToId;
        this.out = out;
    }

    protected Object doInvoke(Object proxy, Method method, Object[] args) throws IllegalStateException, BufferOverflowException, BufferUnderflowException, IllegalArgumentException, ArithmeticException, InvalidMarshallableException {
        MethodEncoder info = this.methodToIdMap.computeIfAbsent(method, this.methodToId);
        if (info == null) {
            Jvm.warn().on(this.getClass(), "Unknown method " + method + " ignored");
        } else {
            long pos = this.out.writePosition();
            try {
                this.out.writeHexDumpDescription(method.getName());
                this.out.writeStopBit(info.messageId());
                info.encode(args, this.out);
            }
            catch (Throwable t) {
                this.out.writePosition(pos);
                throw t;
            }
        }
        return null;
    }
}

